/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermaldynamics.duct.entity;

import cofh.api.block.IBlockConfigGui;
import cofh.core.network.PacketBase;
import cofh.core.network.PacketCoFHBase;
import cofh.core.network.PacketHandler;
import cofh.core.network.PacketTileInfo;
import cofh.lib.util.helpers.BlockHelper;
import cofh.lib.util.helpers.ServerHelper;
import cofh.repack.codechicken.lib.raytracer.RayTracer;
import cofh.thermaldynamics.ThermalDynamics;
import cofh.thermaldynamics.block.SubTileMultiBlock;
import cofh.thermaldynamics.block.TileTDBase;
import cofh.thermaldynamics.duct.BlockDuct;
import cofh.thermaldynamics.duct.attachments.cover.CoverHoleRender;
import cofh.thermaldynamics.duct.entity.EntityTransport;
import cofh.thermaldynamics.duct.entity.TileTransportDuctBaseRoute;
import cofh.thermaldynamics.gui.client.DirectoryEntry;
import cofh.thermaldynamics.gui.client.GuiTransport;
import cofh.thermaldynamics.gui.client.GuiTransportConfig;
import cofh.thermaldynamics.gui.container.ContainerTransport;
import cofh.thermaldynamics.gui.container.ContainerTransportConfig;
import cofh.thermaldynamics.multiblock.IMultiBlockRoute;
import cofh.thermaldynamics.multiblock.Route;
import cofh.thermaldynamics.util.Utils;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.LinkedList;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class TileTransportDuct
extends TileTransportDuctBaseRoute
implements IBlockConfigGui {
    private static final OutputData BLANK_NAME = new OutputData();
    public OutputData data = BLANK_NAME;
    public static final int NETWORK_REQUEST = 0;
    public static final int NETWORK_SETOUTPUTDATA = 1;
    public static final int NETWORK_LIST = 2;
    public static final int NETWORK_CONFIG = 3;

    @Override
    public boolean isOutput() {
        return this.isOutput;
    }

    @Override
    public void handleTileSideUpdate(int n) {
        super.handleTileSideUpdate(n);
        if (this.connectionTypes[n] == TileTDBase.ConnectionTypes.FORCED) {
            this.neighborMultiBlocks[n] = null;
            this.neighborTypes[n] = TileTDBase.NeighborTypes.OUTPUT;
            this.isNode = true;
            this.isOutput = true;
        }
    }

    @Override
    public boolean isBlockedSide(int n) {
        return super.isBlockedSide(n) || this.connectionTypes[n] == TileTDBase.ConnectionTypes.FORCED;
    }

    @Override
    public boolean onWrench(EntityPlayer entityPlayer, int n) {
        if (Utils.isHoldingUsableWrench(entityPlayer, ((TileEntity)this).field_145851_c, ((TileEntity)this).field_145848_d, ((TileEntity)this).field_145849_e)) {
            MovingObjectPosition movingObjectPosition = RayTracer.retraceBlock((World)((TileEntity)this).field_145850_b, (EntityPlayer)entityPlayer, (int)((TileEntity)this).field_145851_c, (int)((TileEntity)this).field_145848_d, (int)((TileEntity)this).field_145849_e);
            if (movingObjectPosition == null) {
                return false;
            }
            int n2 = movingObjectPosition.subHit;
            if (n2 >= 0 && n2 <= 13) {
                int n3 = n2 == 13 ? n : (n2 < 6 ? n2 : n2 - 6);
                this.onNeighborBlockChange();
                TileEntity tileEntity = BlockHelper.getAdjacentTileEntity((TileEntity)this, (int)n3);
                if (this.isConnectable(tileEntity, n3)) {
                    this.connectionTypes[n3] = this.connectionTypes[n3].next();
                    ((TileTDBase)tileEntity).connectionTypes[n3 ^ 1] = this.connectionTypes[n3];
                } else if (this.connectionTypes[n3] == TileTDBase.ConnectionTypes.FORCED) {
                    this.connectionTypes[n3] = TileTDBase.ConnectionTypes.NORMAL;
                } else {
                    this.connectionTypes[n3] = TileTDBase.ConnectionTypes.FORCED;
                    for (int i = 0; i < 6; ++i) {
                        if (n3 == i || this.connectionTypes[i] != TileTDBase.ConnectionTypes.FORCED) continue;
                        this.connectionTypes[i] = TileTDBase.ConnectionTypes.NORMAL;
                    }
                }
                this.onNeighborBlockChange();
                ((TileEntity)this).field_145850_b.func_147459_d(((TileEntity)this).field_145851_c, ((TileEntity)this).field_145848_d, ((TileEntity)this).field_145849_e, this.func_145838_q());
                if (this.myGrid != null) {
                    this.myGrid.destroyAndRecreate();
                }
                for (SubTileMultiBlock subTileMultiBlock : this.subTiles) {
                    subTileMultiBlock.destroyAndRecreate();
                }
                ((TileEntity)this).field_145850_b.func_147471_g(((TileEntity)this).field_145851_c, ((TileEntity)this).field_145848_d, ((TileEntity)this).field_145849_e);
                return true;
            }
            if (n2 > 13 && n2 < 20) {
                return this.attachments[n2 - 14].onWrenched();
            }
            if (n2 >= 20 && n2 < 26) {
                return this.covers[n2 - 20].onWrenched();
            }
        }
        return false;
    }

    @Override
    public boolean openGui(EntityPlayer entityPlayer) {
        if (super.openGui(entityPlayer) || ServerHelper.isClientWorld((World)((TileEntity)this).field_145850_b)) {
            return true;
        }
        if (this.internalGrid == null) {
            return false;
        }
        this.onNeighborBlockChange();
        for (int i = 0; i < 6; ++i) {
            if (this.connectionTypes[i] != TileTDBase.ConnectionTypes.FORCED || this.neighborMultiBlocks[i] != null) continue;
            PacketHandler.sendTo((PacketBase)this.getPacket(), (EntityPlayer)entityPlayer);
            entityPlayer.openGui((Object)ThermalDynamics.instance, 0, ((TileEntity)this).field_145850_b, ((TileEntity)this).field_145851_c, ((TileEntity)this).field_145848_d, ((TileEntity)this).field_145849_e);
            return true;
        }
        return false;
    }

    @Override
    public void func_145841_b(NBTTagCompound nBTTagCompound) {
        super.func_145841_b(nBTTagCompound);
        if (this.data != BLANK_NAME) {
            this.data.write(nBTTagCompound, this);
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound nBTTagCompound) {
        super.func_145839_a(nBTTagCompound);
        this.data = OutputData.read(nBTTagCompound);
    }

    @Override
    public PacketCoFHBase getPacket() {
        PacketCoFHBase packetCoFHBase = super.getPacket();
        if (this.data != BLANK_NAME) {
            packetCoFHBase.addBool(true);
            this.data.addToPacket(packetCoFHBase);
        } else {
            packetCoFHBase.addBool(false);
        }
        return packetCoFHBase;
    }

    @Override
    public void handleTilePacket(PacketCoFHBase packetCoFHBase, boolean bl) {
        super.handleTilePacket(packetCoFHBase, bl);
        if (packetCoFHBase.getBool()) {
            if (this.data == BLANK_NAME) {
                this.data = new OutputData();
            }
            this.data.readPacket(packetCoFHBase);
        } else {
            this.data = BLANK_NAME;
        }
    }

    @Override
    public void handleInfoPacket(PacketCoFHBase packetCoFHBase, boolean bl, EntityPlayer entityPlayer) {
        byte by = packetCoFHBase.getByte();
        if (by == 0 && bl) {
            this.sendPlayerToDest(entityPlayer, packetCoFHBase.getInt(), packetCoFHBase.getInt(), packetCoFHBase.getInt());
        } else if (by == 1 && bl) {
            if (this.data == BLANK_NAME) {
                this.data = new OutputData();
            }
            this.data.loadConfigData(packetCoFHBase);
            if (this.internalGrid != null) {
                this.internalGrid.onMajorGridChange();
            }
        } else if (by == 2 && !bl) {
            Container container = entityPlayer.field_71070_bA;
            if (!(container instanceof ContainerTransport)) {
                return;
            }
            ContainerTransport containerTransport = (ContainerTransport)container;
            containerTransport.setEntry(new DirectoryEntry(packetCoFHBase));
            ArrayList<DirectoryEntry> arrayList = new ArrayList<DirectoryEntry>();
            int n = packetCoFHBase.getShort();
            for (int i = 0; i < n; ++i) {
                arrayList.add(new DirectoryEntry(packetCoFHBase));
            }
            containerTransport.setDirectory(arrayList);
        } else if (by == 3 && bl) {
            PacketHandler.sendTo((PacketBase)this.getPacket(), (EntityPlayer)entityPlayer);
            entityPlayer.openGui((Object)ThermalDynamics.instance, 7, ((TileEntity)this).field_145850_b, ((TileEntity)this).field_145851_c, ((TileEntity)this).field_145848_d, ((TileEntity)this).field_145849_e);
        }
    }

    public void setName(String string) {
        if (!string.equals(this.data.name)) {
            if (this.data == BLANK_NAME) {
                this.data = new OutputData();
            }
            this.data.name = string;
            this.sendOutputDataConfigPacket();
        }
    }

    public void setIcon(ItemStack itemStack) {
        if (this.data == BLANK_NAME) {
            this.data = new OutputData();
        }
        this.data.item = itemStack;
        this.sendOutputDataConfigPacket();
    }

    public void sendOutputDataConfigPacket() {
        if (((TileEntity)this).field_145850_b.field_72995_K) {
            PacketTileInfo packetTileInfo = PacketTileInfo.newPacket((TileEntity)this);
            packetTileInfo.addByte(0);
            packetTileInfo.addByte(1);
            this.data.saveConfigData(packetTileInfo);
            PacketHandler.sendToServer((PacketBase)packetTileInfo);
        }
    }

    public void sendRequest(int n, int n2, int n3) {
        PacketTileInfo packetTileInfo = PacketTileInfo.newPacket((TileEntity)this);
        packetTileInfo.addByte(0);
        packetTileInfo.addByte(0);
        packetTileInfo.addInt(n);
        packetTileInfo.addInt(n2);
        packetTileInfo.addInt(n3);
        PacketHandler.sendToServer((PacketBase)packetTileInfo);
    }

    public PacketCoFHBase getDirectoryPacket() {
        PacketTileInfo packetTileInfo = PacketTileInfo.newPacket((TileEntity)this);
        packetTileInfo.addByte(0);
        packetTileInfo.addByte(2);
        LinkedList<Route> linkedList = this.getCache().outputRoutes;
        ArrayList<TileTransportDuct> arrayList = new ArrayList<TileTransportDuct>(linkedList.size());
        for (Route object : linkedList) {
            if (!object.endPoint.isOutput() || object.endPoint == this || !(object.endPoint instanceof TileTransportDuct)) continue;
            arrayList.add((TileTransportDuct)object.endPoint);
        }
        DirectoryEntry.addDirectoryEntry(packetTileInfo, this);
        packetTileInfo.addShort(arrayList.size());
        for (TileTransportDuct tileTransportDuct : arrayList) {
            DirectoryEntry.addDirectoryEntry(packetTileInfo, tileTransportDuct);
        }
        return packetTileInfo;
    }

    public boolean sendPlayerToDest(EntityPlayer entityPlayer, int n, int n2, int n3) {
        for (Route route : this.getCache().outputRoutes) {
            IMultiBlockRoute iMultiBlockRoute = route.endPoint;
            if (iMultiBlockRoute.x() != n || iMultiBlockRoute.y() != n2 || iMultiBlockRoute.z() != n3) continue;
            Route route2 = route.copy();
            route2.pathDirections.add(iMultiBlockRoute.getStuffedSide());
            EntityTransport entityTransport = new EntityTransport(this, route2, (byte)(this.getStuffedSide() ^ 1), 50);
            entityTransport.start((Entity)entityPlayer);
            if (entityPlayer.field_71070_bA instanceof ContainerTransport) {
                entityPlayer.func_71053_j();
            }
            return true;
        }
        return false;
    }

    public Object getGuiServer(InventoryPlayer inventoryPlayer) {
        return new ContainerTransport(this);
    }

    @SideOnly(value=Side.CLIENT)
    public Object getGuiClient(InventoryPlayer inventoryPlayer) {
        return new GuiTransport(this);
    }

    @Override
    public Object getConfigGuiServer(InventoryPlayer inventoryPlayer) {
        return new ContainerTransportConfig(inventoryPlayer, this);
    }

    @Override
    public Object getConfigGuiClient(InventoryPlayer inventoryPlayer) {
        return new GuiTransportConfig(inventoryPlayer, this);
    }

    public boolean openConfigGui(IBlockAccess iBlockAccess, int n, int n2, int n3, ForgeDirection forgeDirection, EntityPlayer entityPlayer) {
        if (ServerHelper.isClientWorld((World)((TileEntity)this).field_145850_b)) {
            return true;
        }
        PacketHandler.sendTo((PacketBase)this.getPacket(), (EntityPlayer)entityPlayer);
        entityPlayer.openGui((Object)ThermalDynamics.instance, 7, ((TileEntity)this).field_145850_b, ((TileEntity)this).field_145851_c, ((TileEntity)this).field_145848_d, ((TileEntity)this).field_145849_e);
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public CoverHoleRender.ITransformer[] getHollowMask(byte by) {
        BlockDuct.ConnectionTypes connectionTypes = this.getRenderConnectionType(by);
        return connectionTypes == BlockDuct.ConnectionTypes.NONE ? null : CoverHoleRender.hollowDuctTransport;
    }

    public static class OutputData {
        public String name = "";
        public ItemStack item = null;

        public void write(NBTTagCompound nBTTagCompound, TileTransportDuct tileTransportDuct) {
            if (!"".equals(this.name)) {
                nBTTagCompound.func_74778_a("DestinationName", this.name);
            }
            if (this.item != null) {
                nBTTagCompound.func_74782_a("DestinationIcon", (NBTBase)this.item.func_77955_b(new NBTTagCompound()));
            }
        }

        public static OutputData read(NBTTagCompound nBTTagCompound) {
            if (!nBTTagCompound.func_74764_b("DestinationName") && !nBTTagCompound.func_74764_b("DestinationIcon")) {
                return BLANK_NAME;
            }
            OutputData outputData = new OutputData();
            outputData.name = nBTTagCompound.func_74779_i("DestinationName");
            outputData.item = ItemStack.func_77949_a((NBTTagCompound)nBTTagCompound.func_74775_l("DestinationIcon"));
            return outputData;
        }

        public void addToPacket(PacketCoFHBase packetCoFHBase) {
            packetCoFHBase.addString(this.name);
            packetCoFHBase.addItemStack(this.item);
        }

        public void readPacket(PacketCoFHBase packetCoFHBase) {
            this.name = packetCoFHBase.getString();
            this.item = packetCoFHBase.getItemStack();
        }

        public void loadConfigData(PacketCoFHBase packetCoFHBase) {
            String string = this.name;
            ItemStack itemStack = ItemStack.func_77944_b((ItemStack)this.item);
            try {
                this.name = packetCoFHBase.getString();
                this.item = packetCoFHBase.getItemStack();
            }
            catch (RuntimeException runtimeException) {
                this.name = string;
                this.item = itemStack;
            }
        }

        public void saveConfigData(PacketTileInfo packetTileInfo) {
            packetTileInfo.addString(this.name);
            packetTileInfo.addItemStack(this.item);
        }
    }
}

