/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermaldynamics.duct.energy.subgrid;

import cofh.api.energy.EnergyStorage;
import cofh.thermaldynamics.duct.energy.subgrid.SubTileEnergy;
import cofh.thermaldynamics.multiblock.IMultiBlock;
import cofh.thermaldynamics.multiblock.MultiBlockGrid;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;

public class EnergySubGrid
extends MultiBlockGrid {
    public EnergyStorage myStorage = new EnergyStorage(1000);
    public final int perStorage;

    public EnergySubGrid(World world, int n, int n2) {
        super(world);
        this.perStorage = n;
        this.myStorage.setMaxTransfer(n2);
    }

    @Override
    public void balanceGrid() {
        this.myStorage.setCapacity(this.nodeSet.size() * this.perStorage);
    }

    @Override
    public boolean canAddBlock(IMultiBlock iMultiBlock) {
        return iMultiBlock instanceof SubTileEnergy;
    }

    @Override
    public boolean canGridsMerge(MultiBlockGrid multiBlockGrid) {
        return super.canGridsMerge(multiBlockGrid);
    }

    public int getNodeShare(IMultiBlock iMultiBlock) {
        return this.nodeSet.size() == 1 ? this.myStorage.getEnergyStored() : (this.isFirstMultiblock(iMultiBlock) ? this.myStorage.getEnergyStored() / this.nodeSet.size() + this.myStorage.getEnergyStored() % this.nodeSet.size() : this.myStorage.getEnergyStored() / this.nodeSet.size());
    }

    @Override
    public void addBlock(IMultiBlock iMultiBlock) {
        super.addBlock(iMultiBlock);
        SubTileEnergy subTileEnergy = (SubTileEnergy)iMultiBlock;
        if (subTileEnergy.energyForGrid > 0) {
            this.myStorage.modifyEnergyStored(subTileEnergy.energyForGrid);
        }
    }

    @Override
    public void mergeGrids(MultiBlockGrid multiBlockGrid) {
        super.mergeGrids(multiBlockGrid);
        this.balanceGrid();
        this.myStorage.modifyEnergyStored(((EnergySubGrid)multiBlockGrid).myStorage.getEnergyStored());
    }

    @Override
    public void destroyNode(IMultiBlock iMultiBlock) {
        if (iMultiBlock.isNode()) {
            ((SubTileEnergy)iMultiBlock).energyForGrid = this.getNodeShare(iMultiBlock);
        }
        super.destroyNode(iMultiBlock);
    }

    @Override
    public void addInfo(List<IChatComponent> list, EntityPlayer entityPlayer, boolean bl) {
        super.addInfo(list, entityPlayer, bl);
    }
}

