/*
 * Decompiled with CFR 0.152.
 */
package am2.spell.shapes;

import am2.AMCore;
import am2.api.power.PowerTypes;
import am2.api.spell.ItemSpellBase;
import am2.api.spell.component.interfaces.ISpellModifier;
import am2.api.spell.component.interfaces.ISpellShape;
import am2.api.spell.enums.Affinity;
import am2.api.spell.enums.SpellCastResult;
import am2.api.spell.enums.SpellModifiers;
import am2.entities.EntitySpellProjectile;
import am2.items.ItemsCommonProxy;
import am2.particles.AMParticle;
import am2.particles.AMParticleIcons;
import am2.particles.ParticleFadeOut;
import am2.particles.ParticleLeaveParticleTrail;
import am2.particles.ParticleMoveOnHeading;
import am2.spell.SpellHelper;
import am2.spell.SpellUtils;
import am2.spell.modifiers.Colour;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.boss.EntityDragonPart;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;

public class AoE
implements ISpellShape {
    @Override
    public int getID() {
        return 0;
    }

    @Override
    public SpellCastResult beginStackStage(ItemSpellBase item, ItemStack stack, EntityLivingBase caster, EntityLivingBase target, World world, double x, double y, double z, int side, boolean giveXP, int useCount) {
        double radius = SpellUtils.instance.getModifiedDouble_Add(1.0, stack, caster, (Entity)target, world, 0, SpellModifiers.RADIUS);
        List entities = world.func_72872_a(Entity.class, AxisAlignedBB.func_72330_a((double)(x - radius), (double)(y - radius), (double)(z - radius), (double)(x + radius), (double)(y + radius), (double)(z + radius)));
        boolean appliedToAtLeastOneEntity = false;
        for (Entity e : entities) {
            if (e == caster || e instanceof EntitySpellProjectile) continue;
            if (e instanceof EntityDragonPart && ((EntityDragonPart)e).field_70259_a instanceof EntityLivingBase) {
                e = (EntityLivingBase)((EntityDragonPart)e).field_70259_a;
            }
            if (SpellHelper.instance.applyStageToEntity(stack, caster, world, e, 0, giveXP) != SpellCastResult.SUCCESS) continue;
            appliedToAtLeastOneEntity = true;
        }
        if (side == 0 || side == 1) {
            if (world.field_72995_K) {
                this.spawnAoEParticles(stack, caster, world, x + 0.5, y + (double)(side == 1 ? 0.5f : (target != null ? target.func_70047_e() : -2.0f)), z + 0.5, (int)radius);
            }
            int gravityMagnitude = SpellUtils.instance.countModifiers(SpellModifiers.GRAVITY, stack, 0);
            return this.applyStageHorizontal(stack, caster, world, (int)Math.floor(x), (int)Math.ceil(y), (int)Math.floor(z), side, (int)Math.floor(radius), gravityMagnitude, giveXP);
        }
        if (side == 2 || side == 3) {
            if (world.field_72995_K) {
                this.spawnAoEParticles(stack, caster, world, x, y, side == 2 ? z - 0.5 : z + 1.5, (int)radius);
            }
            return this.applyStageVerticalZ(stack, caster, world, (int)Math.floor(x), (int)Math.ceil(y), (int)Math.floor(z), side, (int)Math.floor(radius), giveXP);
        }
        if (side == 4 || side == 5) {
            if (world.field_72995_K) {
                this.spawnAoEParticles(stack, caster, world, x, y, side == 5 ? z - 0.5 : z + 1.5, (int)radius);
            }
            return this.applyStageVerticalX(stack, caster, world, (int)Math.floor(x), (int)Math.ceil(y), (int)Math.floor(z), side, (int)Math.floor(radius), giveXP);
        }
        if (appliedToAtLeastOneEntity) {
            if (world.field_72995_K) {
                this.spawnAoEParticles(stack, caster, world, x, y + 1.0, z, (int)radius);
            }
            return SpellCastResult.SUCCESS;
        }
        return SpellCastResult.EFFECT_FAILED;
    }

    private void spawnAoEParticles(ItemStack stack, EntityLivingBase caster, World world, double x, double y, double z, int radius) {
        String pfxName = AMParticleIcons.instance.getParticleForAffinity(SpellUtils.instance.mainAffinityFor(stack));
        float speed = 0.08f * (float)radius;
        int color = 0xFFFFFF;
        if (SpellUtils.instance.modifierIsPresent(SpellModifiers.COLOR, stack, 0)) {
            ISpellModifier[] mods = SpellUtils.instance.getModifiersForStage(stack, 0);
            int ordinalCount = 0;
            for (ISpellModifier mod : mods) {
                if (!(mod instanceof Colour)) continue;
                byte[] meta = SpellUtils.instance.getModifierMetadataFromStack(stack, mod, 0, ordinalCount++);
                color = (int)mod.getModifier(SpellModifiers.COLOR, null, null, null, meta);
            }
        }
        for (int i = 0; i < 360; i += AMCore.config.FullGFX() ? 20 : (AMCore.config.LowGFX() ? 40 : 60)) {
            AMParticle effect = (AMParticle)((Object)AMCore.proxy.particleManager.spawn(world, pfxName, x, y + 1.5, z));
            if (effect == null) continue;
            effect.setIgnoreMaxAge(true);
            effect.AddParticleController(new ParticleMoveOnHeading(effect, i, 0.0, speed, 1, false));
            effect.field_70145_X = false;
            effect.setRGBColorI(color);
            effect.AddParticleController(new ParticleFadeOut(effect, 1, false).setFadeSpeed(0.05f).setKillParticleOnFinish(true));
            effect.AddParticleController(new ParticleLeaveParticleTrail(effect, pfxName, false, 5, 1, false).addControllerToParticleList(new ParticleFadeOut(effect, 1, false).setFadeSpeed(0.1f).setKillParticleOnFinish(true)).setParticleRGB_I(color).addRandomOffset(0.2f, 0.2f, 0.2f));
        }
    }

    private SpellCastResult applyStageHorizontal(ItemStack stack, EntityLivingBase caster, World world, int x, int y, int z, int face, int radius, int gravityMagnitude, boolean giveXP) {
        for (int i = -radius; i <= radius; ++i) {
            for (int j = -radius; j <= radius; ++j) {
                SpellCastResult result;
                int searchY = y;
                Block block = world.func_147439_a(x + i, searchY, z + j);
                if (gravityMagnitude > 0) {
                    for (int searchDist = 0; block == Blocks.field_150350_a && searchDist < gravityMagnitude; ++searchDist) {
                        block = world.func_147439_a(x + i, --searchY, z + j);
                    }
                }
                if (block == Blocks.field_150350_a || (result = SpellHelper.instance.applyStageToGround(stack, caster, world, x + i, searchY, z + j, face, x + i, searchY, z + i, 0, giveXP)) == SpellCastResult.SUCCESS) continue;
                return result;
            }
        }
        return SpellCastResult.SUCCESS;
    }

    private SpellCastResult applyStageVerticalX(ItemStack stack, EntityLivingBase caster, World world, int x, int y, int z, int face, int radius, boolean giveXP) {
        for (int i = -radius; i <= radius; ++i) {
            for (int j = -radius; j <= radius; ++j) {
                SpellCastResult result;
                int searchY = y;
                Block block = world.func_147439_a(x, searchY + i, z + j);
                if (block == Blocks.field_150350_a || (result = SpellHelper.instance.applyStageToGround(stack, caster, world, x, searchY + i, z + j, face, x, searchY + i, z + j, 0, giveXP)) == SpellCastResult.SUCCESS) continue;
                return result;
            }
        }
        return SpellCastResult.SUCCESS;
    }

    private SpellCastResult applyStageVerticalZ(ItemStack stack, EntityLivingBase caster, World world, int x, int y, int z, int face, int radius, boolean giveXP) {
        for (int i = -radius; i <= radius; ++i) {
            for (int j = -radius; j <= radius; ++j) {
                SpellCastResult result;
                int searchY = y;
                Block block = world.func_147439_a(x + j, searchY + i, z);
                if (block == Blocks.field_150350_a || (result = SpellHelper.instance.applyStageToGround(stack, caster, world, x + j, searchY + i, z, face, x + j, searchY + i, z, 0, giveXP)) == SpellCastResult.SUCCESS) continue;
                return result;
            }
        }
        return SpellCastResult.SUCCESS;
    }

    @Override
    public boolean isChanneled() {
        return false;
    }

    @Override
    public Object[] getRecipeItems() {
        Object[] objectArray = new Object[5];
        objectArray[0] = new ItemStack((Item)ItemsCommonProxy.itemOre, 1, 7);
        objectArray[1] = new ItemStack((Item)ItemsCommonProxy.essence, 1, 2);
        objectArray[2] = String.format("E:%d|%d|%d", PowerTypes.LIGHT.ID(), PowerTypes.NEUTRAL.ID(), PowerTypes.DARK.ID());
        objectArray[3] = 1000;
        objectArray[4] = Blocks.field_150335_W;
        return objectArray;
    }

    @Override
    public float manaCostMultiplier(ItemStack spellStack) {
        int multiplier = 2;
        int radiusMods = 0;
        int stages = SpellUtils.instance.numStages(spellStack);
        for (int i = 0; i < stages; ++i) {
            ISpellModifier[] mods;
            if (SpellUtils.instance.getShapeForStage(spellStack, i).getID() != this.getID()) continue;
            for (ISpellModifier modifier : mods = SpellUtils.instance.getModifiersForStage(spellStack, i)) {
                if (!modifier.getAspectsModified().contains((Object)SpellModifiers.RADIUS)) continue;
                ++radiusMods;
            }
        }
        return multiplier * (radiusMods + 1);
    }

    @Override
    public boolean isTerminusShape() {
        return true;
    }

    @Override
    public boolean isPrincipumShape() {
        return false;
    }

    @Override
    public String getSoundForAffinity(Affinity affinity, ItemStack stack, World world) {
        switch (affinity) {
            case AIR: {
                return "arsmagica2:spell.cast.air";
            }
            case ARCANE: {
                return "arsmagica2:spell.cast.arcane";
            }
            case EARTH: {
                return "arsmagica2:spell.cast.earth";
            }
            case ENDER: {
                return "arsmagica2:spell.cast.ender";
            }
            case FIRE: {
                return "arsmagica2:spell.cast.fire";
            }
            case ICE: {
                return "arsmagica2:spell.cast.ice";
            }
            case LIFE: {
                return "arsmagica2:spell.cast.life";
            }
            case LIGHTNING: {
                return "arsmagica2:spell.cast.lightning";
            }
            case NATURE: {
                return "arsmagica2:spell.cast.nature";
            }
            case WATER: {
                return "arsmagica2:spell.cast.water";
            }
        }
        return "arsmagica2:spell.cast.none";
    }
}

