/*
 * Decompiled with CFR 0.152.
 */
package am2.spell.components;

import am2.AMCore;
import am2.api.ArsMagicaApi;
import am2.api.math.AMVector3;
import am2.api.spell.component.interfaces.ISpellComponent;
import am2.api.spell.enums.Affinity;
import am2.items.ItemsCommonProxy;
import am2.particles.AMParticle;
import am2.particles.ParticleApproachPoint;
import am2.playerextensions.ExtendedProperties;
import am2.utility.MathUtilities;
import java.util.EnumSet;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;

public class Telekinesis
implements ISpellComponent {
    @Override
    public boolean applyEffectBlock(ItemStack stack, World world, int blockx, int blocky, int blockz, int blockFace, double impactX, double impactY, double impactZ, EntityLivingBase caster) {
        return this.doTK_Extrapolated(stack, world, impactX, impactY, impactZ, caster);
    }

    @Override
    public boolean applyEffectEntity(ItemStack stack, World world, EntityLivingBase caster, Entity target) {
        return this.doTK_Extrapolated(stack, world, target.field_70165_t, target.field_70163_u, target.field_70161_v, caster);
    }

    private boolean doTK_Extrapolated(ItemStack stack, World world, double impactX, double impactY, double impactZ, EntityLivingBase caster) {
        double range;
        MovingObjectPosition mop;
        if (caster instanceof EntityPlayer && (mop = ItemsCommonProxy.spell.getMovingObjectPosition(caster, world, range = (double)ExtendedProperties.For((EntityLivingBase)caster).TK_Distance, false, false)) == null) {
            impactX = caster.field_70165_t + Math.cos(Math.toRadians(caster.field_70177_z + 90.0f)) * range;
            impactZ = caster.field_70161_v + Math.sin(Math.toRadians(caster.field_70177_z + 90.0f)) * range;
            impactY = caster.field_70163_u + (double)caster.func_70047_e() + -Math.sin(Math.toRadians(caster.field_70125_A)) * range;
        }
        double distance = 16.0;
        int hDist = 3;
        List entities = world.func_72872_a(EntityItem.class, AxisAlignedBB.func_72330_a((double)(impactX - distance), (double)(impactY - (double)hDist), (double)(impactZ - distance), (double)(impactX + distance), (double)(impactY + (double)hDist), (double)(impactZ + distance)));
        entities.addAll(world.func_72872_a(EntityXPOrb.class, AxisAlignedBB.func_72330_a((double)(impactX - distance), (double)(impactY - (double)hDist), (double)(impactZ - distance), (double)(impactX + distance), (double)(impactY + (double)hDist), (double)(impactZ + distance))));
        for (Entity e : entities) {
            if (e.field_70173_aa < 20) continue;
            AMVector3 movement = MathUtilities.GetMovementVectorBetweenPoints(new AMVector3(e), new AMVector3(impactX, impactY, impactZ));
            if (world.field_72995_K) continue;
            float factor = 0.15f;
            if (movement.y > 0.0f) {
                movement.y = 0.0f;
            }
            double x = -(movement.x * factor);
            double y = -(movement.y * factor);
            double z = -(movement.z * factor);
            e.func_70024_g(x, y, z);
            if (Math.abs(e.field_70159_w) > Math.abs(x * 2.0)) {
                e.field_70159_w = x * (e.field_70159_w / e.field_70159_w);
            }
            if (Math.abs(e.field_70181_x) > Math.abs(y * 2.0)) {
                e.field_70181_x = y * (e.field_70181_x / e.field_70181_x);
            }
            if (!(Math.abs(e.field_70179_y) > Math.abs(z * 2.0))) continue;
            e.field_70179_y = z * (e.field_70179_y / e.field_70179_y);
        }
        return true;
    }

    @Override
    public float manaCost(EntityLivingBase caster) {
        return 6.0f;
    }

    @Override
    public float burnout(EntityLivingBase caster) {
        return ArsMagicaApi.getBurnoutFromMana(this.manaCost(caster));
    }

    @Override
    public ItemStack[] reagents(EntityLivingBase caster) {
        return null;
    }

    @Override
    public void spawnParticles(World world, double x, double y, double z, EntityLivingBase caster, Entity target, Random rand, int colorModifier) {
        AMParticle effect;
        double range;
        MovingObjectPosition mop;
        if (caster instanceof EntityPlayer && (mop = ItemsCommonProxy.spell.getMovingObjectPosition(caster, world, range = (double)ExtendedProperties.For((EntityLivingBase)caster).TK_Distance, false, false)) == null) {
            x = caster.field_70165_t + Math.cos(Math.toRadians(caster.field_70177_z + 90.0f)) * range;
            z = caster.field_70161_v + Math.sin(Math.toRadians(caster.field_70177_z + 90.0f)) * range;
            y = caster.field_70163_u + -Math.sin(Math.toRadians(caster.field_70125_A)) * range;
        }
        if ((effect = (AMParticle)((Object)AMCore.proxy.particleManager.spawn(world, "arcane", x - 0.5 + rand.nextDouble(), y - 0.5 + rand.nextDouble(), z - 0.5 + rand.nextDouble()))) != null) {
            effect.AddParticleController(new ParticleApproachPoint(effect, x, y, z, 0.025f, 0.025f, 1, false));
            effect.setRGBColorF(0.8f, 0.3f, 0.7f);
            if (colorModifier > -1) {
                effect.setRGBColorF((float)(colorModifier >> 16 & 0xFF) / 255.0f, (float)(colorModifier >> 8 & 0xFF) / 255.0f, (float)(colorModifier & 0xFF) / 255.0f);
            }
        }
    }

    @Override
    public EnumSet<Affinity> getAffinity() {
        return EnumSet.of(Affinity.ARCANE);
    }

    @Override
    public int getID() {
        return 54;
    }

    @Override
    public Object[] getRecipeItems() {
        Object[] objectArray = new Object[3];
        objectArray[0] = new ItemStack((Item)ItemsCommonProxy.rune, 1, 13);
        objectArray[1] = Blocks.field_150320_F;
        objectArray[2] = Blocks.field_150486_ae;
        return objectArray;
    }

    @Override
    public float getAffinityShift(Affinity affinity) {
        return 0.001f;
    }
}

