/*
 * Decompiled with CFR 0.152.
 */
package am2.spell.components;

import am2.AMCore;
import am2.RitualShapeHelper;
import am2.api.ArsMagicaApi;
import am2.api.blocks.MultiblockStructureDefinition;
import am2.api.spell.component.interfaces.IRitualInteraction;
import am2.api.spell.component.interfaces.ISpellComponent;
import am2.api.spell.enums.Affinity;
import am2.api.spell.enums.SpellModifiers;
import am2.blocks.BlocksCommonProxy;
import am2.buffs.BuffEffectAstralDistortion;
import am2.items.ItemsCommonProxy;
import am2.particles.AMParticle;
import am2.particles.ParticleFloatUpward;
import am2.spell.SpellUtils;
import java.util.EnumSet;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.world.World;

public class AstralDistortion
implements ISpellComponent,
IRitualInteraction {
    @Override
    public boolean applyEffectBlock(ItemStack stack, World world, int blockx, int blocky, int blockz, int blockFace, double impactX, double impactY, double impactZ, EntityLivingBase caster) {
        ItemStack[] reagents;
        if (world.func_147439_a(blockx, blocky, blockz) == Blocks.field_150474_ac && (reagents = RitualShapeHelper.instance.checkForRitual(this, world, blockx, blocky, blockz)) != null) {
            if (!world.field_72995_K) {
                world.func_147468_f(blockx, blocky, blockz);
                RitualShapeHelper.instance.consumeRitualReagents(this, world, blockx, blocky, blockz);
                RitualShapeHelper.instance.consumeRitualShape(this, world, blockx, blocky, blockz);
                EntityItem item = new EntityItem(world);
                item.func_70107_b((double)blockx + 0.5, (double)blocky + 0.5, (double)blockz + 0.5);
                item.func_92058_a(new ItemStack((Block)BlocksCommonProxy.inertSpawner));
                world.func_72838_d((Entity)item);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean applyEffectEntity(ItemStack stack, World world, EntityLivingBase caster, Entity target) {
        if (target instanceof EntityLivingBase) {
            int duration = SpellUtils.instance.getModifiedInt_Mul(600, stack, caster, target, world, 0, SpellModifiers.DURATION);
            duration = SpellUtils.instance.modifyDurationBasedOnArmor(caster, duration);
            int x = (int)Math.floor(target.field_70165_t);
            int y = (int)Math.floor(target.field_70163_u);
            int z = (int)Math.floor(target.field_70161_v);
            if (!world.field_72995_K) {
                ((EntityLivingBase)target).func_70690_d((PotionEffect)new BuffEffectAstralDistortion(duration, SpellUtils.instance.countModifiers(SpellModifiers.BUFF_POWER, stack, 0)));
            }
            return true;
        }
        return false;
    }

    @Override
    public float manaCost(EntityLivingBase caster) {
        return 80.0f;
    }

    @Override
    public float burnout(EntityLivingBase caster) {
        return ArsMagicaApi.getBurnoutFromMana(this.manaCost(caster));
    }

    @Override
    public ItemStack[] reagents(EntityLivingBase caster) {
        return null;
    }

    @Override
    public void spawnParticles(World world, double x, double y, double z, EntityLivingBase caster, Entity target, Random rand, int colorModifier) {
        for (int i = 0; i < 10; ++i) {
            AMParticle particle = (AMParticle)((Object)AMCore.proxy.particleManager.spawn(world, "pulse", x, y, z));
            if (particle == null) continue;
            particle.addRandomOffset(5.0, 4.0, 5.0);
            particle.AddParticleController(new ParticleFloatUpward(particle, 0.2f, 0.0f, 1, false));
            particle.setMaxAge(25 + rand.nextInt(10));
            particle.setRGBColorF(0.7f, 0.2f, 0.9f);
            if (colorModifier <= -1) continue;
            particle.setRGBColorF((float)(colorModifier >> 16 & 0xFF) / 255.0f, (float)(colorModifier >> 8 & 0xFF) / 255.0f, (float)(colorModifier & 0xFF) / 255.0f);
        }
    }

    @Override
    public EnumSet<Affinity> getAffinity() {
        return EnumSet.of(Affinity.ENDER);
    }

    @Override
    public int getID() {
        return 1;
    }

    @Override
    public Object[] getRecipeItems() {
        Object[] objectArray = new Object[2];
        objectArray[0] = new ItemStack((Item)ItemsCommonProxy.rune, 1, 13);
        objectArray[1] = Items.field_151061_bv;
        return objectArray;
    }

    @Override
    public float getAffinityShift(Affinity affinity) {
        return 0.05f;
    }

    @Override
    public MultiblockStructureDefinition getRitualShape() {
        return RitualShapeHelper.instance.corruption;
    }

    @Override
    public ItemStack[] getReagents() {
        ItemStack[] itemStackArray = new ItemStack[2];
        itemStackArray[0] = new ItemStack((Item)ItemsCommonProxy.mobFocus);
        itemStackArray[1] = new ItemStack((Item)ItemsCommonProxy.essence, 1, 9);
        return itemStackArray;
    }

    @Override
    public int getReagentSearchRadius() {
        return 3;
    }
}

