/*
 * Decompiled with CFR 0.152.
 */
package am2.proxy;

import am2.AMClientEventHandler;
import am2.AMCore;
import am2.AMKeyBindings;
import am2.api.events.RegisterCompendiumEntries;
import am2.api.events.RegisterSkillTreeIcons;
import am2.api.math.AMVector3;
import am2.api.power.IPowerNode;
import am2.api.power.PowerTypes;
import am2.api.spell.ItemSpellBase;
import am2.api.spell.component.interfaces.ISpellComponent;
import am2.armor.ArmorHelper;
import am2.blocks.BlocksClientProxy;
import am2.blocks.BlocksCommonProxy;
import am2.blocks.renderers.SimpleBlockRenderHandler;
import am2.blocks.renderers.TechneBlockRenderHandler;
import am2.blocks.tileentities.TileEntityParticleEmitter;
import am2.buffs.BuffList;
import am2.commands.ConfigureAMUICommand;
import am2.entities.EntityAirSled;
import am2.guis.AMGuiHelper;
import am2.guis.GuiParticleEmitter;
import am2.guis.GuiSkillTrees;
import am2.items.ItemSpellBook;
import am2.items.ItemsCommonProxy;
import am2.items.renderers.CustomItemRenderer;
import am2.items.renderers.SpellScrollRenderer;
import am2.lore.ArcaneCompendium;
import am2.lore.CompendiumUnlockHandler;
import am2.network.AMNetHandler;
import am2.network.AMPacketProcessorClient;
import am2.particles.ParticleManagerClient;
import am2.power.PowerNodeEntry;
import am2.proxy.CommonProxy;
import am2.proxy.gui.ClientGuiManager;
import am2.proxy.tick.ClientTickHandler;
import am2.spell.SpellUtils;
import am2.spell.components.Telekinesis;
import am2.texture.SpellIconManager;
import am2.utility.ProxyUtilitiesClient;
import am2.utility.RenderUtilities;
import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import cpw.mods.fml.client.registry.RenderingRegistry;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.registry.LanguageRegistry;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.AbstractClientPlayer;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.particle.EntityDiggingFX;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.command.ICommand;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.network.play.client.C03PacketPlayer;
import net.minecraft.network.play.client.C0CPacketInput;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.client.ClientCommandHandler;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.common.MinecraftForge;
import org.lwjgl.opengl.GL11;

public class ClientProxy
extends CommonProxy {
    public static SimpleBlockRenderHandler simpleBlockRenderHandler;
    public static TechneBlockRenderHandler techneBlockRenderHandler;
    private ClientTickHandler clientTickHandler;
    public static HashMap<PowerTypes, ArrayList<LinkedList<AMVector3>>> powerPathVisuals;

    public ClientProxy() {
        this.particleManager = new ParticleManagerClient();
    }

    @Override
    public void InitializeAndRegisterHandlers() {
        guiManager = new ClientGuiManager();
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)AMCore.instance, (IGuiHandler)guiManager);
        this.clientTickHandler = new ClientTickHandler();
        FMLCommonHandler.instance().bus().register((Object)this.clientTickHandler);
        AMNetHandler.INSTANCE.registerChannels(new AMPacketProcessorClient());
        CompendiumUnlockHandler compendiumHandler = new CompendiumUnlockHandler();
        MinecraftForge.EVENT_BUS.register((Object)compendiumHandler);
        FMLCommonHandler.instance().bus().register((Object)compendiumHandler);
    }

    @Override
    public void postinit() {
        super.postinit();
        ArcaneCompendium.instance.init(Minecraft.func_71410_x().func_135016_M().func_135041_c());
        MinecraftForge.EVENT_BUS.post((Event)new RegisterCompendiumEntries(ArcaneCompendium.instance));
        MinecraftForge.EVENT_BUS.post((Event)new RegisterSkillTreeIcons(SpellIconManager.instance));
        MinecraftForge.EVENT_BUS.register((Object)new AMClientEventHandler());
        ((ParticleManagerClient)this.particleManager).registerEventHandlers();
        FMLCommonHandler.instance().bus().register((Object)new AMKeyBindings());
    }

    @Override
    public void preinit() {
        super.preinit();
        this.utils = new ProxyUtilitiesClient();
        this.blocks = new BlocksClientProxy();
        BuffList.setupTextureOverrides();
    }

    @Override
    public void init() {
        super.init();
        entities.registerRenderInformation();
        this.blocks.registerRenderInformation();
        simpleBlockRenderHandler = new SimpleBlockRenderHandler();
        RenderingRegistry.registerBlockHandler((int)BlocksCommonProxy.commonBlockRenderID, (ISimpleBlockRenderingHandler)simpleBlockRenderHandler);
        techneBlockRenderHandler = new TechneBlockRenderHandler();
        RenderingRegistry.registerBlockHandler((int)BlocksCommonProxy.blockRenderID, (ISimpleBlockRenderingHandler)techneBlockRenderHandler);
        MinecraftForgeClient.registerItemRenderer((Item)ItemsCommonProxy.scythe, (IItemRenderer)CustomItemRenderer.instance);
        MinecraftForgeClient.registerItemRenderer((Item)ItemsCommonProxy.magicBroom, (IItemRenderer)CustomItemRenderer.instance);
        MinecraftForgeClient.registerItemRenderer((Item)ItemsCommonProxy.arcaneSpellbook, (IItemRenderer)CustomItemRenderer.instance);
        MinecraftForgeClient.registerItemRenderer((Item)ItemsCommonProxy.winterGuardianArm, (IItemRenderer)CustomItemRenderer.instance);
        MinecraftForgeClient.registerItemRenderer((Item)ItemsCommonProxy.airGuardianLower, (IItemRenderer)CustomItemRenderer.instance);
        MinecraftForgeClient.registerItemRenderer((Item)ItemsCommonProxy.fireEars, (IItemRenderer)CustomItemRenderer.instance);
        MinecraftForgeClient.registerItemRenderer((Item)ItemsCommonProxy.waterGuardianOrbs, (IItemRenderer)CustomItemRenderer.instance);
        MinecraftForgeClient.registerItemRenderer((Item)ItemsCommonProxy.earthGuardianArmor, (IItemRenderer)CustomItemRenderer.instance);
        MinecraftForgeClient.registerItemRenderer((Item)ItemsCommonProxy.wardingCandle, (IItemRenderer)CustomItemRenderer.instance);
        MinecraftForgeClient.registerItemRenderer((Item)ItemsCommonProxy.spell, (IItemRenderer)SpellScrollRenderer.instance);
        MinecraftForgeClient.registerItemRenderer((Item)ItemsCommonProxy.spellBook, (IItemRenderer)SpellScrollRenderer.instance);
        ClientCommandHandler.instance.func_71560_a((ICommand)new ConfigureAMUICommand());
    }

    @Override
    public void flashManaBar() {
        AMGuiHelper.instance.flashManaBar();
    }

    @Override
    public void blackoutArmorPiece(EntityPlayerMP entity, int index, int duration) {
        AMGuiHelper.instance.blackoutArmorPiece(index, duration);
    }

    @Override
    public Entity getEntityByID(World world, int ID) {
        return world.func_73045_a(ID);
    }

    @Override
    public EntityLivingBase getEntityByID(int entityID) {
        Entity e = Minecraft.func_71410_x().field_71441_e.func_73045_a(entityID);
        if (e instanceof EntityLivingBase) {
            return (EntityLivingBase)e;
        }
        return null;
    }

    @Override
    public EntityPlayer getLocalPlayer() {
        return Minecraft.func_71410_x().field_71439_g;
    }

    @Override
    public WorldServer[] getWorldServers() {
        return FMLClientHandler.instance().getServer().field_71305_c;
    }

    @Override
    public int getArmorRenderIndex(String prefix) {
        return RenderingRegistry.addNewArmourRendererPrefix((String)prefix);
    }

    @Override
    public void openSkillTreeUI(World world, EntityPlayer player) {
        if (world.field_72995_K) {
            Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiSkillTrees(player));
        }
    }

    @Override
    public void openParticleBlockGUI(World world, EntityPlayer player, TileEntityParticleEmitter te) {
        if (world.field_72995_K) {
            Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiParticleEmitter(te));
        }
    }

    @Override
    public boolean setMouseDWheel(int dwheel) {
        if (dwheel == 0) {
            return false;
        }
        ItemStack stack = Minecraft.func_71410_x().field_71439_g.func_71045_bC();
        if (stack == null) {
            return false;
        }
        boolean store = this.checkForTKMove(stack);
        if (!store && stack.func_77973_b() instanceof ItemSpellBook) {
            store = Minecraft.func_71410_x().field_71439_g.func_70093_af();
        }
        if (store) {
            this.clientTickHandler.setDWheel(dwheel / 120, Minecraft.func_71410_x().field_71439_g.field_71071_by.field_70461_c, Minecraft.func_71410_x().field_71439_g.func_71039_bw());
            return true;
        }
        this.clientTickHandler.setDWheel(0, -1, false);
        return false;
    }

    private boolean checkForTKMove(ItemStack stack) {
        ItemStack activeStack;
        if (stack.func_77973_b() instanceof ItemSpellBook && (activeStack = ((ItemSpellBook)stack.func_77973_b()).GetActiveItemStack(stack)) != null) {
            stack = activeStack;
        }
        if (stack.func_77973_b() instanceof ItemSpellBase && stack.func_77942_o() && Minecraft.func_71410_x().field_71439_g.func_71039_bw()) {
            for (ISpellComponent component : SpellUtils.instance.getComponentsForStage(stack, 0)) {
                if (!(component instanceof Telekinesis)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void renderGameOverlay() {
        this.clientTickHandler.renderOverlays();
    }

    @Override
    public String getCurrentLanguage() {
        return Minecraft.func_71410_x().func_135016_M().func_135041_c().func_135034_a();
    }

    @Override
    public void addName(Object obj, String s) {
        LanguageRegistry.addName((Object)obj, (String)s);
    }

    @Override
    public void addLocalization(String s1, String string) {
        LanguageRegistry.instance().addStringLocalization(s1, string);
    }

    @Override
    public String getItemStackDisplayName(ItemStack stack) {
        if (stack.func_77973_b() == null) {
            return "";
        }
        return stack.func_77973_b().func_77653_i(stack);
    }

    @Override
    public void sendLocalMovementData(EntityLivingBase ent) {
        if (ent == Minecraft.func_71410_x().field_71439_g && ent.field_70170_p.field_72995_K && ent.field_70154_o instanceof EntityAirSled) {
            EntityClientPlayerMP player = (EntityClientPlayerMP)ent;
            player.field_71174_a.func_147297_a((Packet)new C03PacketPlayer.C05PacketPlayerLook(player.field_70177_z, player.field_70125_A, player.field_70122_E));
            player.field_71174_a.func_147297_a((Packet)new C0CPacketInput(player.field_70702_br, player.field_70701_bs, player.field_71158_b.field_78901_c, player.field_71158_b.field_78899_d));
        }
    }

    @Override
    public void setCompendiumSaveBase(String compendiumBase) {
        ArcaneCompendium.instance.setSaveLocation(compendiumBase);
    }

    @Override
    public void requestPowerPathVisuals(IPowerNode node, EntityPlayerMP player) {
        AMNetHandler.INSTANCE.syncPowerPaths(node, player);
    }

    @Override
    public void receivePowerPathVisuals(HashMap<PowerTypes, ArrayList<LinkedList<AMVector3>>> paths) {
        powerPathVisuals = paths;
    }

    @Override
    public HashMap<PowerTypes, ArrayList<LinkedList<AMVector3>>> getPowerPathVisuals() {
        return powerPathVisuals;
    }

    @Override
    public boolean isClientPlayer(EntityLivingBase ent) {
        return ent instanceof AbstractClientPlayer;
    }

    @Override
    public void setTrackedLocation(AMVector3 location) {
        this.clientTickHandler.setTrackLocation(location);
    }

    @Override
    public void setTrackedPowerCompound(NBTTagCompound compound) {
        this.clientTickHandler.setTrackData(compound);
    }

    @Override
    public boolean hasTrackedLocationSynced() {
        return this.clientTickHandler.getHasSynced();
    }

    @Override
    public PowerNodeEntry getTrackedData() {
        return this.clientTickHandler.getTrackData();
    }

    @Override
    public void unlockCompendiumEntry(String id) {
        if (ArcaneCompendium.instance.isCategory(id)) {
            this.unlockCompendiumCategory(id);
        } else {
            ArcaneCompendium.instance.unlockEntry(id);
        }
    }

    @Override
    public void unlockCompendiumCategory(String id) {
        ArcaneCompendium.instance.unlockCategory(id);
    }

    @Override
    public void drawPowerOnBlockHighlight(EntityPlayer player, MovingObjectPosition target, float partialTicks) {
        if (AMCore.proxy.getLocalPlayer().func_82169_q(3) != null && (AMCore.proxy.getLocalPlayer().func_82169_q(3).func_77973_b() == ItemsCommonProxy.magitechGoggles || ArmorHelper.isInfusionPreset(AMCore.proxy.getLocalPlayer().func_82169_q(3), "mg_gog"))) {
            TileEntity te = player.field_70170_p.func_147438_o(target.field_72311_b, target.field_72312_c, target.field_72309_d);
            if (te != null && te instanceof IPowerNode) {
                AMCore.proxy.setTrackedLocation(new AMVector3(target.field_72311_b, target.field_72312_c, target.field_72309_d));
            } else {
                AMCore.proxy.setTrackedLocation(AMVector3.zero());
            }
            if (AMCore.proxy.hasTrackedLocationSynced()) {
                PowerNodeEntry data = AMCore.proxy.getTrackedData();
                Block block = player.field_70170_p.func_147439_a(target.field_72311_b, target.field_72312_c, target.field_72309_d);
                float yOff = 0.5f;
                if (data != null) {
                    GL11.glPushAttrib((int)16704);
                    for (PowerTypes type : ((IPowerNode)te).getValidPowerTypes()) {
                        float pwr = data.getPower(type);
                        float pct = pwr / ((IPowerNode)te).getCapacity() * 100.0f;
                        RenderUtilities.drawTextInWorldAtOffset(String.format("%s%.2f (%.2f%%)", type.chatColor(), Float.valueOf(pwr), Float.valueOf(pct)), (double)target.field_72311_b - (player.field_70169_q - (player.field_70169_q - player.field_70165_t) * (double)partialTicks) + 0.5, (double)((float)target.field_72312_c + yOff) - (player.field_70167_r - (player.field_70167_r - player.field_70163_u) * (double)partialTicks) + block.func_149669_A() * (double)0.8f, (double)target.field_72309_d - (player.field_70166_s - (player.field_70166_s - player.field_70161_v) * (double)partialTicks) + 0.5, 0xFFFFFF);
                        yOff += 0.12f;
                    }
                    GL11.glPopAttrib();
                }
            }
        }
    }

    @Override
    public void addDeferredTargetSet(EntityLiving ent, EntityLivingBase target) {
        this.clientTickHandler.addDeferredTarget(ent, target);
    }

    @Override
    public void addDigParticle(World worldObj, int xCoord, int yCoord, int zCoord, Block block, int meta) {
        Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)new EntityDiggingFX(worldObj, (double)xCoord + worldObj.field_73012_v.nextDouble(), (double)yCoord + worldObj.field_73012_v.nextDouble(), (double)zCoord + worldObj.field_73012_v.nextDouble(), 0.0, 0.0, 0.0, block, meta, 0));
    }
}

