/*
 * Decompiled with CFR 0.152.
 */
package am2.illeffect;

import am2.api.illeffect.BadThingTypes;
import am2.api.illeffect.IIllEffect;
import am2.api.illeffect.IllEffectSeverity;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.TreeMap;
import java.util.TreeSet;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;

public class IllEffectsManager {
    private TreeMap<IIllEffect, Integer> DarkNexusBadThings = new TreeMap();
    public static IllEffectsManager instance = new IllEffectsManager();
    private static Random rand = new Random();

    private IllEffectsManager() {
    }

    public void ApplyRandomBadThing(TileEntity te, IllEffectSeverity maxSev, BadThingTypes type) {
        HashMap<IIllEffect, Integer> possibleBadThings = new HashMap<IIllEffect, Integer>();
        switch (type) {
            case ALL: {
                for (IIllEffect badThing : this.DarkNexusBadThings.keySet()) {
                    if (badThing.GetSeverity().ordinal() > maxSev.ordinal()) continue;
                    possibleBadThings.put(badThing, this.DarkNexusBadThings.get(badThing));
                }
                break;
            }
            case DARKNEXUS: {
                for (IIllEffect badThing : this.DarkNexusBadThings.keySet()) {
                    if (badThing.GetSeverity().ordinal() > maxSev.ordinal()) continue;
                    possibleBadThings.put(badThing, this.DarkNexusBadThings.get(badThing));
                }
                break;
            }
        }
        if (possibleBadThings.size() == 0) {
            return;
        }
        IIllEffect chosenBadThing = this.getWeightedBadthing(possibleBadThings);
        Map<EntityPlayer, Object> affected = chosenBadThing.ApplyIllEffect(te.func_145831_w(), te.field_145851_c, te.field_145848_d, te.field_145849_e);
    }

    private IIllEffect getWeightedBadthing(HashMap<IIllEffect, Integer> possibilities) {
        int totalWeight = 0;
        for (IIllEffect effect : possibilities.keySet()) {
            totalWeight += possibilities.get(effect).intValue();
        }
        int tWeight = rand.nextInt(totalWeight);
        for (IIllEffect effect : possibilities.keySet()) {
            if ((tWeight -= possibilities.get(effect).intValue()) > 0) continue;
            return effect;
        }
        return possibilities.keySet().iterator().next();
    }

    @Deprecated
    public static void RegisterIllEffect(IIllEffect effect, BadThingTypes type) {
        IllEffectsManager.RegisterIllEffect(effect, 10, type);
    }

    public static void RegisterIllEffect(IIllEffect effect, int weight, BadThingTypes type) {
        switch (type) {
            case ALL: {
                IllEffectsManager.instance.DarkNexusBadThings.put(effect, weight);
                IllEffectsManager.instance.DarkNexusBadThings = IllEffectsManager.entriesSortedByValues(IllEffectsManager.instance.DarkNexusBadThings);
                break;
            }
            default: {
                IllEffectsManager.instance.DarkNexusBadThings.put(effect, weight);
                IllEffectsManager.instance.DarkNexusBadThings = IllEffectsManager.entriesSortedByValues(IllEffectsManager.instance.DarkNexusBadThings);
            }
        }
    }

    static <K, V extends Comparable<? super V>> TreeMap<K, V> entriesSortedByValues(Map<K, V> map) {
        TreeSet sortedEntries = new TreeSet(new Comparator<Map.Entry<K, V>>(){

            @Override
            public int compare(Map.Entry<K, V> e1, Map.Entry<K, V> e2) {
                return ((Comparable)e1.getValue()).compareTo(e2.getValue());
            }
        });
        TreeMap<K, V> tm = new TreeMap<K, V>();
        for (Map.Entry<K, V> entry : map.entrySet()) {
            tm.put(entry.getKey(), entry.getValue());
        }
        return tm;
    }
}

