/*
 * Decompiled with CFR 0.152.
 */
package am2;

import am2.AMCore;
import am2.api.math.AMVector3;
import am2.blocks.tileentities.flickers.FlickerOperatorMoonstoneAttractor;
import am2.entities.EntityThrownRock;
import am2.playerextensions.ExtendedProperties;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.BiomeGenBase;

public class MeteorSpawnHelper {
    private final Random rand = new Random();
    private int ticksSinceLastMeteor = 0;
    public static MeteorSpawnHelper instance = new MeteorSpawnHelper();

    public void tick() {
        if (this.ticksSinceLastMeteor == 0) {
            if (MinecraftServer.func_71276_C().field_71305_c.length < 1) {
                return;
            }
            WorldServer ws = MinecraftServer.func_71276_C().field_71305_c[0];
            if (this.rand.nextInt(2500 + 1000 * ws.field_73011_w.func_76559_b(ws.field_73011_w.getWorldTime())) == 0) {
                this.spawnMeteor();
            }
        } else {
            --this.ticksSinceLastMeteor;
        }
    }

    public void spawnMeteor() {
        this.ticksSinceLastMeteor = 48000;
        if (MinecraftServer.func_71276_C().field_71305_c.length < 1) {
            return;
        }
        WorldServer ws = null;
        for (WorldServer world : MinecraftServer.func_71276_C().field_71305_c) {
            if (world.field_73011_w.field_76574_g != 0) continue;
            ws = world;
            break;
        }
        if (ws == null) {
            return;
        }
        long time = ws.func_72820_D() % 24000L;
        if (time > 14500L && time < 21500L) {
            if (ws.field_73010_i.size() < 1) {
                return;
            }
            int playerID = this.rand.nextInt(ws.field_73010_i.size());
            EntityPlayer player = (EntityPlayer)ws.field_73010_i.get(playerID);
            if (ExtendedProperties.For((EntityLivingBase)player).getMagicLevel() < AMCore.config.getMeteorMinSpawnLevel()) {
                return;
            }
            AMVector3 spawnCoord = new AMVector3((Entity)player);
            boolean found = false;
            int meteorOffsetRadius = 64;
            AMVector3 attractorCoord = FlickerOperatorMoonstoneAttractor.getMeteorAttractor(spawnCoord);
            if (attractorCoord != null) {
                spawnCoord = attractorCoord;
                meteorOffsetRadius = 4;
            }
            for (int i = 0; i < 10; ++i) {
                AMVector3 offsetCoord = spawnCoord.copy().add(new AMVector3(this.rand.nextInt(meteorOffsetRadius) - meteorOffsetRadius / 2, 0.0, this.rand.nextInt(meteorOffsetRadius) - meteorOffsetRadius / 2));
                offsetCoord.y = this.correctYCoord((World)ws, (int)offsetCoord.x, (int)offsetCoord.y, (int)offsetCoord.z);
                if (offsetCoord.y < 0.0f) {
                    return;
                }
                if (!this.topBlockIsBiomeGeneric((World)ws, (int)offsetCoord.x, (int)offsetCoord.y, (int)offsetCoord.z)) continue;
                spawnCoord = offsetCoord;
                found = true;
                break;
            }
            if (!found) {
                return;
            }
            EntityThrownRock meteor = new EntityThrownRock((World)ws);
            meteor.func_70107_b(spawnCoord.x + (float)this.rand.nextInt(meteorOffsetRadius) - (float)(meteorOffsetRadius / 2), ws.func_72940_L(), spawnCoord.z + (float)this.rand.nextInt(meteorOffsetRadius) - (float)(meteorOffsetRadius / 2));
            meteor.setMoonstoneMeteor();
            meteor.setMoonstoneMeteorTarget(spawnCoord);
            ws.func_72838_d((Entity)meteor);
        }
    }

    private boolean topBlockIsBiomeGeneric(World world, int x, int y, int z) {
        if (world == null) {
            return false;
        }
        if ((y = this.correctYCoord(world, x, y, z)) < 0) {
            return false;
        }
        BiomeGenBase biome = world.func_72807_a(x, z);
        Block block = world.func_147439_a(x, y, z);
        return (block == Blocks.field_150343_Z || block == biome.field_76752_A) && world.func_72937_j(x, y + 1, z);
    }

    private int correctYCoord(World world, int x, int y, int z) {
        if (world == null) {
            return y;
        }
        while (y < world.func_72940_L() && world.func_72937_j(x, y, z)) {
            ++y;
        }
        while (world.func_147437_c(x, y, z) && y > -1) {
            --y;
        }
        return y;
    }
}

