/*
 * Decompiled with CFR 0.152.
 */
package com.austinv11.collectiveframework.utils.math.geometry;

import com.austinv11.collectiveframework.utils.math.ThreeDimensionalVector;
import com.austinv11.collectiveframework.utils.math.TwoDimensionalVector;
import java.util.ArrayList;
import java.util.List;

public class Line {
    private ThreeDimensionalVector start;
    private ThreeDimensionalVector end;

    public Line(TwoDimensionalVector startCoord, TwoDimensionalVector endCoord) {
        this(startCoord.to3D(), endCoord.to3D());
    }

    public Line(ThreeDimensionalVector startCoord, ThreeDimensionalVector endCoord) {
        this.start = startCoord;
        this.end = endCoord;
    }

    public double getStartX() {
        return this.start.getX();
    }

    public double getStartY() {
        return this.start.getY();
    }

    public double getStartZ() {
        return this.start.getZ();
    }

    public double getEndX() {
        return this.end.getX();
    }

    public double getEndY() {
        return this.end.getY();
    }

    public double getEndZ() {
        return this.end.getZ();
    }

    public TwoDimensionalVector get2DStart() {
        return this.start.to2D();
    }

    public TwoDimensionalVector get2DEnd() {
        return this.end.to2D();
    }

    public ThreeDimensionalVector get3DStart() {
        return this.start;
    }

    public ThreeDimensionalVector get3DEnd() {
        return this.end;
    }

    public double get2DSlope() {
        if (this.end.getX() - this.start.getX() == 0.0) {
            return Double.NaN;
        }
        return (this.end.getY() - this.start.getY()) / (this.end.getX() - this.start.getX());
    }

    private TwoDimensionalVector find2DPoint(double x, double slope) {
        if (Double.isNaN(slope)) {
            return new TwoDimensionalVector(x, this.start.getY() > this.end.getY() ? this.end.getY() : this.start.getY());
        }
        double yInt = this.start.getY() - this.start.getX() * slope;
        return new TwoDimensionalVector(x, x * slope + yInt);
    }

    public TwoDimensionalVector find2DPoint(double x) {
        return this.find2DPoint(x, this.get2DSlope());
    }

    public boolean isPointValid(TwoDimensionalVector coord) {
        if (Double.isNaN(this.get2DSlope())) {
            return coord.getY() <= this.start.getY() && coord.getY() >= this.end.getY() || coord.getY() >= this.start.getY() && coord.getY() <= this.end.getY();
        }
        return (coord.getX() <= this.start.getX() && coord.getX() >= this.end.getX() || coord.getX() >= this.start.getX() && coord.getX() <= this.end.getX()) && this.find2DPoint(coord.getX()).getY() == coord.getY();
    }

    public List<TwoDimensionalVector> getAll2DPoints() {
        ArrayList<TwoDimensionalVector> vectors;
        block4: {
            int x;
            TwoDimensionalVector end;
            block3: {
                int startY;
                vectors = new ArrayList<TwoDimensionalVector>();
                TwoDimensionalVector start = this.getSorted2DCoords()[0];
                end = this.getSorted2DCoords()[1];
                x = start.getRoundedX();
                if (this.isPointValid(new TwoDimensionalVector(start.getRoundedX(), start.getRoundedY()))) {
                    vectors.add(new TwoDimensionalVector(start.getRoundedX(), start.getRoundedY()));
                }
                if (!Double.isNaN(this.get2DSlope())) break block3;
                if (!this.isPointValid(new TwoDimensionalVector(x, start.getY()))) break block4;
                for (int y = startY = this.isPointValid(new TwoDimensionalVector(x, start.getRoundedY())) ? start.getRoundedY() : (int)Math.ceil(start.getY()); y <= end.getRoundedY(); ++y) {
                    if (!this.isPointValid(new TwoDimensionalVector(x, y))) continue;
                    vectors.add(new TwoDimensionalVector(x, y));
                }
                break block4;
            }
            while (x <= end.getRoundedX()) {
                vectors.add(this.find2DPoint(++x));
            }
        }
        return vectors;
    }

    private TwoDimensionalVector[] getSorted2DCoords() {
        TwoDimensionalVector[] array = new TwoDimensionalVector[2];
        if (this.start.getX() < this.end.getX()) {
            array[0] = this.start.to2D();
            array[1] = this.end.to2D();
        } else {
            array[0] = this.end.to2D();
            array[1] = this.start.to2D();
        }
        return array;
    }

    private double get2DSlopeForZ() {
        if (this.end.getX() - this.start.getX() == 0.0) {
            return Double.NaN;
        }
        return (this.end.getZ() - this.start.getZ()) / (this.end.getX() - this.start.getX());
    }

    public ThreeDimensionalVector find3DPoint(double x) {
        double y = this.find2DPoint(x, this.get2DSlope()).getY();
        double z = this.find2DPoint(x, this.get2DSlopeForZ()).getY();
        return new ThreeDimensionalVector(x, y, z);
    }

    public boolean isPointValid(ThreeDimensionalVector coord) {
        return (coord.getX() <= this.start.getX() && coord.getX() >= this.end.getX() || coord.getX() >= this.start.getX() && coord.getX() <= this.end.getX()) && this.find3DPoint(coord.getX()).getY() == coord.getY() && this.find3DPoint(coord.getX()).getZ() == coord.getZ();
    }

    public List<ThreeDimensionalVector> getAll3DPoints() {
        ArrayList<ThreeDimensionalVector> vectors;
        block5: {
            int x;
            ThreeDimensionalVector end;
            block4: {
                int startY;
                vectors = new ArrayList<ThreeDimensionalVector>();
                ThreeDimensionalVector start = this.getSorted3DCoords()[0];
                end = this.getSorted3DCoords()[1];
                x = start.getRoundedX();
                if (this.isPointValid(new ThreeDimensionalVector(start.getRoundedX(), start.getRoundedY(), start.getRoundedZ()))) {
                    vectors.add(new ThreeDimensionalVector(start.getRoundedX(), start.getRoundedY(), start.getRoundedZ()));
                }
                if (!Double.isNaN(this.get2DSlope()) && !Double.isNaN(this.get2DSlopeForZ())) break block4;
                if (!this.isPointValid(new ThreeDimensionalVector(x, start.getY(), start.getZ()))) break block5;
                for (int y = startY = this.isPointValid(new ThreeDimensionalVector(x, start.getRoundedY(), start.getZ())) ? start.getRoundedY() : (int)Math.ceil(start.getY()); y <= end.getRoundedY(); ++y) {
                    int startZ;
                    for (int z = startZ = this.isPointValid(new ThreeDimensionalVector(x, y, start.getRoundedZ())) ? start.getRoundedZ() : (int)Math.ceil(start.getZ()); z <= end.getRoundedZ(); ++z) {
                        if (!this.isPointValid(new ThreeDimensionalVector(x, y, z))) continue;
                        vectors.add(new ThreeDimensionalVector(x, y, z));
                    }
                }
                break block5;
            }
            while (x <= end.getRoundedX()) {
                vectors.add(this.find3DPoint(++x));
            }
        }
        return vectors;
    }

    private ThreeDimensionalVector[] getSorted3DCoords() {
        ThreeDimensionalVector[] array = new ThreeDimensionalVector[2];
        if (this.start.getX() < this.end.getX()) {
            array[0] = this.start;
            array[1] = this.end;
        } else {
            array[0] = this.end;
            array[1] = this.start;
        }
        return array;
    }

    public double getLength() {
        return this.start.distanceTo(this.end);
    }

    public Line setStart(TwoDimensionalVector coord) {
        return this.setStart(coord.to3D());
    }

    public Line setStart(ThreeDimensionalVector coord) {
        return new Line(coord, this.end);
    }

    public Line setEnd(TwoDimensionalVector coord) {
        return this.setEnd(coord.to3D());
    }

    public Line setEnd(ThreeDimensionalVector coord) {
        return new Line(coord, this.end);
    }

    public Line rotate2D(TwoDimensionalVector point, double angle) {
        TwoDimensionalVector newStart = this.start.to2D().rotate(point, angle);
        TwoDimensionalVector newEnd = this.end.to2D().rotate(point, angle);
        return new Line(newStart, newEnd);
    }

    public Line rotate2D(double angle) {
        return this.rotate2D(new TwoDimensionalVector(0.0, 0.0), angle);
    }

    public Line rotate3DX(ThreeDimensionalVector point, double angle) {
        ThreeDimensionalVector newStart = this.start.rotateX(point, angle);
        ThreeDimensionalVector newEnd = this.end.rotateX(point, angle);
        return new Line(newStart, newEnd);
    }

    public Line rotate3DX(double angle) {
        return this.rotate3DX(new ThreeDimensionalVector(0.0, 0.0, 0.0), angle);
    }

    public Line rotate3DY(ThreeDimensionalVector point, double angle) {
        ThreeDimensionalVector newStart = this.start.rotateY(point, angle);
        ThreeDimensionalVector newEnd = this.end.rotateY(point, angle);
        return new Line(newStart, newEnd);
    }

    public Line rotate3DY(double angle) {
        return this.rotate3DY(new ThreeDimensionalVector(0.0, 0.0, 0.0), angle);
    }

    public Line rotate3DZ(ThreeDimensionalVector point, double angle) {
        ThreeDimensionalVector newStart = this.start.rotateZ(point, angle);
        ThreeDimensionalVector newEnd = this.end.rotateZ(point, angle);
        return new Line(newStart, newEnd);
    }

    public Line rotate3DZ(double angle) {
        return this.rotate3DZ(new ThreeDimensionalVector(0.0, 0.0, 0.0), angle);
    }

    public boolean equals(Object other) {
        if (other instanceof Line) {
            return ((Line)other).start.equals(this.start) && ((Line)other).end.equals(this.end);
        }
        return false;
    }

    public String toString() {
        return "Line(X1:" + this.getStartX() + " Y1:" + this.getStartY() + " Z1:" + this.getStartZ() + "X2:" + this.getEndX() + " Y2:" + this.getEndY() + " Z2:" + this.getEndZ() + ")";
    }
}

