/*
 * Decompiled with CFR 0.152.
 */
package com.austinv11.collectiveframework.utils.math;

import com.austinv11.collectiveframework.utils.math.ThreeDimensionalVector;

public class TwoDimensionalVector
implements Comparable {
    private double x;
    private double y;

    public TwoDimensionalVector(double x, double y) {
        this.x = x;
        this.y = y;
    }

    public void setComponents(double x, double y) {
        this.x = x;
        this.y = y;
    }

    public int getRoundedX() {
        return (int)this.x;
    }

    public int getRoundedY() {
        return (int)this.y;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public TwoDimensionalVector subtract(TwoDimensionalVector other) {
        return new TwoDimensionalVector(other.x - this.x, other.y - this.y);
    }

    public TwoDimensionalVector add(TwoDimensionalVector other) {
        return new TwoDimensionalVector(other.x + this.x, other.y + this.y);
    }

    public TwoDimensionalVector normalize() {
        double distance = Math.sqrt(this.dotProduct());
        return distance < 1.0E-4 ? new TwoDimensionalVector(0.0, 0.0) : new TwoDimensionalVector(this.x / distance, this.y / distance);
    }

    public double dotProduct() {
        return this.x * this.x + this.y * this.y;
    }

    public double dotProduct(TwoDimensionalVector other) {
        return this.x * other.x + this.y * other.y;
    }

    private double squareDistanceTo(TwoDimensionalVector other) {
        return Math.pow(this.x - other.x, 2.0) + Math.pow(this.y - other.y, 2.0);
    }

    public double distanceTo(TwoDimensionalVector other) {
        return Math.sqrt(this.squareDistanceTo(other));
    }

    public double length() {
        return Math.sqrt(this.dotProduct());
    }

    public TwoDimensionalVector midpoint(TwoDimensionalVector other) {
        return new TwoDimensionalVector((other.x + this.x) / 2.0, (other.y + this.y) / 2.0);
    }

    public TwoDimensionalVector rotate(TwoDimensionalVector center, double angle) {
        return new TwoDimensionalVector(Math.cos(Math.toRadians(angle)) * (this.x - center.x) - Math.sin(Math.toRadians(angle)) * (this.y - center.y) + center.x, Math.sin(Math.toRadians(angle)) * (this.x - center.x) + Math.cos(Math.toRadians(angle)) * (this.y - center.y) + center.y);
    }

    public TwoDimensionalVector rotate(double angle) {
        return this.rotate(new TwoDimensionalVector(0.0, 0.0), angle);
    }

    public ThreeDimensionalVector to3D() {
        return new ThreeDimensionalVector(this.x, this.y, 0.0);
    }

    public boolean equals(Object other) {
        if (other instanceof TwoDimensionalVector) {
            return ((TwoDimensionalVector)other).x == this.x && ((TwoDimensionalVector)other).y == this.y;
        }
        return false;
    }

    public String toString() {
        return "TwoDimensionalVector(X:" + this.x + " Y:" + this.y + ")";
    }

    public int compareTo(Object o) {
        TwoDimensionalVector vector = (TwoDimensionalVector)o;
        if (vector.equals(this)) {
            return 0;
        }
        if (vector.x == this.x) {
            return vector.y > this.y ? -1 : 1;
        }
        return vector.x > this.x ? -1 : 1;
    }
}

