/*
 * Decompiled with CFR 0.152.
 */
package com.austinv11.collectiveframework.utils.math;

import com.austinv11.collectiveframework.utils.math.TwoDimensionalVector;

public class ThreeDimensionalVector
implements Comparable {
    private double x;
    private double y;
    private double z;

    public ThreeDimensionalVector(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public void setComponents(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public int getRoundedX() {
        return (int)this.x;
    }

    public int getRoundedY() {
        return (int)this.y;
    }

    public int getRoundedZ() {
        return (int)this.z;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getZ() {
        return this.z;
    }

    public ThreeDimensionalVector subtract(ThreeDimensionalVector other) {
        return new ThreeDimensionalVector(other.x - this.x, other.y - this.y, other.z - this.z);
    }

    public ThreeDimensionalVector add(ThreeDimensionalVector other) {
        return new ThreeDimensionalVector(other.x + this.x, other.y + this.y, other.z + this.z);
    }

    public ThreeDimensionalVector normalize() {
        double distance = Math.sqrt(this.dotProduct());
        return distance < 1.0E-4 ? new ThreeDimensionalVector(0.0, 0.0, 0.0) : new ThreeDimensionalVector(this.x / distance, this.y / distance, this.y / distance);
    }

    public double dotProduct() {
        return this.x * this.x + this.y * this.y + this.z * this.z;
    }

    public double dotProduct(ThreeDimensionalVector other) {
        return this.x * other.x + this.y * other.y + this.z * other.z;
    }

    public ThreeDimensionalVector crossProduct(ThreeDimensionalVector other) {
        return new ThreeDimensionalVector(this.y * other.z - this.z * other.y, this.z * other.x - this.x * other.z, this.x * other.y - this.y * other.x);
    }

    private double squareDistanceTo(ThreeDimensionalVector other) {
        return Math.pow(this.x - other.x, 2.0) + Math.pow(this.y - other.y, 2.0);
    }

    public double distanceTo(ThreeDimensionalVector other) {
        return Math.sqrt(this.squareDistanceTo(other));
    }

    public double length() {
        return Math.sqrt(this.dotProduct());
    }

    public ThreeDimensionalVector midpoint(ThreeDimensionalVector other) {
        return new ThreeDimensionalVector((other.x + this.x) / 2.0, (other.y + this.y) / 2.0, (other.z + this.z) / 2.0);
    }

    public ThreeDimensionalVector rotateX(ThreeDimensionalVector center, double angle) {
        return new ThreeDimensionalVector(this.x, Math.cos(Math.toRadians(angle)) * (this.y - center.y) - Math.sin(Math.toRadians(angle)) * (this.z - center.z) + center.z, Math.sin(Math.toRadians(angle)) * (this.y - center.y) + Math.cos(Math.toRadians(angle)) * (this.z - center.z) + center.z);
    }

    public ThreeDimensionalVector rotateX(double angle) {
        return this.rotateX(new ThreeDimensionalVector(0.0, 0.0, 0.0), angle);
    }

    public ThreeDimensionalVector rotateY(ThreeDimensionalVector center, double angle) {
        return new ThreeDimensionalVector(Math.cos(Math.toRadians(angle)) * (this.z - center.z) - Math.sin(Math.toRadians(angle)) * (this.x - center.x) + center.x, this.y, Math.sin(Math.toRadians(angle)) * (this.z - center.z) + Math.cos(Math.toRadians(angle)) * (this.x - center.x) + center.x);
    }

    public ThreeDimensionalVector rotateY(double angle) {
        return this.rotateY(new ThreeDimensionalVector(0.0, 0.0, 0.0), angle);
    }

    public ThreeDimensionalVector rotateZ(ThreeDimensionalVector center, double angle) {
        return new ThreeDimensionalVector(Math.cos(Math.toRadians(angle)) * (this.x - center.x) - Math.sin(Math.toRadians(angle)) * (this.y - center.y) + center.x, Math.sin(Math.toRadians(angle)) * (this.x - center.x) + Math.cos(Math.toRadians(angle)) * (this.y - center.y) + center.y, this.z);
    }

    public ThreeDimensionalVector rotateZ(double angle) {
        return this.rotateZ(new ThreeDimensionalVector(0.0, 0.0, 0.0), angle);
    }

    public TwoDimensionalVector to2D() {
        return new TwoDimensionalVector(this.x, this.y);
    }

    public boolean equals(Object other) {
        if (other instanceof ThreeDimensionalVector) {
            return ((ThreeDimensionalVector)other).x == this.x && ((ThreeDimensionalVector)other).y == this.y && ((ThreeDimensionalVector)other).z == this.z;
        }
        return false;
    }

    public String toString() {
        return "ThreeDimensionalVector(X:" + this.x + " Y:" + this.y + " Z:" + this.z + ")";
    }

    public int compareTo(Object o) {
        ThreeDimensionalVector vector = (ThreeDimensionalVector)o;
        if (vector.equals(this)) {
            return 0;
        }
        if (vector.x == this.x) {
            if (vector.z == this.z) {
                return vector.y > this.y ? -1 : 1;
            }
            return vector.z > this.z ? -1 : 1;
        }
        return vector.x > this.x ? -1 : 1;
    }
}

