/*
 * Decompiled with CFR 0.152.
 */
package com.austinv11.collectiveframework.utils;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class WebUtils {
    public static List<String> readURL(String url) throws IOException {
        return WebUtils.readURL(url, 5000);
    }

    public static List<String> readURL(String url, int timeout) throws IOException {
        String temp;
        if (!url.contains("http://") && !url.contains("https://")) {
            url = "http://" + url;
        }
        URL input = new URL(url);
        URLConnection connection = input.openConnection();
        connection.setConnectTimeout(timeout);
        BufferedReader in = new BufferedReader(new InputStreamReader(connection.getInputStream()));
        connection.connect();
        ArrayList<String> read = new ArrayList<String>();
        while ((temp = in.readLine()) != null) {
            read.add(temp);
        }
        in.close();
        return read;
    }

    private static List<String> request(String url, int timeout, String method, Map header) throws IOException {
        String temp;
        if (!url.contains("http://") && !url.contains("https://")) {
            url = "http://" + url;
        }
        URL input = new URL(url);
        HttpURLConnection connection = (HttpURLConnection)input.openConnection();
        connection.setConnectTimeout(timeout);
        connection.setRequestMethod(method);
        if (header != null) {
            for (Object key : header.keySet()) {
                connection.setRequestProperty(String.valueOf(key), String.valueOf(header.get(key)));
            }
        }
        BufferedReader in = new BufferedReader(new InputStreamReader(connection.getInputStream()));
        connection.connect();
        ArrayList<String> read = new ArrayList<String>();
        while ((temp = in.readLine()) != null) {
            read.add(temp);
        }
        in.close();
        return read;
    }

    public static List<String> post(String url, int timeout, Map header) throws IOException {
        return WebUtils.request(url, timeout, "POST", header);
    }

    public static List<String> get(String url, int timeout, Map header) throws IOException {
        return WebUtils.request(url, timeout, "GET", header);
    }

    @Deprecated
    public static List<String> readGithub(String repo, String path) throws IOException {
        return WebUtils.readGithub(repo, "master", path);
    }

    @Deprecated
    public static List<String> readGithub(String repo, String branch, String path) throws IOException {
        return WebUtils.readURL("https://raw.github.com/austinv11/" + repo + "/" + branch + "/" + path);
    }
}

