/*
 * Decompiled with CFR 0.152.
 */
package com.austinv11.collectiveframework.utils;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class FileUtils {
    public static void safeWrite(File file, String string) throws IOException {
        FileWriter writer = new FileWriter(file);
        writer.write(string);
        writer.flush();
        writer.close();
    }

    public static List<String> readAll(File file) throws IOException {
        BufferedReader reader = new BufferedReader(new FileReader(file));
        ArrayList<String> lines = new ArrayList<String>();
        while (reader.ready()) {
            lines.add(reader.readLine());
        }
        reader.close();
        return lines;
    }

    public static void unzip(File file, File toDirectory) throws IOException {
        byte[] buffer = new byte[1024];
        if (!toDirectory.exists()) {
            toDirectory.mkdir();
        }
        ZipInputStream zips = new ZipInputStream(new FileInputStream(file));
        ZipEntry zip = zips.getNextEntry();
        while (zip != null) {
            int len;
            String fileName = zip.getName();
            File newFile = new File(toDirectory.getPath() + File.separator + fileName);
            new File(newFile.getParent()).mkdirs();
            FileOutputStream fos = new FileOutputStream(newFile);
            while ((len = zips.read(buffer)) > 0) {
                fos.write(buffer, 0, len);
            }
            fos.close();
            zip = zips.getNextEntry();
        }
        zips.closeEntry();
        zips.close();
    }

    public static List<Class> parseClassesFromJar(File file) throws IOException, ClassNotFoundException {
        if (!file.exists() || file.isDirectory()) {
            return new ArrayList<Class>();
        }
        ArrayList<Class> classes = new ArrayList<Class>();
        JarInputStream jis = new JarInputStream(new FileInputStream(file));
        JarEntry entry = jis.getNextJarEntry();
        while (entry != null) {
            if (entry.getName().endsWith(".class")) {
                String tempString = entry.getName().replaceAll("/", "\\.");
                try {
                    Class<?> clazz = Class.forName(tempString.substring(0, tempString.lastIndexOf(".")));
                    classes.add(clazz);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            entry = jis.getNextJarEntry();
        }
        return classes;
    }
}

