/*
 * Decompiled with CFR 0.152.
 */
package com.austinv11.collectiveframework.minecraft.utils;

import com.austinv11.collectiveframework.minecraft.utils.Location;
import java.util.HashMap;
import net.minecraft.block.Block;

public class StructureCreator {
    private HashMap<Location, Block> blocks = new HashMap();
    private HashMap<Block, Integer> metas = new HashMap();
    private HashMap<Location, ICheckBlockValidity> errorCheckers = new HashMap();

    public void addBlock(Location location, Block block) {
        this.addBlock(location, block, 0);
    }

    public void addBlock(Location location, Block block, int meta) {
        this.addBlock(location, block, meta, new DefaultValidityChecker());
    }

    public void addBlock(Location location, Block block, int meta, ICheckBlockValidity validityChecker) {
        if (!this.blocks.containsKey(location)) {
            this.blocks.put(location, block);
            this.errorCheckers.put(location, validityChecker);
            this.metas.put(block, meta);
        }
    }

    public boolean isStructureValid() {
        for (Location l : this.blocks.keySet()) {
            if (this.errorCheckers.get(l).canStructureGenerate(this.blocks.get(l), this.metas.get(this.blocks.get(l)), l)) continue;
            return false;
        }
        return true;
    }

    public void generateStructure() {
        this.generateStructure(false);
    }

    public void generateStructure(boolean forceOptionalBlocks) {
        this.generateStructure(forceOptionalBlocks, false);
    }

    public void generateStructure(boolean forceOptionalBlocks, boolean forceNonOptionalBlocks) {
        if (!forceNonOptionalBlocks && !this.isStructureValid()) {
            return;
        }
        for (Location l : this.blocks.keySet()) {
            if (!this.errorCheckers.get(l).isBlockValid(this.blocks.get(l), this.metas.get(this.blocks.get(l)), l) && !forceOptionalBlocks) continue;
            l.getWorld().func_147465_d(l.getRoundedX(), l.getRoundedY(), l.getRoundedZ(), this.blocks.get(l), this.metas.get(this.blocks.get(l)).intValue(), 2);
        }
    }

    public static interface ICheckBlockValidity {
        public boolean isBlockValid(Block var1, int var2, Location var3);

        public boolean canStructureGenerate(Block var1, int var2, Location var3);
    }

    public static class DefaultValidityChecker
    implements ICheckBlockValidity {
        @Override
        public boolean isBlockValid(Block block, int meta, Location location) {
            return location.getWorld().func_147437_c(location.getRoundedX(), location.getRoundedY(), location.getRoundedZ()) || location.getWorld().func_147439_a(location.getRoundedX(), location.getRoundedY(), location.getRoundedZ()).func_149688_o().func_76222_j();
        }

        @Override
        public boolean canStructureGenerate(Block block, int meta, Location location) {
            return this.isBlockValid(block, meta, location);
        }
    }
}

