/*
 * Decompiled with CFR 0.152.
 */
package com.austinv11.collectiveframework.minecraft.event.handler;

import com.austinv11.collectiveframework.minecraft.reference.Config;
import com.austinv11.collectiveframework.minecraft.utils.Colors;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.oredict.OreDictionary;

public class TooltipHandler {
    @SubscribeEvent
    public void onTooltip(ItemTooltipEvent event) {
        if (Config.debugTooltips) {
            event.toolTip.addAll(this.getUnlocalisedName(event.itemStack));
            event.toolTip.addAll(this.getOreDictTooltip(event.itemStack));
            event.toolTip.addAll(this.getNBTTooltip(event.itemStack));
        }
    }

    private List<String> getNBTTooltip(ItemStack stack) {
        ArrayList<String> tooltip = new ArrayList<String>();
        if (stack.func_77942_o()) {
            tooltip.add((Object)((Object)Colors.UNDERLINE) + "NBT Tags:");
            tooltip.add(stack.func_77978_p().toString());
        }
        return tooltip;
    }

    private List<String> getOreDictTooltip(ItemStack stack) {
        ArrayList<String> tooltip = new ArrayList<String>();
        if (OreDictionary.getOreIDs((ItemStack)stack).length > 0) {
            tooltip.add((Object)((Object)Colors.UNDERLINE) + "Ore Dictionary Entries:");
            for (int id : OreDictionary.getOreIDs((ItemStack)stack)) {
                tooltip.add("-" + OreDictionary.getOreName((int)id) + " (id: " + id + ")");
            }
        }
        return tooltip;
    }

    private List<String> getUnlocalisedName(ItemStack stack) {
        ArrayList<String> tooltip = new ArrayList<String>();
        tooltip.add((Object)((Object)Colors.UNDERLINE) + "String Item ID:");
        Item item = stack.func_77973_b();
        if (item instanceof ItemBlock) {
            Block block = Block.func_149634_a((Item)item);
            tooltip.add(Block.field_149771_c.func_148750_c((Object)block));
        } else {
            tooltip.add(Item.field_150901_e.func_148750_c((Object)item));
        }
        return tooltip;
    }
}

