/*
 * Decompiled with CFR 0.152.
 */
package com.austinv11.collectiveframework.minecraft.config;

import com.austinv11.collectiveframework.minecraft.CollectiveFramework;
import com.austinv11.collectiveframework.minecraft.config.Config;
import com.austinv11.collectiveframework.minecraft.config.ConfigException;
import com.austinv11.collectiveframework.minecraft.config.ConfigLoadEvent;
import com.austinv11.collectiveframework.minecraft.config.DefaultProxy;
import com.austinv11.collectiveframework.minecraft.config.Description;
import com.austinv11.collectiveframework.minecraft.config.IConfigProxy;
import com.austinv11.collectiveframework.minecraft.config.IConfigurationHandler;
import com.austinv11.collectiveframework.utils.ArrayUtils;
import com.austinv11.collectiveframework.utils.ReflectionUtils;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.relauncher.Side;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.io.StringReader;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import net.minecraftforge.common.MinecraftForge;

public class ConfigRegistry {
    private static List<ConfigProxy> toBeInitialized = new ArrayList<ConfigProxy>();
    public static List<ConfigProxy> configs = new ArrayList<ConfigProxy>();
    private static List<IConfigProxy> proxies = new ArrayList<IConfigProxy>();

    public static void registerConfig(Object config) throws ConfigException {
        if (!config.getClass().isAnnotationPresent(Config.class)) {
            throw new ConfigException("Config " + config.toString() + " does not contain a Config annotation!");
        }
        Config configAnnotation = config.getClass().getAnnotation(Config.class);
        try {
            ConfigProxy configProxy = new ConfigProxy(configAnnotation, config);
            toBeInitialized.add(configProxy);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ConfigException(e.getMessage());
        }
    }

    public static void registerConfigProxy(IConfigProxy proxy) {
        proxies.add(proxy);
    }

    public static void init() {
        for (ConfigProxy config : toBeInitialized) {
            ConfigRegistry.initialize(config);
        }
        toBeInitialized.clear();
    }

    private static void initialize(ConfigProxy configProxy) {
        IConfigurationHandler handler = configProxy.handler;
        ConfigLoadEvent.Init event = new ConfigLoadEvent.Init();
        event.config = handler.convertToString(configProxy.config);
        event.configName = configProxy.fileName;
        event.isRevert = false;
        MinecraftForge.EVENT_BUS.post((Event)event);
        handler.loadFile(configProxy.fileName, configProxy.config, configProxy.fields);
        configs.add(configProxy);
    }

    public static String getKey(Object o) {
        for (IConfigProxy proxy : proxies) {
            if (!proxy.canSerializeObject(o)) continue;
            return proxy.getKey(o);
        }
        return "@NULL@";
    }

    public static String serialize(Object o) throws ConfigException {
        for (IConfigProxy proxy : proxies) {
            if (!proxy.canSerializeObject(o)) continue;
            return proxy.serialize(o);
        }
        return "@NULL@";
    }

    public static Object deserialize(String key, String string) throws ConfigException {
        for (IConfigProxy proxy : proxies) {
            if (!proxy.isKeyUsable(key)) continue;
            return proxy.deserialize(key, string);
        }
        return null;
    }

    public static void onConfigReload(ConfigLoadEvent.Pre event) {
        if (!event.isCanceled()) {
            if (!event.isRevert) {
                CollectiveFramework.LOGGER.info("Reloading config '" + event.configName + "'");
                ConfigProxy proxy = ConfigRegistry.findConfigProxyForConfigFile(configs, event.configName);
                if (proxy == null) {
                    CollectiveFramework.LOGGER.error("There was an error reloading the config!");
                    return;
                }
                proxy.handler.loadFromString(event.config, proxy.config, proxy.fields);
            } else {
                CollectiveFramework.LOGGER.info("Reverting config '" + event.configName + "'");
                ConfigProxy proxy = ConfigRegistry.findConfigProxyForConfigFile(configs, event.configName);
                if (proxy == null) {
                    CollectiveFramework.LOGGER.error("There was an error reverting the config!");
                    return;
                }
                proxy.handler.loadFile(event.config, proxy.config, proxy.fields);
            }
        }
    }

    private static ConfigProxy findConfigProxyForConfigFile(List<ConfigProxy> proxies, String filename) {
        for (ConfigProxy proxy : proxies) {
            if (!proxy.fileName.equals(filename)) continue;
            return proxy;
        }
        return null;
    }

    static {
        ConfigRegistry.registerConfigProxy(new DefaultProxy());
    }

    public static class ConfigProxy
    implements Cloneable {
        public Object config;
        public IConfigurationHandler handler;
        public String fileName;
        public boolean doesSync;
        public TreeMap<String, Map<String, Field>> fields = new TreeMap();

        public ConfigProxy(Config annotation, Object config) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
            Field[] field;
            Field[] declared;
            this.config = config;
            this.handler = (IConfigurationHandler)Class.forName(annotation.handler()).newInstance();
            this.fileName = annotation.fileName().equals("@NULL@") ? config.getClass().getSimpleName() + ".cfg" : annotation.fileName();
            this.doesSync = annotation.doesSync();
            for (Field f : declared = config.getClass().getDeclaredFields()) {
                f.setAccessible(true);
                if (ArrayUtils.indexOf(annotation.exclude(), f.getName()) != -1) continue;
                if (f.isAnnotationPresent(Description.class)) {
                    this.addToCategory(f.getAnnotation(Description.class).category(), f);
                    continue;
                }
                this.addToCategory("General", f);
            }
            for (Field f : field = config.getClass().getFields()) {
                f.setAccessible(true);
                if (ArrayUtils.indexOf(annotation.exclude(), f.getName()) != -1) continue;
                if (f.isAnnotationPresent(Description.class)) {
                    this.addToCategory(f.getAnnotation(Description.class).category(), f);
                    continue;
                }
                this.addToCategory("General", f);
            }
        }

        private void addToCategory(String category, Field f) {
            Map<String, Field> vals = this.fields.containsKey(category) ? this.fields.get(category) : new TreeMap<String, Field>();
            vals.put(f.getName(), f);
            this.fields.put(category, vals);
        }
    }

    public static class DefaultConfigurationHandler
    implements IConfigurationHandler {
        private Map<String, Map<String, Field>> current = new HashMap<String, Map<String, Field>>();
        private File cachedFile;

        @Override
        public void setValue(String configValue, String category, Object value, Object config) {
            this.setValue(configValue, category, value, config, true);
        }

        @Override
        public void setValue(String configValue, String category, Object value, Object config, boolean saveToFile) {
            HashMap<String, Field> fields = this.current.containsKey(category) ? this.current.get(category) : new HashMap<String, Field>();
            Field field = fields.containsKey(configValue) ? (Field)fields.get(configValue) : ReflectionUtils.getDeclaredOrNormalField(configValue, config.getClass());
            try {
                field.set(config, value);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            if (saveToFile) {
                try {
                    this.writeFile(this.cachedFile, config);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (!this.current.containsKey(category) || !fields.containsKey(configValue)) {
                fields.put(configValue, field);
                this.current.put(category, fields);
            }
        }

        @Override
        public Object getValue(String configValue, String category, Object config) {
            if (this.hasValue(configValue, category) && this.current.containsKey(category) && this.current.get(category).containsKey(configValue)) {
                return this.current.get(category).get(configValue);
            }
            return null;
        }

        @Override
        public void loadFile(String fileName, Object config, Map<String, Map<String, Field>> hint) {
            this.current = hint;
            this.cachedFile = new File("./config/" + fileName);
            if (this.cachedFile.exists()) {
                try {
                    this.readFile(this.cachedFile, config);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                try {
                    this.cachedFile.createNewFile();
                    this.writeFile(this.cachedFile, config);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }

        @Override
        public void loadFromString(String string, Object config, Map<String, Map<String, Field>> hint) {
            try {
                this.readFromReader(new BufferedReader(new StringReader(string)), config);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        @Override
        public File getConfigFile(String fileName, Object config) {
            return this.cachedFile;
        }

        @Override
        public boolean hasValue(String configValue, String category) {
            return this.current.containsKey(category) && this.current.get(category).containsKey(configValue);
        }

        @Override
        public String convertToString(Object config) {
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            try {
                this.writeToStream(new PrintStream(stream), config);
                return stream.toString();
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }

        private void writeToStream(PrintStream writer, Object config) throws IllegalAccessException, ConfigException {
            for (String category : this.current.keySet()) {
                int i = 0;
                for (String field : this.current.get(category).keySet()) {
                    Field f = this.current.get(category).get(field);
                    f.setAccessible(true);
                    if (f.isAnnotationPresent(Description.class) && f.getAnnotation(Description.class).clientSideOnly() && CollectiveFramework.proxy.getSide() == Side.SERVER) continue;
                    if (i == 0) {
                        writer.println(category + " {");
                    }
                    String comment = f.isAnnotationPresent(Description.class) ? f.getAnnotation(Description.class).comment() : "None! Tell the mod author to include a comment!";
                    writer.println("\t" + comment);
                    writer.println("\t" + ConfigRegistry.getKey(f.get(config)) + ":" + field + "=" + ConfigRegistry.serialize(f.get(config)));
                    writer.println();
                    if (++i != this.current.get(category).size()) continue;
                    writer.println("}");
                }
            }
            writer.flush();
            writer.close();
        }

        private void writeFile(File file, Object config) throws IOException, IllegalAccessException, ConfigException {
            PrintStream writer = new PrintStream(file);
            this.writeToStream(writer, config);
        }

        private void readFile(File file, Object config) throws IOException, IllegalAccessException, ClassNotFoundException, InstantiationException {
            BufferedReader reader = new BufferedReader(new FileReader(file));
            this.readFromReader(reader, config);
            try {
                this.writeFile(file, config);
            }
            catch (ConfigException e) {
                e.printStackTrace();
            }
        }

        private void readFromReader(BufferedReader reader, Object config) throws IOException, IllegalAccessException {
            String line;
            boolean reachedBracket = false;
            int lineCount = 0;
            while ((line = reader.readLine()) != null) {
                if (!reachedBracket && line.contains("{")) {
                    reachedBracket = true;
                    continue;
                }
                if (reachedBracket && line.equals("}")) {
                    reachedBracket = false;
                    continue;
                }
                if (!reachedBracket) continue;
                if (lineCount < 1) {
                    ++lineCount;
                    continue;
                }
                if (lineCount == 1) {
                    String field = line.substring(line.indexOf(":") + 1, line.indexOf("="));
                    String key = line.substring(0, line.indexOf(":")).replace("\t", "").trim();
                    line = line.substring(line.indexOf("=") + 1);
                    Field f = ReflectionUtils.getDeclaredOrNormalField(field, config.getClass());
                    if (f != null) {
                        try {
                            f.setAccessible(true);
                            f.set(config, ConfigRegistry.deserialize(key, line));
                        }
                        catch (ConfigException e) {
                            e.printStackTrace();
                        }
                    }
                    ++lineCount;
                    continue;
                }
                lineCount = 0;
            }
        }
    }
}

