/*
 * Decompiled with CFR 0.152.
 */
package com.austinv11.collectiveframework.minecraft.compat.modules;

import com.austinv11.collectiveframework.minecraft.compat.modules.IModule;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLStateEvent;
import java.util.ArrayList;
import java.util.List;

public class Modules {
    private static List<IModule> modules = new ArrayList<IModule>();

    public static void registerModCompat(IModule module) {
        modules.add(module);
    }

    private static boolean canModuleLoad(IModule module) {
        for (String s : module.modsCompatible()) {
            if (!Loader.isModLoaded((String)s)) continue;
            return true;
        }
        return false;
    }

    private static void cleanModules() {
        ArrayList<IModule> uncleanedModules = new ArrayList<IModule>(modules);
        modules.clear();
        for (IModule m : uncleanedModules) {
            if (!Modules.canModuleLoad(m)) continue;
            modules.add(m);
        }
    }

    public static void init() {
        Modules.cleanModules();
    }

    public static void propagate(FMLStateEvent event) {
        for (IModule m : modules) {
            if (event instanceof FMLPreInitializationEvent) {
                m.preInit((FMLPreInitializationEvent)event);
                continue;
            }
            if (event instanceof FMLInitializationEvent) {
                m.init((FMLInitializationEvent)event);
                continue;
            }
            m.postInit((FMLPostInitializationEvent)event);
        }
    }
}

