/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.world.village;

import cpw.mods.fml.common.registry.VillagerRegistry;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.village.MerchantRecipe;
import net.minecraft.village.MerchantRecipeList;
import tconstruct.mechworks.TinkerMechworks;
import tconstruct.tools.TinkerTools;
import tconstruct.world.TinkerWorld;

public class TVillageTrades
implements VillagerRegistry.IVillageTradeHandler {
    private final List<ItemStack> allowedIngredients = new ArrayList<ItemStack>();
    private final int max = 17;
    private final int min = 7;

    public TVillageTrades() {
        this.allowedIngredients.add(new ItemStack((Block)Blocks.field_150331_J, 64));
        this.allowedIngredients.add(new ItemStack((Block)Blocks.field_150320_F, 64));
        this.allowedIngredients.add(new ItemStack(TinkerWorld.barricadeBirch, 64));
        this.allowedIngredients.add(new ItemStack(TinkerWorld.barricadeJungle, 64));
        this.allowedIngredients.add(new ItemStack(TinkerWorld.barricadeOak, 64));
        this.allowedIngredients.add(new ItemStack(TinkerWorld.barricadeSpruce, 64));
        this.allowedIngredients.add(new ItemStack(TinkerWorld.punji, 64));
        this.allowedIngredients.add(new ItemStack(TinkerTools.toolStationWood, 3, 0));
        this.allowedIngredients.add(new ItemStack(TinkerTools.toolStationWood, 3, 1));
        this.allowedIngredients.add(new ItemStack(TinkerTools.toolStationWood, 3, 5));
        this.allowedIngredients.add(new ItemStack(TinkerTools.toolStationWood, 3, 10));
        for (int sc = 0; sc < 4; ++sc) {
            this.allowedIngredients.add(new ItemStack(TinkerMechworks.landmine, 64, sc));
        }
    }

    public void manipulateTradesForVillager(EntityVillager villager, MerchantRecipeList recipeList, Random random) {
        if (villager.func_70946_n() == 78943) {
            for (int sc = 8; sc < 12; ++sc) {
                int num = this.getNextInt(random, 7, 17);
                ItemStack ingredient = this.getIngredient(random, num);
                ItemStack ingredient2 = ingredient.field_77994_a < 13 ? this.getIngredient(random, ingredient) : null;
                ItemStack result = new ItemStack((Block)TinkerWorld.oreBerry, this.calcStackSize(ingredient, ingredient2), sc);
                recipeList.func_77205_a(new MerchantRecipe(ingredient, ingredient2, result));
                if (sc != 8) continue;
                result = new ItemStack((Block)TinkerWorld.oreBerrySecond, this.calcStackSize(ingredient, ingredient2), sc);
                recipeList.func_77205_a(new MerchantRecipe(ingredient, ingredient2, result));
            }
        }
    }

    private int calcStackSize(ItemStack ingredient, ItemStack ingredient2) {
        if (ingredient == null) {
            return 1;
        }
        int num = ingredient.field_77994_a;
        if (ingredient2 != null) {
            num += ingredient2.field_77994_a;
        }
        return Math.max(1, Math.round((num - 5) / 4));
    }

    private ItemStack getIngredient(Random random, ItemStack ingredient) {
        int sc;
        ItemStack is;
        int tries = 0;
        while ((is = this.allowedIngredients.get(sc = this.getNextInt(random, 0, this.allowedIngredients.size() - 1))) == ingredient && is.func_77960_j() == ingredient.func_77960_j()) {
            if (++tries != 5) continue;
            return null;
        }
        int num = this.getNextInt(random, 0, Math.min(is.field_77994_a, 17 - ingredient.field_77994_a));
        return is.func_77946_l().func_77979_a(num);
    }

    private ItemStack getIngredient(Random random, int num) {
        int sc = this.getNextInt(random, 0, this.allowedIngredients.size() - 1);
        ItemStack item = this.allowedIngredients.get(sc);
        return item.func_77946_l().func_77979_a(Math.min(num, item.field_77994_a));
    }

    private int getNextInt(Random random, int min, int max) {
        return random.nextInt(Math.max(1, max - min + 1)) + min;
    }
}

