/*
 * Decompiled with CFR 0.152.
 */
package extracells.tileentity;

import appeng.api.AEApi;
import appeng.api.config.Actionable;
import appeng.api.implementations.ICraftingPatternItem;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridBlock;
import appeng.api.networking.IGridNode;
import appeng.api.networking.crafting.ICraftingMedium;
import appeng.api.networking.crafting.ICraftingPatternDetails;
import appeng.api.networking.crafting.ICraftingProvider;
import appeng.api.networking.crafting.ICraftingProviderHelper;
import appeng.api.networking.events.MENetworkCellArrayUpdate;
import appeng.api.networking.events.MENetworkCraftingPatternChange;
import appeng.api.networking.events.MENetworkEvent;
import appeng.api.networking.events.MENetworkEventSubscribe;
import appeng.api.networking.events.MENetworkPowerStatusChange;
import appeng.api.networking.security.BaseActionSource;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.security.MachineSource;
import appeng.api.networking.storage.IBaseMonitor;
import appeng.api.networking.storage.IStorageGrid;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.IMEMonitorHandlerReceiver;
import appeng.api.storage.data.IAEFluidStack;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.util.AECableType;
import appeng.api.util.DimensionalCoord;
import cpw.mods.fml.common.FMLCommonHandler;
import extracells.api.IECTileEntity;
import extracells.gridblock.ECFluidGridBlock;
import extracells.tileentity.IListenerTile;
import extracells.tileentity.TileBase;
import extracells.util.FluidUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.init.Items;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import org.apache.commons.lang3.tuple.MutablePair;

public class TileEntityFluidFiller
extends TileBase
implements IActionHost,
ICraftingProvider,
IECTileEntity,
IMEMonitorHandlerReceiver<IAEFluidStack>,
IListenerTile {
    private ECFluidGridBlock gridBlock;
    private IGridNode node = null;
    List<Fluid> fluids = new ArrayList<Fluid>();
    public ItemStack containerItem = new ItemStack(Items.field_151133_ar);
    ItemStack returnStack = null;
    int ticksToFinish = 0;
    private boolean isFirstGetGridNode = true;
    private final Item encodedPattern = (Item)AEApi.instance().definitions().items().encodedPattern().maybeItem().orNull();

    public TileEntityFluidFiller() {
        this.gridBlock = new ECFluidGridBlock(this);
    }

    @MENetworkEventSubscribe
    public void cellUpdate(MENetworkCellArrayUpdate event) {
        IStorageGrid storage = this.getStorageGrid();
        if (storage != null) {
            this.postChange((IBaseMonitor<IAEFluidStack>)storage.getFluidInventory(), null, null);
        }
    }

    public IGridNode getActionableNode() {
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            return null;
        }
        if (this.node == null) {
            this.node = AEApi.instance().createGridNode((IGridBlock)this.gridBlock);
        }
        return this.node;
    }

    public AECableType getCableConnectionType(ForgeDirection dir) {
        return AECableType.DENSE;
    }

    public Packet func_145844_m() {
        NBTTagCompound nbtTag = new NBTTagCompound();
        this.func_145841_b(nbtTag);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 1, nbtTag);
    }

    public IGridNode getGridNode(ForgeDirection dir) {
        if (FMLCommonHandler.instance().getSide().isClient() && (this.func_145831_w() == null || this.func_145831_w().field_72995_K)) {
            return null;
        }
        if (this.isFirstGetGridNode) {
            this.isFirstGetGridNode = false;
            this.getActionableNode().updateState();
            IStorageGrid storage = this.getStorageGrid();
            storage.getFluidInventory().addListener((IMEMonitorHandlerReceiver)this, null);
        }
        return this.node;
    }

    @Override
    public DimensionalCoord getLocation() {
        return new DimensionalCoord((TileEntity)this);
    }

    private ItemStack getPattern(ItemStack emptyContainer, ItemStack filledContainer) {
        NBTTagList in = new NBTTagList();
        NBTTagList out = new NBTTagList();
        in.func_74742_a((NBTBase)emptyContainer.func_77955_b(new NBTTagCompound()));
        out.func_74742_a((NBTBase)filledContainer.func_77955_b(new NBTTagCompound()));
        NBTTagCompound itemTag = new NBTTagCompound();
        itemTag.func_74782_a("in", (NBTBase)in);
        itemTag.func_74782_a("out", (NBTBase)out);
        itemTag.func_74757_a("crafting", false);
        ItemStack pattern = new ItemStack(this.encodedPattern);
        pattern.func_77982_d(itemTag);
        return pattern;
    }

    @Override
    public double getPowerUsage() {
        return 1.0;
    }

    private IStorageGrid getStorageGrid() {
        this.node = this.getGridNode(ForgeDirection.UNKNOWN);
        if (this.node == null) {
            return null;
        }
        IGrid grid = this.node.getGrid();
        if (grid == null) {
            return null;
        }
        return (IStorageGrid)grid.getCache(IStorageGrid.class);
    }

    public boolean isBusy() {
        return this.returnStack != null;
    }

    public boolean isValid(Object verificationToken) {
        return true;
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public void onListUpdate() {
    }

    public void postChange(IBaseMonitor<IAEFluidStack> monitor, Iterable<IAEFluidStack> change, BaseActionSource actionSource) {
        ArrayList<Fluid> oldFluids = new ArrayList<Fluid>(this.fluids);
        boolean mustUpdate = false;
        this.fluids.clear();
        for (IAEFluidStack fluid : ((IMEMonitor)monitor).getStorageList()) {
            if (!oldFluids.contains(fluid.getFluid())) {
                mustUpdate = true;
            } else {
                oldFluids.remove(fluid.getFluid());
            }
            this.fluids.add(fluid.getFluid());
        }
        if ((!oldFluids.isEmpty() || mustUpdate) && this.getGridNode(ForgeDirection.UNKNOWN) != null && this.getGridNode(ForgeDirection.UNKNOWN).getGrid() != null) {
            this.getGridNode(ForgeDirection.UNKNOWN).getGrid().postEvent((MENetworkEvent)new MENetworkCraftingPatternChange((ICraftingProvider)this, this.getGridNode(ForgeDirection.UNKNOWN)));
        }
    }

    public void postUpdateEvent() {
        if (this.getGridNode(ForgeDirection.UNKNOWN) != null && this.getGridNode(ForgeDirection.UNKNOWN).getGrid() != null) {
            this.getGridNode(ForgeDirection.UNKNOWN).getGrid().postEvent((MENetworkEvent)new MENetworkCraftingPatternChange((ICraftingProvider)this, this.getGridNode(ForgeDirection.UNKNOWN)));
        }
    }

    @MENetworkEventSubscribe
    public void powerUpdate(MENetworkPowerStatusChange event) {
        IStorageGrid storage = this.getStorageGrid();
        if (storage != null) {
            this.postChange((IBaseMonitor<IAEFluidStack>)storage.getFluidInventory(), null, null);
        }
    }

    public void provideCrafting(ICraftingProviderHelper craftingTracker) {
        IStorageGrid storage = this.getStorageGrid();
        if (storage == null) {
            return;
        }
        IMEMonitor fluidStorage = storage.getFluidInventory();
        for (IAEFluidStack fluidStack : fluidStorage.getStorageList()) {
            int maxCapacity;
            Fluid fluid = fluidStack.getFluid();
            if (fluid == null || (maxCapacity = FluidUtil.getCapacity(this.containerItem)) == 0) continue;
            MutablePair<Integer, ItemStack> filled = FluidUtil.fillStack(this.containerItem.func_77946_l(), new FluidStack(fluid, maxCapacity));
            if (filled.right == null) continue;
            ItemStack pattern = this.getPattern(this.containerItem, (ItemStack)filled.right);
            ICraftingPatternItem patter = (ICraftingPatternItem)pattern.func_77973_b();
            craftingTracker.addCraftingOption((ICraftingMedium)this, patter.getPatternForItem(pattern, this.func_145831_w()));
        }
    }

    public boolean pushPattern(ICraftingPatternDetails patternDetails, InventoryCrafting table) {
        if (this.returnStack != null) {
            return false;
        }
        ItemStack filled = patternDetails.getCondensedOutputs()[0].getItemStack();
        FluidStack fluid = FluidUtil.getFluidFromContainer(filled);
        IStorageGrid storage = this.getStorageGrid();
        if (storage == null) {
            return false;
        }
        IAEFluidStack fluidStack = AEApi.instance().storage().createFluidStack(new FluidStack(fluid.getFluid(), FluidUtil.getCapacity(patternDetails.getCondensedInputs()[0].getItemStack())));
        IAEFluidStack extracted = (IAEFluidStack)storage.getFluidInventory().extractItems((IAEStack)fluidStack.copy(), Actionable.SIMULATE, (BaseActionSource)new MachineSource((IActionHost)this));
        if (extracted == null || extracted.getStackSize() != fluidStack.getStackSize()) {
            return false;
        }
        storage.getFluidInventory().extractItems((IAEStack)fluidStack, Actionable.MODULATE, (BaseActionSource)new MachineSource((IActionHost)this));
        this.returnStack = filled;
        this.ticksToFinish = 40;
        return true;
    }

    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        if (tagCompound.func_74764_b("container")) {
            this.containerItem = ItemStack.func_77949_a((NBTTagCompound)tagCompound.func_74775_l("container"));
        } else if (tagCompound.func_74764_b("isContainerEmpty") && tagCompound.func_74767_n("isContainerEmpty")) {
            this.containerItem = null;
        }
        if (tagCompound.func_74764_b("return")) {
            this.returnStack = ItemStack.func_77949_a((NBTTagCompound)tagCompound.func_74775_l("return"));
        } else if (tagCompound.func_74764_b("isReturnEmpty") && tagCompound.func_74767_n("isReturnEmpty")) {
            this.returnStack = null;
        }
        if (tagCompound.func_74764_b("time")) {
            this.ticksToFinish = tagCompound.func_74762_e("time");
        }
        if (this.func_145830_o()) {
            IGridNode node = this.getGridNode(ForgeDirection.UNKNOWN);
            if (tagCompound.func_74764_b("nodes") && node != null) {
                node.loadFromNBT("node0", tagCompound.func_74775_l("nodes"));
                node.updateState();
            }
        }
    }

    @Override
    public void registerListener() {
        IStorageGrid storage = this.getStorageGrid();
        if (storage == null) {
            return;
        }
        this.postChange((IBaseMonitor<IAEFluidStack>)storage.getFluidInventory(), null, null);
        storage.getFluidInventory().addListener((IMEMonitorHandlerReceiver)this, null);
    }

    @Override
    public void removeListener() {
        IStorageGrid storage = this.getStorageGrid();
        if (storage == null) {
            return;
        }
        storage.getFluidInventory().removeListener((IMEMonitorHandlerReceiver)this);
    }

    public void securityBreak() {
        if (this.func_145831_w() != null) {
            this.func_145831_w().func_147480_a(this.field_145851_c, this.field_145848_d, this.field_145849_e, true);
        }
    }

    public void func_145845_h() {
        if (this.func_145831_w() == null || this.func_145831_w().field_73011_w == null) {
            return;
        }
        if (this.ticksToFinish > 0) {
            --this.ticksToFinish;
        }
        if (this.ticksToFinish <= 0 && this.returnStack != null) {
            IAEItemStack nodAdded;
            IStorageGrid storage = this.getStorageGrid();
            if (storage == null) {
                return;
            }
            IAEItemStack toInject = AEApi.instance().storage().createItemStack(this.returnStack);
            if (storage.getItemInventory().canAccept((IAEStack)toInject.copy()) && (nodAdded = (IAEItemStack)storage.getItemInventory().injectItems((IAEStack)toInject.copy(), Actionable.SIMULATE, (BaseActionSource)new MachineSource((IActionHost)this))) == null) {
                storage.getItemInventory().injectItems((IAEStack)toInject, Actionable.MODULATE, (BaseActionSource)new MachineSource((IActionHost)this));
                this.returnStack = null;
            }
        }
    }

    @Override
    public void updateGrid(IGrid oldGrid, IGrid newGrid) {
        IStorageGrid storage;
        if (oldGrid != null && (storage = (IStorageGrid)oldGrid.getCache(IStorageGrid.class)) != null) {
            storage.getFluidInventory().removeListener((IMEMonitorHandlerReceiver)this);
        }
        if (newGrid != null && (storage = (IStorageGrid)newGrid.getCache(IStorageGrid.class)) != null) {
            storage.getFluidInventory().addListener((IMEMonitorHandlerReceiver)this, null);
        }
    }

    public void func_145841_b(NBTTagCompound tagCompound) {
        super.func_145841_b(tagCompound);
        if (this.containerItem != null) {
            tagCompound.func_74782_a("container", (NBTBase)this.containerItem.func_77955_b(new NBTTagCompound()));
        } else {
            tagCompound.func_74757_a("isContainerEmpty", true);
        }
        if (this.returnStack != null) {
            tagCompound.func_74782_a("return", (NBTBase)this.returnStack.func_77955_b(new NBTTagCompound()));
        } else {
            tagCompound.func_74757_a("isReturnEmpty", true);
        }
        tagCompound.func_74768_a("time", this.ticksToFinish);
        if (!this.func_145830_o()) {
            return;
        }
        IGridNode node = this.getGridNode(ForgeDirection.UNKNOWN);
        if (node != null) {
            NBTTagCompound nodeTag = new NBTTagCompound();
            node.saveToNBT("node0", nodeTag);
            tagCompound.func_74782_a("nodes", (NBTBase)nodeTag);
        }
    }
}

