/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.opis.swing.panels.timingserver;

import java.awt.Component;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.table.DefaultTableModel;
import mcp.mobius.opis.api.ITabPanel;
import mcp.mobius.opis.data.holders.ISerializable;
import mcp.mobius.opis.data.holders.newtypes.DataEntity;
import mcp.mobius.opis.data.holders.newtypes.DataTiming;
import mcp.mobius.opis.network.PacketBase;
import mcp.mobius.opis.network.enums.AccessLevel;
import mcp.mobius.opis.network.enums.Message;
import mcp.mobius.opis.swing.SelectedTab;
import mcp.mobius.opis.swing.actions.ActionRunOpis;
import mcp.mobius.opis.swing.actions.ActionTimingEntities;
import mcp.mobius.opis.swing.widgets.JButtonAccess;
import mcp.mobius.opis.swing.widgets.JPanelMsgHandler;
import mcp.mobius.opis.swing.widgets.JTableStats;
import net.miginfocom.swing.MigLayout;

public class PanelTimingEntities
extends JPanelMsgHandler
implements ITabPanel {
    private JButtonAccess btnRun;
    private JButtonAccess btnPull;
    private JButtonAccess btnTeleport;
    private JButtonAccess btnCenter;
    private JLabel lblSummary;

    public PanelTimingEntities() {
        this.setLayout(new MigLayout("", "[][][][grow][]", "[][grow][]"));
        this.btnCenter = new JButtonAccess("Center Map", AccessLevel.NONE);
        this.add((Component)this.btnCenter, "cell 0 0");
        this.btnCenter.addActionListener(new ActionTimingEntities());
        this.btnTeleport = new JButtonAccess("Teleport", AccessLevel.PRIVILEGED);
        this.add((Component)this.btnTeleport, "cell 1 0");
        this.btnTeleport.addActionListener(new ActionTimingEntities());
        this.btnPull = new JButtonAccess("Pull", AccessLevel.PRIVILEGED);
        this.add((Component)this.btnPull, "cell 2 0");
        this.btnPull.addActionListener(new ActionTimingEntities());
        this.btnRun = new JButtonAccess("Run Opis", AccessLevel.PRIVILEGED);
        this.add((Component)this.btnRun, "cell 4 0");
        this.btnRun.addActionListener(new ActionRunOpis());
        JScrollPane scrollPane = new JScrollPane();
        this.add((Component)scrollPane, "cell 0 1 5 1,grow");
        this.table = new JTableStats(new String[]{"Type", "ID", "Dim", "Pos", "Update Time", "Data"}, new Class[]{String.class, Integer.class, Integer.class, Object.class, DataTiming.class, Integer.class});
        scrollPane.setViewportView(this.table);
        this.lblSummary = new JLabel("New label");
        this.add((Component)this.lblSummary, "cell 0 2 5 1,alignx center");
    }

    public JButton getBtnRun() {
        return this.btnRun;
    }

    public JButton getBtnPull() {
        return this.btnPull;
    }

    public JButton getBtnTeleport() {
        return this.btnTeleport;
    }

    public JButton getBtnCenter() {
        return this.btnCenter;
    }

    public JLabel getLblSummary() {
        return this.lblSummary;
    }

    @Override
    public boolean handleMessage(Message msg, PacketBase rawdata) {
        switch (msg) {
            case LIST_TIMING_ENTITIES: {
                this.cacheData(msg, rawdata);
                this.getTable().setTableData(rawdata.array);
                DefaultTableModel model = this.table.getModel();
                int row = this.getTable().clearTable(DataEntity.class);
                for (ISerializable o : rawdata.array) {
                    DataEntity data = (DataEntity)o;
                    model.addRow(new Object[]{data.name, data.eid, data.pos.dim, String.format("[ %4d %4d %4d ]", data.pos.x, data.pos.y, data.pos.z), data.update, data.npoints});
                }
                this.getTable().dataUpdated(row);
                break;
            }
            case VALUE_TIMING_ENTITIES: {
                this.getLblSummary().setText(String.format("Total update time : %s", ((DataTiming)rawdata.value).toString()));
                break;
            }
            case STATUS_START: {
                this.getBtnRun().setText("Running...");
                break;
            }
            case STATUS_STOP: {
                this.getBtnRun().setText("Run Opis");
                break;
            }
            case STATUS_RUNNING: {
                this.getBtnRun().setText("Running...");
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    @Override
    public SelectedTab getSelectedTab() {
        return SelectedTab.TIMINGENTITES;
    }

    @Override
    public boolean refreshOnString() {
        return true;
    }
}

