/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.opis.data.holders.stats;

import com.google.common.io.ByteArrayDataOutput;
import mcp.mobius.opis.data.holders.ISerializable;
import mcp.mobius.opis.data.holders.basetypes.CoordinatesBlock;
import mcp.mobius.opis.data.holders.basetypes.CoordinatesChunk;
import opisapache.math3.stat.descriptive.DescriptiveStatistics;

public abstract class StatAbstract
implements Comparable,
ISerializable {
    protected DescriptiveStatistics dstat = new DescriptiveStatistics();
    public Long dataPoints = 0L;
    protected Double geomMean = null;
    protected Double dataSum = null;
    protected CoordinatesBlock coord = CoordinatesBlock.INVALID;
    protected CoordinatesChunk chunk = CoordinatesChunk.INVALID;
    protected String name;

    public void addMeasure(long timing) {
        this.dstat.addValue((double)timing / 1000.0);
        this.dataPoints = this.dataPoints + 1L;
    }

    public void addMeasure(double timing) {
        this.dstat.addValue(timing);
        this.dataPoints = this.dataPoints + 1L;
    }

    public double getGeometricMean() {
        if (this.geomMean != null) {
            return this.geomMean;
        }
        return this.dstat.getGeometricMean();
    }

    public void setGeometricMean(double value) {
        this.geomMean = value;
    }

    public double getDataSum() {
        if (this.dataSum != null) {
            return this.dataSum;
        }
        return this.dstat.getSum();
    }

    public void setDataSum(double value) {
        this.dataSum = value;
    }

    public long getDataPoints() {
        return this.dataPoints;
    }

    public void setDataPoints(long ndata) {
        this.dataPoints = ndata;
    }

    public int compareTo(Object o) {
        double value = ((StatAbstract)o).getGeometricMean() - this.getGeometricMean();
        if (value > 0.0) {
            return 1;
        }
        if (value < 0.0) {
            return -1;
        }
        return 0;
    }

    public String getName() {
        return this.name;
    }

    public CoordinatesBlock getCoordinates() {
        return this.coord;
    }

    public CoordinatesChunk getChunk() {
        return this.chunk;
    }

    public CoordinatesBlock getTeleportTarget() {
        return this.coord;
    }

    @Override
    public abstract void writeToStream(ByteArrayDataOutput var1);
}

