/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.wawla.util;

import cpw.mods.fml.common.registry.VillagerRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import net.darkhax.wawla.util.Constants;
import net.minecraft.client.Minecraft;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.common.UsernameCache;
import org.apache.commons.lang3.SystemUtils;
import org.apache.commons.lang3.text.WordUtils;

public class Utilities {
    public static boolean isDevMode = false;
    @SideOnly(value=Side.CLIENT)
    private static String[] vanillaVillagers = new String[]{"farmer", "librarian", "priest", "blacksmith", "butcher"};
    public static Field currentBlockDamage;

    public static ItemStack prepareStackCompound(ItemStack stack) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        return stack;
    }

    public static List wrapStringToList(String string, int lnLength, boolean wrapLongWords, List list) {
        String[] strings = WordUtils.wrap((String)string, (int)lnLength, null, (boolean)wrapLongWords).split(SystemUtils.LINE_SEPARATOR);
        list.addAll(Arrays.asList(strings));
        return list;
    }

    public static Enchantment[] getEnchantmentsFromStack(ItemStack stack, boolean stored) {
        Utilities.prepareStackCompound(stack);
        String tagName = stored ? "StoredEnchantments" : "ench";
        NBTTagCompound tag = stack.field_77990_d;
        NBTTagList list = tag.func_150295_c(tagName, 10);
        Enchantment[] ench = new Enchantment[list.func_74745_c()];
        for (int i = 0; i < list.func_74745_c(); ++i) {
            ench[i] = Enchantment.field_77331_b[list.func_150305_b(i).func_74765_d("id")];
        }
        return ench;
    }

    public static double round(double value, int places) {
        if (value >= 0.0 && places > 0) {
            BigDecimal bd = new BigDecimal(value);
            bd = bd.setScale(places, RoundingMode.HALF_UP);
            return bd.doubleValue();
        }
        return value;
    }

    public static String[] generateElementArray(Class enumClass) {
        if (enumClass != null) {
            T[] constants = enumClass.getEnumConstants();
            String[] elements = new String[constants.length];
            for (int i = 0; i < constants.length; ++i) {
                elements[i] = constants[i].toString();
            }
            return elements;
        }
        return null;
    }

    public static ItemStack[] getInventoryStacks(NBTTagCompound tag, int invSize) {
        ItemStack[] inventory = null;
        if (tag.func_74764_b("Items")) {
            NBTTagList list = tag.func_150295_c("Items", 10);
            inventory = new ItemStack[invSize];
            for (int i = 0; i < list.func_74745_c(); ++i) {
                if (i > list.func_74745_c()) continue;
                NBTTagCompound currentTag = list.func_150305_b(i);
                inventory[currentTag.func_74771_c((String)"Slot")] = ItemStack.func_77949_a((NBTTagCompound)currentTag);
            }
        }
        return inventory;
    }

    public static boolean compareByClass(Class class1, Class class2) {
        return class1 != null && class2 != null ? class1.getName().equalsIgnoreCase(class2.getName()) : false;
    }

    public static boolean compareTileEntityByClass(TileEntity entity, Class teClass) {
        return Utilities.compareByClass(entity.getClass(), teClass);
    }

    public static float getProgression(float curStage, float maxStage) {
        return curStage / maxStage * 100.0f;
    }

    public static String upperCase(String string) {
        return Character.toString(string.charAt(0)).toUpperCase() + string.substring(1);
    }

    public static int getBlockLightLevel(World world, int x, int y, int z, boolean day) {
        return day ? world.func_72964_e(x >> 4, z >> 4).func_76629_c(x & 0xF, y + 1, z & 0xF, 0) : world.func_72964_e(x >> 4, z >> 4).func_76629_c(x & 0xF, y + 1, z & 0xF, 16);
    }

    public static Class getClass(String className) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            Constants.LOG.warn("A class could not be found! This will cause issues, please report to Darkhax!");
            e.printStackTrace();
            return null;
        }
    }

    public static String getUsernameByUUID(String uuid) {
        String username = null;
        if (!uuid.isEmpty() && uuid.length() > 0) {
            username = UsernameCache.getLastKnownUsername((UUID)UUID.fromString(uuid));
        }
        if (username == null) {
            username = StatCollector.func_74838_a((String)"tooltip.wawla.unknownplayer");
        }
        return username;
    }

    public static boolean canPlayerSleep(EntityPlayer player) {
        return !player.func_70608_bn() && player.func_70089_S() && player.field_70170_p.func_72820_D() > 12541L && player.field_70170_p.func_72820_D() < 23458L;
    }

    public static NBTTagCompound getDeepTagCompound(NBTTagCompound tag, String[] tags) {
        NBTTagCompound deepTag = tag;
        if (tag != null) {
            for (String tagName : tags) {
                if (!deepTag.func_74764_b(tagName)) continue;
                deepTag = deepTag.func_74775_l(tagName);
            }
        }
        return deepTag;
    }

    @SideOnly(value=Side.CLIENT)
    public static String getVillagerName(int id) {
        ResourceLocation skin = VillagerRegistry.getVillagerSkin((int)id, null);
        return id >= 0 && id <= 4 ? vanillaVillagers[id] : (skin != null ? skin.func_110624_b() + "." + skin.func_110623_a().substring(skin.func_110623_a().lastIndexOf("/") + 1, skin.func_110623_a().length() - 4) : "misingno");
    }

    @SideOnly(value=Side.CLIENT)
    public static float getBlockDamage() {
        if (currentBlockDamage == null) {
            return 0.0f;
        }
        try {
            return currentBlockDamage.getFloat(Minecraft.func_71410_x().field_71442_b);
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        return 0.0f;
    }
}

