/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils.tileentity;

import com.rwtema.extrautils.network.XUPacketBase;
import com.rwtema.extrautils.network.packets.PacketVillager;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.IMerchant;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.Vec3;
import net.minecraft.village.MerchantRecipeList;

public class TileEntityTradingPost
extends TileEntity {
    public static int maxRange = 32;
    public int[] ids = null;
    public MerchantRecipeList[] data = null;

    public boolean canUpdate() {
        return false;
    }

    public AxisAlignedBB getAABB() {
        return AxisAlignedBB.func_72330_a((double)((double)this.field_145851_c + 0.5 - (double)maxRange), (double)0.0, (double)((double)this.field_145849_e + 0.5 - (double)maxRange), (double)((double)this.field_145851_c + 0.5 + (double)maxRange), (double)255.0, (double)((double)this.field_145849_e + 0.5 + (double)maxRange));
    }

    public List<IMerchant> getVillagers() {
        List t = this.field_145850_b.func_72872_a(IMerchant.class, this.getAABB());
        ArrayList<IMerchant> traders = new ArrayList<IMerchant>();
        for (Object aT : t) {
            if (!this.isValidVillager((IMerchant)aT, true)) continue;
            traders.add((IMerchant)aT);
        }
        return traders;
    }

    public boolean isValidVillager(IMerchant villager, boolean locationAlreadyChecked) {
        return villager instanceof EntityLiving && !((EntityLiving)villager).func_70631_g_() && (locationAlreadyChecked || this.getAABB().func_72318_a(Vec3.func_72443_a((double)((EntityLiving)villager).field_70165_t, (double)((EntityLiving)villager).field_70163_u, (double)((EntityLiving)villager).field_70161_v)));
    }

    public XUPacketBase getTradePacket(EntityPlayer player) {
        List<IMerchant> traders = this.getVillagers();
        if (traders == null || traders.size() == 0) {
            return null;
        }
        NBTTagCompound pkt = new NBTTagCompound();
        int n = 0;
        pkt.func_74768_a("player_id", player.func_145782_y());
        for (int i = 0; i < traders.size(); ++i) {
            IMerchant v = traders.get(i);
            pkt.func_74768_a("i" + i, ((EntityLiving)v).func_145782_y());
            pkt.func_74782_a("t" + i, (NBTBase)v.func_70934_b(null).func_77202_a());
            ++n;
        }
        if (n == 0) {
            return null;
        }
        pkt.func_74768_a("n", n);
        return new PacketVillager(this.field_145851_c, this.field_145848_d, this.field_145849_e, pkt);
    }

    public double distSq(double x, double y, double z) {
        return (x -= (double)this.field_145851_c + 0.5) * x + (y -= (double)this.field_145848_d + 0.5) * y + (z -= (double)this.field_145849_e + 0.5) * z;
    }

    public int toInt(Object x) {
        if (x instanceof Double) {
            return (int)Math.floor((Double)x);
        }
        if (x instanceof Float) {
            return (int)Math.floor(((Float)x).floatValue());
        }
        if (x instanceof Integer) {
            return (Integer)x;
        }
        if (x instanceof String) {
            return Integer.parseInt((String)x);
        }
        return 0;
    }
}

