/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils.gui;

import com.rwtema.extrautils.asm.FluidIDGetter;
import com.rwtema.extrautils.gui.InventoryTweaksHelper;
import com.rwtema.extrautils.gui.SlotChecksValidity;
import com.rwtema.extrautils.tileentity.transfernodes.TileEntityTransferNode;
import com.rwtema.extrautils.tileentity.transfernodes.TileEntityTransferNodeEnergy;
import com.rwtema.extrautils.tileentity.transfernodes.TileEntityTransferNodeInventory;
import com.rwtema.extrautils.tileentity.transfernodes.TileEntityTransferNodeLiquid;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import invtweaks.api.container.ContainerSection;
import invtweaks.api.container.ContainerSectionCallback;
import invtweaks.api.container.InventoryContainer;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

@InventoryContainer
public class ContainerTransferNode
extends Container {
    public int lastenergy = 0;
    public int lastenergycount = 0;
    public int liquid_type = -1;
    public int liquid_amount = -1;
    private TileEntityTransferNode node;
    private IInventory player;
    private int lastpipe_x = 0;
    private int lastpipe_y = 0;
    private int lastpipe_z = 0;

    public ContainerTransferNode(IInventory player, TileEntityTransferNode node) {
        this.node = node;
        if (node instanceof IInventory) {
            this.func_75146_a(new Slot((IInventory)node, 0, 80, 83));
        }
        for (int i = 0; i < node.upgrades.func_70302_i_(); ++i) {
            this.func_75146_a(new SlotChecksValidity((IInventory)node.upgrades, i, 35 + i * 18, 121));
        }
        for (int iy = 0; iy < 3; ++iy) {
            for (int ix = 0; ix < 9; ++ix) {
                this.func_75146_a(new Slot(player, ix + iy * 9 + 9, 8 + ix * 18, 143 + iy * 18));
            }
        }
        for (int ix = 0; ix < 9; ++ix) {
            this.func_75146_a(new Slot(player, ix, 8 + ix * 18, 201));
        }
    }

    public void func_75132_a(ICrafting icrafting) {
        FluidStack t;
        super.func_75132_a(icrafting);
        this.lastpipe_x = this.node.pipe_x;
        icrafting.func_71112_a((Container)this, 0, this.lastpipe_x);
        this.lastpipe_y = this.node.pipe_y;
        icrafting.func_71112_a((Container)this, 1, this.lastpipe_y);
        this.lastpipe_z = this.node.pipe_z;
        icrafting.func_71112_a((Container)this, 2, this.lastpipe_z);
        if (this.node instanceof TileEntityTransferNodeEnergy) {
            this.lastenergycount = ((TileEntityTransferNodeEnergy)this.node).numMachines();
            icrafting.func_71112_a((Container)this, 3, this.lastenergycount);
            this.lastenergy = ((TileEntityTransferNodeEnergy)this.node).getEnergyStored(null);
            for (int i = 0; i < 3; ++i) {
                icrafting.func_71112_a((Container)this, 6 + i, (int)ContainerTransferNode.convToShort(this.lastenergy, i));
            }
        }
        int newliquid_type = -1;
        int newliquid_amount = -1;
        if (this.node instanceof TileEntityTransferNodeLiquid && (t = ((TileEntityTransferNodeLiquid)this.node).getTankInfo(null)[0].fluid) != null && t.amount > 0) {
            newliquid_type = FluidIDGetter.fluidLegacy.getID(t);
            newliquid_amount = t.amount;
            icrafting.func_71112_a((Container)this, 4, newliquid_type);
            icrafting.func_71112_a((Container)this, 5, newliquid_amount);
        }
    }

    public ItemStack func_82846_b(EntityPlayer par1EntityPlayer, int par2) {
        ItemStack itemstack = null;
        Slot slot = (Slot)this.field_75151_b.get(par2);
        int start = 0;
        int end = this.node.upgrades.func_70302_i_();
        if (this.node instanceof TileEntityTransferNodeInventory) {
            ++start;
            ++end;
        }
        if (slot != null && slot.func_75216_d()) {
            ItemStack itemstack1 = slot.func_75211_c();
            itemstack = itemstack1.func_77946_l();
            if (par2 < end ? !this.func_75135_a(itemstack1, end, this.field_75151_b.size(), true) : !(this.node.upgrades.func_94041_b(0, itemstack1) && this.func_75135_a(itemstack1, start, end, false) || start != 0 && this.func_75135_a(itemstack1, 0, start, false))) {
                return null;
            }
            if (itemstack1.field_77994_a == 0) {
                slot.func_75215_d(null);
            } else {
                slot.func_75218_e();
            }
        }
        return itemstack;
    }

    public boolean func_75145_c(EntityPlayer entityplayer) {
        return this.node.isUseableByPlayer(entityplayer);
    }

    public void func_75142_b() {
        FluidStack t;
        super.func_75142_b();
        int newenergy = -1;
        int newenergycount = -1;
        if (this.node instanceof TileEntityTransferNodeEnergy) {
            newenergy = ((TileEntityTransferNodeEnergy)this.node).getEnergyStored(null);
            newenergycount = ((TileEntityTransferNodeEnergy)this.node).numMachines();
        }
        int newliquid_type = -1;
        int newliquid_type_metadata = -1;
        int newliquid_amount = -1;
        if (this.node instanceof TileEntityTransferNodeLiquid && (t = ((TileEntityTransferNodeLiquid)this.node).getTankInfo(null)[0].fluid) != null && t.amount > 0) {
            newliquid_type = FluidIDGetter.fluidLegacy.getID(t);
            newliquid_amount = t.amount;
        }
        for (Object crafter : this.field_75149_d) {
            ICrafting icrafting = (ICrafting)crafter;
            if (this.lastpipe_x != this.node.pipe_x || this.lastpipe_y != this.node.pipe_y || this.lastpipe_z != this.node.pipe_z) {
                icrafting.func_71112_a((Container)this, 0, this.node.pipe_x);
                icrafting.func_71112_a((Container)this, 1, this.node.pipe_y);
                icrafting.func_71112_a((Container)this, 2, this.node.pipe_z);
            }
            if (newenergycount != this.lastenergycount) {
                icrafting.func_71112_a((Container)this, 3, newenergycount);
            }
            if (this.liquid_type != newliquid_type || this.liquid_amount != newliquid_amount) {
                icrafting.func_71112_a((Container)this, 4, newliquid_type);
                icrafting.func_71112_a((Container)this, 5, newliquid_amount);
            }
            if (ContainerTransferNode.convToShort(newenergy, 2) != ContainerTransferNode.convToShort(this.lastenergy, 0)) {
                icrafting.func_71112_a((Container)this, 6, (int)ContainerTransferNode.convToShort(this.lastenergy, 0));
            }
            if (ContainerTransferNode.convToShort(newenergy, 1) != ContainerTransferNode.convToShort(this.lastenergy, 1)) {
                icrafting.func_71112_a((Container)this, 7, (int)ContainerTransferNode.convToShort(this.lastenergy, 1));
            }
            if (ContainerTransferNode.convToShort(newenergy, 2) == ContainerTransferNode.convToShort(this.lastenergy, 2)) continue;
            icrafting.func_71112_a((Container)this, 8, (int)ContainerTransferNode.convToShort(this.lastenergy, 2));
        }
        this.lastpipe_x = this.node.pipe_x;
        this.lastpipe_y = this.node.pipe_y;
        this.lastpipe_z = this.node.pipe_z;
        this.lastenergy = newenergy;
        this.lastenergycount = newenergycount;
        this.liquid_type = newliquid_type;
        this.liquid_amount = newliquid_amount;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_75137_b(int par1, int par2) {
        switch (par1) {
            case 0: {
                this.node.pipe_x = par2;
            }
            case 1: {
                this.node.pipe_y = par2;
            }
            case 2: {
                this.node.pipe_z = par2;
                break;
            }
            case 3: {
                this.lastenergycount = par2;
                break;
            }
            case 4: {
                this.liquid_type = par2;
                break;
            }
            case 5: {
                this.liquid_amount = par2;
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                this.lastenergy = (int)ContainerTransferNode.changeShort(this.lastenergy, (short)par2, par1 - 6);
            }
        }
    }

    public static short convToShort(double t, int level) {
        switch (level) {
            case 0: {
                return (short)Math.floor((t - Math.floor(t)) * 32768.0);
            }
            case 1: {
                return (short)(Math.floor(t) % 32768.0);
            }
            case 2: {
                return (short)Math.floor(t / 32768.0);
            }
        }
        return 0;
    }

    public static float changeShort(float t, short k, int level) {
        short[] v = new short[3];
        for (int i = 0; i < 3; ++i) {
            v[i] = i == level ? k : ContainerTransferNode.convToShort(t, i);
        }
        return (float)(v[2] * 32768 + v[1]) + (float)v[0] / 32768.0f;
    }

    @ContainerSectionCallback
    public Map<ContainerSection, List<Slot>> getSlots() {
        return InventoryTweaksHelper.getSlots(this, false);
    }
}

