/*
 * Decompiled with CFR 0.152.
 */
package com.austinv11.peripheralsplusplus.utils;

import com.austinv11.peripheralsplusplus.reference.Config;
import com.gtranslate.Language;
import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.lua.ILuaObject;
import dan200.computercraft.api.turtle.ITurtleAccess;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.tileentity.TileEntity;

public class ReflectionHelper {
    private static ArrayList<Integer> usedIds = new ArrayList();

    public static ITurtleAccess getTurtle(TileEntity te) throws Exception {
        Method getAccess;
        ITurtleAccess turtle;
        if (te instanceof ITurtleAccess) {
            return (ITurtleAccess)te;
        }
        Class<?> teClass = te.getClass();
        if ((teClass.getName().equals("dan200.computercraft.shared.turtle.blocks.TileTurtleExpanded") || teClass.getName().equals("dan200.computercraft.shared.turtle.blocks.TileTurtleAdvanced") || teClass.getName().equals("dan200.computercraft.shared.turtle.blocks.TileTurtle")) && (turtle = (ITurtleAccess)(getAccess = teClass.getMethod("getAccess", new Class[0])).invoke((Object)te, new Object[0])) != null) {
            return turtle;
        }
        return null;
    }

    public static String getLangFromWord(String lang) throws NoSuchFieldException, IllegalAccessException {
        Field field = Language.class.getDeclaredField("hashLanguage");
        field.setAccessible(true);
        HashMap hashLanguage = (HashMap)field.get(Language.getInstance());
        for (String k : hashLanguage.keySet()) {
            if (!((String)hashLanguage.get(k)).equalsIgnoreCase(lang)) continue;
            return k;
        }
        return null;
    }

    public static Object getICompFromId(int id) throws ClassNotFoundException, NoSuchMethodException, NoSuchFieldException, IllegalAccessException, InvocationTargetException {
        Class<?> computerRegistry = Class.forName("dan200.computercraft.shared.computer.core.ComputerRegistry");
        Method getCompFromId = computerRegistry.getMethod("lookup", Integer.TYPE);
        Object registry = Class.forName("dan200.computercraft.ComputerCraft").getField("serverComputerRegistry").get(null);
        return getCompFromId.invoke(registry, id);
    }

    public static Object objectToLuaValue(Object o) throws ClassNotFoundException, IllegalAccessException, InstantiationException, NoSuchMethodException, InvocationTargetException {
        Class<?> luaMachine = Class.forName("dan200.computercraft.core.lua.LuaJLuaMachine");
        Object machine = luaMachine.newInstance();
        Method toVal = luaMachine.getDeclaredMethod("toValue", Object.class);
        toVal.setAccessible(true);
        return toVal.invoke(machine, o);
    }

    public static Object getLuaMachineFromId(int id) throws ClassNotFoundException, NoSuchMethodException, InvocationTargetException, IllegalAccessException, NoSuchFieldException {
        Object iComp = ReflectionHelper.getICompFromId(id);
        Class<?> iCompClass = iComp.getClass().asSubclass(Class.forName("dan200.computercraft.shared.computer.core.ServerComputer"));
        Field compField = iCompClass.getDeclaredField("m_computer");
        compField.setAccessible(true);
        Object comp = compField.get(iComp);
        Class<?> compClass = comp.getClass();
        Field machine = compClass.getDeclaredField("m_machine");
        machine.setAccessible(true);
        return machine.get(comp);
    }

    public static void runProgram(String path, int id) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException, ClassNotFoundException, NoSuchFieldException, InstantiationException {
        Object machineObject = ReflectionHelper.getLuaMachineFromId(id);
        Class<?> machineClass = machineObject.getClass();
        Field globals = machineClass.getDeclaredField("m_globals");
        globals.setAccessible(true);
        Object globalsObj = globals.get(machineObject);
        Method load = globalsObj.getClass().getDeclaredMethod("get", Class.forName("org.luaj.vm2.LuaValue"));
        load.setAccessible(true);
        Object chunk = load.invoke(globalsObj, ReflectionHelper.objectToLuaValue("os"));
        Method get_ = chunk.getClass().getDeclaredMethod("get", Class.forName("org.luaj.vm2.LuaValue"));
        get_.setAccessible(true);
        Object run = get_.invoke(chunk, ReflectionHelper.objectToLuaValue("run"));
        Method call = run.getClass().getDeclaredMethod("call", Class.forName("org.luaj.vm2.LuaValue"), Class.forName("org.luaj.vm2.LuaValue"));
        call.invoke(run, Class.forName("org.luaj.vm2.LuaTable").newInstance(), ReflectionHelper.objectToLuaValue(path));
    }

    public static void registerAPI(final int id, final ILuaAPIProxy api) throws ClassNotFoundException, NoSuchMethodException, NoSuchFieldException, IllegalAccessException, InvocationTargetException {
        if (!Config.enableAPIs) {
            return;
        }
        if (usedIds.contains(id)) {
            return;
        }
        Object o = ReflectionHelper.getLuaMachineFromId(id);
        if (o == null) {
            new Thread(){
                private boolean work = true;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    if (this.work) {
                        Object serverComputerObject = null;
                        try {
                            1 var2_2 = this;
                            synchronized (var2_2) {
                                this.wait(20L);
                            }
                            serverComputerObject = ReflectionHelper.getICompFromId(id);
                            Class<?> serverCompClass = serverComputerObject.getClass().asSubclass(Class.forName("dan200.computercraft.shared.computer.core.ServerComputer"));
                            Field comp = serverCompClass.getDeclaredField("m_computer");
                            comp.setAccessible(true);
                            Object o = comp.get(serverComputerObject);
                            Method addAPI = o.getClass().getDeclaredMethod("addAPI", Class.forName("dan200.computercraft.core.apis.ILuaAPI"));
                            addAPI.invoke(o, Proxy.newProxyInstance(Class.forName("dan200.computercraft.core.apis.ILuaAPI").getClassLoader(), new Class[]{Class.forName("dan200.computercraft.core.apis.ILuaAPI")}, (InvocationHandler)api));
                            Method reboot = o.getClass().getDeclaredMethod("reboot", new Class[0]);
                            reboot.invoke(o, new Object[0]);
                            this.work = false;
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
            }.start();
            usedIds.add(id);
            return;
        }
        Method addAPI = o.getClass().getDeclaredMethod("addAPI", Class.forName("dan200.computercraft.core.apis.ILuaAPI"));
        addAPI.invoke(o, Proxy.newProxyInstance(Class.forName("dan200.computercraft.core.apis.ILuaAPI").getClassLoader(), new Class[]{Class.forName("dan200.computercraft.core.apis.ILuaAPI")}, (InvocationHandler)api));
    }

    public static abstract class ILuaAPIProxy
    implements InvocationHandler,
    ILuaObject {
        public abstract String[] getNames();

        public abstract void startup();

        public abstract void advance(double var1);

        public abstract void shutdown();

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (method.getName().equals("getNames")) {
                return this.getNames();
            }
            if (method.getName().equals("startup")) {
                this.startup();
            } else if (method.getName().equals("advance")) {
                this.advance((Double)args[0]);
            } else if (method.getName().equals("shutdown")) {
                this.shutdown();
            } else {
                if (method.getName().equals("getMethodNames")) {
                    return this.getMethodNames();
                }
                if (method.getName().equals("callMethod")) {
                    return this.callMethod((ILuaContext)args[0], (Integer)args[1], (Object[])args[2]);
                }
            }
            return null;
        }
    }
}

