/*
 * Decompiled with CFR 0.152.
 */
package com.austinv11.peripheralsplusplus.turtles.peripherals;

import com.austinv11.peripheralsplusplus.reference.Config;
import com.austinv11.peripheralsplusplus.turtles.peripherals.MountedPeripheral;
import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.api.turtle.ITurtleAccess;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCocoa;
import net.minecraft.block.IGrowable;
import net.minecraft.init.Items;
import net.minecraft.item.ItemDye;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Facing;
import net.minecraft.world.World;

public class PeripheralGarden
extends MountedPeripheral {
    private ITurtleAccess turtle;

    public PeripheralGarden(ITurtleAccess turtle) {
        this.turtle = turtle;
    }

    public String getType() {
        return "gardener";
    }

    public String[] getMethodNames() {
        return new String[]{"getGrowth", "getGrowthUp", "getGrowthDown", "fertilize", "fertilizeUp", "fertilizeDown"};
    }

    public Object[] callMethod(IComputerAccess computer, ILuaContext context, int method, Object[] arguments) throws LuaException, InterruptedException {
        if (!Config.enableGardeningTurtle) {
            throw new LuaException("Gardening Turtles have been disabled!");
        }
        if (method == 0) {
            int blockX = this.turtle.getPosition().field_71574_a + Facing.field_71586_b[this.turtle.getDirection()];
            int blockY = this.turtle.getPosition().field_71572_b + Facing.field_71587_c[this.turtle.getDirection()];
            int blockZ = this.turtle.getPosition().field_71573_c + Facing.field_71585_d[this.turtle.getDirection()];
            Block blockFacing = this.turtle.getWorld().func_147439_a(blockX, blockY, blockZ);
            if (blockFacing instanceof IGrowable) {
                return new Object[]{Math.floor((float)this.turtle.getWorld().func_72805_g(blockX, blockY, blockZ) / (blockFacing instanceof BlockCocoa ? 8.0f : 7.0f) * 100.0f)};
            }
        } else if (method == 1) {
            int blockX = this.turtle.getPosition().field_71574_a;
            int blockY = this.turtle.getPosition().field_71572_b + 1;
            int blockZ = this.turtle.getPosition().field_71573_c;
            Block blockFacing = this.turtle.getWorld().func_147439_a(blockX, blockY, blockZ);
            if (blockFacing instanceof IGrowable) {
                return new Object[]{Math.floor((float)this.turtle.getWorld().func_72805_g(blockX, blockY, blockZ) / (blockFacing instanceof BlockCocoa ? 8.0f : 7.0f) * 100.0f)};
            }
        } else if (method == 2) {
            int blockX = this.turtle.getPosition().field_71574_a;
            int blockY = this.turtle.getPosition().field_71572_b + -1;
            int blockZ = this.turtle.getPosition().field_71573_c;
            Block blockFacing = this.turtle.getWorld().func_147439_a(blockX, blockY, blockZ);
            if (blockFacing instanceof IGrowable) {
                return new Object[]{Math.floor((float)this.turtle.getWorld().func_72805_g(blockX, blockY, blockZ) / (blockFacing instanceof BlockCocoa ? 8.0f : 7.0f) * 100.0f)};
            }
        } else {
            if (method == 3) {
                boolean success = false;
                if (this.turtle.getInventory().func_70301_a(this.turtle.getSelectedSlot()) != null && this.turtle.getInventory().func_70301_a(this.turtle.getSelectedSlot()).func_77969_a(new ItemStack(Items.field_151100_aR, 1, 15))) {
                    ItemStack bonemeal = this.turtle.getInventory().func_70301_a(this.turtle.getSelectedSlot());
                    int blockX = this.turtle.getPosition().field_71574_a + Facing.field_71586_b[this.turtle.getDirection()];
                    int blockY = this.turtle.getPosition().field_71572_b + Facing.field_71587_c[this.turtle.getDirection()];
                    int blockZ = this.turtle.getPosition().field_71573_c + Facing.field_71585_d[this.turtle.getDirection()];
                    Block blockFacing = this.turtle.getWorld().func_147439_a(blockX, blockY, blockZ);
                    if (blockFacing instanceof IGrowable) {
                        success = ItemDye.applyBonemeal((ItemStack)bonemeal, (World)this.turtle.getWorld(), (int)blockX, (int)blockY, (int)blockZ, null);
                        if (!this.turtle.getWorld().field_72995_K) {
                            this.turtle.getWorld().func_72926_e(2005, blockX, blockY, blockZ, 0);
                        }
                    }
                }
                return new Object[]{success};
            }
            if (method == 4) {
                boolean success = false;
                if (this.turtle.getInventory().func_70301_a(this.turtle.getSelectedSlot()) != null && this.turtle.getInventory().func_70301_a(this.turtle.getSelectedSlot()).func_77969_a(new ItemStack(Items.field_151100_aR, 1, 15))) {
                    ItemStack bonemeal = this.turtle.getInventory().func_70301_a(this.turtle.getSelectedSlot());
                    int blockX = this.turtle.getPosition().field_71574_a;
                    int blockY = this.turtle.getPosition().field_71572_b + 1;
                    int blockZ = this.turtle.getPosition().field_71573_c;
                    Block blockFacing = this.turtle.getWorld().func_147439_a(blockX, blockY, blockZ);
                    if (blockFacing instanceof IGrowable) {
                        success = ItemDye.applyBonemeal((ItemStack)bonemeal, (World)this.turtle.getWorld(), (int)blockX, (int)blockY, (int)blockZ, null);
                        if (!this.turtle.getWorld().field_72995_K) {
                            this.turtle.getWorld().func_72926_e(2005, blockX, blockY, blockZ, 0);
                        }
                    }
                }
                return new Object[]{success};
            }
            if (method == 5) {
                boolean success = false;
                if (this.turtle.getInventory().func_70301_a(this.turtle.getSelectedSlot()) != null && this.turtle.getInventory().func_70301_a(this.turtle.getSelectedSlot()).func_77969_a(new ItemStack(Items.field_151100_aR, 1, 15))) {
                    ItemStack bonemeal = this.turtle.getInventory().func_70301_a(this.turtle.getSelectedSlot());
                    int blockX = this.turtle.getPosition().field_71574_a;
                    int blockY = this.turtle.getPosition().field_71572_b - 1;
                    int blockZ = this.turtle.getPosition().field_71573_c;
                    Block blockFacing = this.turtle.getWorld().func_147439_a(blockX, blockY, blockZ);
                    if (blockFacing instanceof IGrowable) {
                        success = ItemDye.applyBonemeal((ItemStack)bonemeal, (World)this.turtle.getWorld(), (int)blockX, (int)blockY, (int)blockZ, null);
                        if (!this.turtle.getWorld().field_72995_K) {
                            this.turtle.getWorld().func_72926_e(2005, blockX, blockY, blockZ, 0);
                        }
                    }
                }
                return new Object[]{success};
            }
        }
        return new Object[0];
    }

    public boolean equals(IPeripheral other) {
        return other == this;
    }
}

