/*
 * Decompiled with CFR 0.152.
 */
package com.austinv11.peripheralsplusplus.turtles.peripherals;

import com.austinv11.peripheralsplusplus.PeripheralsPlusPlus;
import com.austinv11.peripheralsplusplus.reference.Config;
import com.austinv11.peripheralsplusplus.turtles.peripherals.MountedPeripheral;
import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.api.turtle.ITurtleAccess;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeChunkManager;

public class PeripheralChunkLoader
extends MountedPeripheral {
    private ITurtleAccess turtle;
    private ForgeChunkManager.Ticket ticket;
    private boolean attached = false;
    private ChunkCoordIntPair pos;

    public PeripheralChunkLoader(ITurtleAccess turtle) {
        this.turtle = turtle;
        this.pos = new ChunkCoordIntPair(turtle.getPosition().field_71574_a >> 4, turtle.getPosition().field_71573_c >> 4);
    }

    @Override
    public void attach(IComputerAccess computer) {
        super.attach(computer);
        this.attached = true;
    }

    public void update() {
        if (this.attached && !this.turtle.getWorld().field_72995_K && (this.ticket == null || this.posChanged())) {
            this.pos = new ChunkCoordIntPair(this.turtle.getPosition().field_71574_a >> 4, this.turtle.getPosition().field_71573_c >> 4);
            this.updateTicket();
        }
    }

    @Override
    public void detach(IComputerAccess computer) {
        super.detach(computer);
        ForgeChunkManager.releaseTicket((ForgeChunkManager.Ticket)this.ticket);
        this.ticket = null;
    }

    public void updateTicket() {
        ForgeChunkManager.releaseTicket((ForgeChunkManager.Ticket)this.ticket);
        this.ticket = ForgeChunkManager.requestTicket((Object)PeripheralsPlusPlus.instance, (World)this.turtle.getWorld(), (ForgeChunkManager.Type)ForgeChunkManager.Type.NORMAL);
        for (ChunkCoordIntPair coordIntPair : this.getChunksInRadius(Config.chunkLoadingRadius)) {
            ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)this.ticket, (ChunkCoordIntPair)coordIntPair);
        }
    }

    public ArrayList<ChunkCoordIntPair> getChunksInRadius(int radius) {
        ArrayList<ChunkCoordIntPair> chunkList = new ArrayList<ChunkCoordIntPair>();
        for (int chunkX = this.pos.field_77276_a - radius; chunkX <= this.pos.field_77276_a + radius; ++chunkX) {
            for (int chunkZ = this.pos.field_77275_b - radius; chunkZ <= this.pos.field_77275_b + radius; ++chunkZ) {
                chunkList.add(new ChunkCoordIntPair(chunkX, chunkZ));
            }
        }
        return chunkList;
    }

    public boolean posChanged() {
        return !new ChunkCoordIntPair(this.turtle.getPosition().field_71574_a >> 4, this.turtle.getPosition().field_71573_c >> 4).equals((Object)this.pos);
    }

    public String getType() {
        return "chunkLoader";
    }

    public String[] getMethodNames() {
        return new String[0];
    }

    public Object[] callMethod(IComputerAccess computer, ILuaContext context, int method, Object[] arguments) throws LuaException, InterruptedException {
        return new Object[0];
    }

    public boolean equals(IPeripheral other) {
        return this == other;
    }

    public static class LoaderHandler
    implements ForgeChunkManager.LoadingCallback {
        public void ticketsLoaded(List<ForgeChunkManager.Ticket> tickets, World world) {
        }
    }
}

