/*
 * Decompiled with CFR 0.152.
 */
package com.austinv11.peripheralsplusplus.tiles;

import com.austinv11.peripheralsplusplus.PeripheralsPlusPlus;
import com.austinv11.peripheralsplusplus.network.AudioPacket;
import com.austinv11.peripheralsplusplus.network.SynthPacket;
import com.austinv11.peripheralsplusplus.reference.Config;
import com.austinv11.peripheralsplusplus.tiles.MountedTileEntity;
import com.austinv11.peripheralsplusplus.utils.ReflectionHelper;
import com.austinv11.peripheralsplusplus.utils.TranslateUtils;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.api.turtle.ITurtleAccess;
import dan200.computercraft.api.turtle.TurtleSide;
import java.util.HashMap;
import net.minecraft.nbt.NBTTagCompound;

public class TileEntitySpeaker
extends MountedTileEntity {
    public static String publicName = "speaker";
    private String name = "tileEntitySpeaker";
    private ITurtleAccess turtle;
    private TurtleSide side = null;
    private int id;
    private static final int TICKER_INTERVAL = 20;
    private int eventTicker = 0;
    private int eventSubticker = 0;
    private HashMap<IComputerAccess, Boolean> computers = new HashMap();
    private String lastMessage;
    private Object[] packetInfo = new Object[4];

    public TileEntitySpeaker() {
        this.packetInfo[0] = null;
    }

    public TileEntitySpeaker(ITurtleAccess turtle, TurtleSide side) {
        this();
        this.turtle = turtle;
        this.side = side;
    }

    public String getName() {
        return this.name;
    }

    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
    }

    public void func_145841_b(NBTTagCompound nbttagcompound) {
        super.func_145841_b(nbttagcompound);
    }

    public void func_145845_h() {
        if (this.turtle != null) {
            this.func_145834_a(this.turtle.getWorld());
            this.field_145851_c = this.turtle.getPosition().field_71574_a;
            this.field_145848_d = this.turtle.getPosition().field_71572_b;
            this.field_145849_e = this.turtle.getPosition().field_71573_c;
        }
        if (this.field_145850_b != null) {
            this.id = this.field_145850_b.field_73011_w.field_76574_g;
        }
        if (this.eventSubticker > 0) {
            --this.eventSubticker;
        }
        if (this.eventSubticker == 0 && this.eventTicker != 0) {
            this.eventTicker = 0;
        }
        if (this.packetInfo[0] != null) {
            PeripheralsPlusPlus.NETWORK.sendToAllAround((IMessage)new AudioPacket((String)this.packetInfo[1], (String)this.packetInfo[2], this.field_145851_c, this.field_145848_d, this.field_145849_e, this.id, this.side), new NetworkRegistry.TargetPoint(this.id, (double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, ((Double)this.packetInfo[3]).doubleValue()));
            this.packetInfo[0] = null;
        }
    }

    public String getType() {
        return publicName;
    }

    public String[] getMethodNames() {
        return new String[]{"speak", "synthesize"};
    }

    public Object[] callMethod(IComputerAccess computer, ILuaContext context, int method, Object[] arguments) throws LuaException, InterruptedException {
        if (!Config.enableSpeaker) {
            throw new LuaException("Speakers have been disabled");
        }
        if (method == 0) {
            if (arguments.length <= 0 || !(arguments[0] instanceof String)) {
                throw new LuaException("Bad argument #1 (expected string)");
            }
            if (arguments.length > 1 && !(arguments[1] instanceof Double)) {
                throw new LuaException("Bad argument #2 (expected number)");
            }
            if (arguments.length > 2 && !(arguments[2] instanceof String)) {
                throw new LuaException("Bad argument #3 (expected string)");
            }
            if (arguments.length > 3 && !(arguments[3] instanceof Boolean)) {
                throw new LuaException("Bad argument #4 (expected boolean");
            }
            String lang = null;
            if (arguments.length > 2) {
                if (TranslateUtils.isPrefix((String)arguments[2])) {
                    lang = (String)arguments[2];
                } else {
                    try {
                        lang = ReflectionHelper.getLangFromWord((String)arguments[2]);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    if (lang == null || lang.length() < 2) {
                        throw new LuaException("Language " + (String)arguments[2] + " is unknown");
                    }
                }
            } else {
                lang = "en";
            }
            double range = Config.speechRange < 0.0 ? Double.MAX_VALUE : Config.speechRange;
            if (arguments.length > 1) {
                range = (Double)arguments[1];
            }
            this.packetInfo[0] = "something";
            this.packetInfo[1] = lang;
            this.packetInfo[2] = arguments[0];
            this.packetInfo[3] = range;
            this.lastMessage = (String)arguments[0];
            if (arguments.length > 3 && ((Boolean)arguments[3]).booleanValue()) {
                context.pullEvent("speechComplete");
            }
            return new Object[]{this.lastMessage, lang};
        }
        if (method == 1) {
            if (arguments.length <= 0 || !(arguments[0] instanceof String)) {
                throw new LuaException("Bad argument #1 (expected string)");
            }
            if (arguments.length > 1 && !(arguments[1] instanceof Double)) {
                throw new LuaException("Bad argument #2 (expected number)");
            }
            if (arguments.length > 2 && !(arguments[2] instanceof String)) {
                throw new LuaException("Bad argument #3 (expected string)");
            }
            if (arguments.length > 3 && !(arguments[3] instanceof Double)) {
                throw new LuaException("Bad argument #4 (expected number)");
            }
            if (arguments.length > 4 && !(arguments[4] instanceof Double)) {
                throw new LuaException("Bad argument #5 (expected number)");
            }
            if (arguments.length > 5 && !(arguments[5] instanceof Double)) {
                throw new LuaException("Bad argument #6 (expected number)");
            }
            if (arguments.length > 6 && !(arguments[6] instanceof Double)) {
                throw new LuaException("Bad argument #7 (expected number)");
            }
            if (arguments.length > 7 && !(arguments[7] instanceof Double)) {
                throw new LuaException("Bad argument #8 (expected number)");
            }
            if (arguments.length > 8 && !(arguments[8] instanceof Boolean)) {
                throw new LuaException("Bad argument #9 (expected boolean");
            }
            String text = (String)arguments[0];
            double range = Config.speechRange < 0.0 ? Double.MAX_VALUE : Config.speechRange;
            if (arguments.length > 1) {
                range = (Double)arguments[1];
            }
            String voice = arguments.length > 2 ? (String)arguments[2] : "kevin16";
            Float pitch = arguments.length > 3 ? Float.valueOf(((Double)arguments[3]).floatValue()) : null;
            Float pitchRange = arguments.length > 4 ? Float.valueOf(((Double)arguments[4]).floatValue()) : null;
            Float pitchShift = arguments.length > 5 ? Float.valueOf(((Double)arguments[5]).floatValue()) : null;
            Float rate = arguments.length > 6 ? Float.valueOf(((Double)arguments[6]).floatValue()) : null;
            Float volume = arguments.length > 7 ? Float.valueOf(((Double)arguments[7]).floatValue()) : null;
            PeripheralsPlusPlus.NETWORK.sendToAllAround((IMessage)new SynthPacket(text, voice, pitch, pitchRange, pitchShift, rate, volume, this.field_145851_c, this.field_145848_d, this.field_145849_e, this.id, this.side), new NetworkRegistry.TargetPoint(this.id, (double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, range));
            if (arguments.length > 8 && ((Boolean)arguments[8]).booleanValue()) {
                context.pullEvent("synthComplete");
            }
            return new Object[]{text};
        }
        return new Object[0];
    }

    @Override
    public void attach(IComputerAccess computer) {
        this.computers.put(computer, true);
        super.attach(computer);
    }

    @Override
    public void detach(IComputerAccess computer) {
        this.computers.remove(computer);
        super.detach(computer);
    }

    public boolean equals(IPeripheral other) {
        return this == other;
    }

    public void onSpeechCompletion(String text, String lang) {
        for (IComputerAccess computer : this.computers.keySet()) {
            if (this.eventTicker != 0 && (this.lastMessage == null || this.lastMessage.equals(text))) continue;
            if (lang != null) {
                computer.queueEvent("speechComplete", new Object[]{text, lang});
            } else {
                computer.queueEvent("synthComplete", new Object[]{text});
            }
            this.eventSubticker = 20;
            ++this.eventTicker;
        }
    }
}

