/*
 * Decompiled with CFR 0.152.
 */
package com.austinv11.peripheralsplusplus.tiles;

import com.austinv11.collectiveframework.minecraft.utils.Colors;
import com.austinv11.collectiveframework.minecraft.utils.NBTHelper;
import com.austinv11.peripheralsplusplus.init.ModBlocks;
import com.austinv11.peripheralsplusplus.lua.LuaObjectPeripheralWrap;
import com.austinv11.peripheralsplusplus.reference.Config;
import com.austinv11.peripheralsplusplus.tiles.MountedNetworkedTileEntity;
import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;

public class TileEntityPeripheralContainer
extends MountedNetworkedTileEntity {
    private List<Block> blocksContained = new ArrayList<Block>();
    private List<IPeripheral> peripheralsContained = new ArrayList<IPeripheral>();
    public static String publicName = "peripheralContainer";
    private String name = "tileEntityPeripheralContainer";
    private boolean needsUpdate = false;

    public String getName() {
        return this.name;
    }

    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        int[] ids = nbttagcompound.func_74759_k("ids");
        for (int id : ids) {
            this.addPeripheral(Block.func_149729_e((int)id));
        }
        Object object = this.peripheralsContained.iterator();
        while (object.hasNext()) {
            IPeripheral p = (IPeripheral)object.next();
            NBTTagCompound tag = nbttagcompound.func_74775_l(p.getType());
            ((TileEntity)p).func_145839_a(tag);
        }
    }

    public void func_145841_b(NBTTagCompound nbttagcompound) {
        super.func_145841_b(nbttagcompound);
        int[] ids = new int[this.blocksContained.size()];
        for (int i = 0; i < ids.length; ++i) {
            ids[i] = Block.func_149682_b((Block)this.blocksContained.get(i));
        }
        nbttagcompound.func_74783_a("ids", ids);
        for (IPeripheral p : this.peripheralsContained) {
            NBTTagCompound tag = new NBTTagCompound();
            ((TileEntity)p).func_145841_b(tag);
            nbttagcompound.func_74782_a(p.getType(), (NBTBase)tag);
        }
    }

    public String getType() {
        return publicName;
    }

    public String[] getMethodNames() {
        return new String[]{"getContainedPeripherals", "wrapPeripheral"};
    }

    public Object[] callMethod(IComputerAccess computer, ILuaContext context, int method, Object[] arguments) throws LuaException, InterruptedException {
        if (!Config.enablePeripheralContainer) {
            throw new LuaException("Peripheral Containers have been disabled");
        }
        if (method == 0) {
            HashMap<Integer, String> returnVals = new HashMap<Integer, String>();
            for (int i = 0; i < this.peripheralsContained.size(); ++i) {
                returnVals.put(i + 1, this.peripheralsContained.get(i).getType());
            }
            return new Object[]{returnVals};
        }
        if (method == 1) {
            if (arguments.length < 1) {
                throw new LuaException("Too few arguments");
            }
            if (!(arguments[0] instanceof String)) {
                throw new LuaException("Bad argument #1 (expected string)");
            }
            return new Object[]{new LuaObjectPeripheralWrap(this.getPeripheralByName((String)arguments[0]), computer)};
        }
        return new Object[0];
    }

    public boolean equals(IPeripheral other) {
        return this == other;
    }

    public void func_145845_h() {
        for (IPeripheral te : this.peripheralsContained) {
            ((TileEntity)te).func_145845_h();
            if (!this.needsUpdate) continue;
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            ((TileEntity)te).func_145834_a(this.field_145850_b);
            ((TileEntity)te).field_145851_c = this.field_145851_c;
            ((TileEntity)te).field_145848_d = this.field_145848_d;
            ((TileEntity)te).field_145849_e = this.field_145849_e;
        }
    }

    public void addPeripheral(Block peripheral) {
        this.blocksContained.add(peripheral);
        TileEntity peripheral_ = peripheral.createTileEntity(this.field_145850_b, 0);
        this.peripheralsContained.add((IPeripheral)peripheral_);
        this.func_70296_d();
        if (this.field_145850_b != null) {
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            peripheral_.func_145834_a(this.field_145850_b);
            peripheral_.field_145851_c = this.field_145851_c;
            peripheral_.field_145848_d = this.field_145848_d;
            peripheral_.field_145849_e = this.field_145849_e;
        } else {
            this.needsUpdate = true;
        }
    }

    public List<Block> getBlocksContained() {
        return this.blocksContained;
    }

    private IPeripheral getPeripheralByName(String peripheral) {
        for (IPeripheral p_ : this.peripheralsContained) {
            if (!p_.getType().equals(peripheral)) continue;
            return p_;
        }
        return null;
    }

    @Override
    public void attach(IComputerAccess computer) {
        for (IPeripheral p : this.peripheralsContained) {
            p.attach(computer);
        }
        super.attach(computer);
    }

    @Override
    public void detach(IComputerAccess computer) {
        for (IPeripheral p : this.peripheralsContained) {
            p.detach(computer);
        }
        super.detach(computer);
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (!this.field_145850_b.field_72995_K) {
            ItemStack drop = new ItemStack((Block)ModBlocks.peripheralContainer);
            if (this.peripheralsContained.size() > 0) {
                NBTTagCompound tag = new NBTTagCompound();
                this.func_145841_b(tag);
                drop.field_77990_d = tag;
                ArrayList<String> text = new ArrayList<String>();
                text.add(Colors.RESET.toString() + Colors.UNDERLINE + "Contained Peripherals:");
                for (int id : NBTHelper.getIntArray((ItemStack)drop, (String)"ids")) {
                    Block peripheral = Block.func_149729_e((int)id);
                    IPeripheral iPeripheral = (IPeripheral)peripheral.createTileEntity(null, 0);
                    text.add(Colors.RESET + iPeripheral.getType());
                }
                NBTHelper.setInfo((ItemStack)drop, text);
            }
            this.field_145850_b.func_72838_d((Entity)new EntityItem(this.field_145850_b, (double)this.field_145851_c, (double)(this.field_145848_d + 1), (double)this.field_145849_e, drop.func_77946_l()));
        }
    }
}

