/*
 * Decompiled with CFR 0.152.
 */
package com.austinv11.peripheralsplusplus.network;

import com.austinv11.peripheralsplusplus.tiles.TileEntitySpeaker;
import com.austinv11.peripheralsplusplus.utils.ReflectionHelper;
import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import dan200.computercraft.api.turtle.ITurtleAccess;
import dan200.computercraft.api.turtle.TurtleSide;
import io.netty.buffer.ByteBuf;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.World;

public class SynthResponsePacket
implements IMessage {
    public String text;
    public int x;
    public int y;
    public int z;
    public World world;
    public TurtleSide side;

    public SynthResponsePacket() {
    }

    public SynthResponsePacket(String text, int x, int y, int z, World world, TurtleSide side) {
        this.text = text;
        this.x = x;
        this.y = y;
        this.z = z;
        this.world = world;
        this.side = side;
    }

    public void fromBytes(ByteBuf buf) {
        NBTTagCompound tag = ByteBufUtils.readTag((ByteBuf)buf);
        this.text = tag.func_74779_i("text");
        this.x = tag.func_74762_e("x");
        this.y = tag.func_74762_e("y");
        this.z = tag.func_74762_e("z");
        this.world = MinecraftServer.func_71276_C().func_71218_a(tag.func_74762_e("dim"));
        this.side = tag.func_74779_i("side").equals("null") ? null : TurtleSide.valueOf((String)tag.func_74779_i("side"));
    }

    public void toBytes(ByteBuf buf) {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74778_a("text", this.text);
        tag.func_74768_a("x", this.x);
        tag.func_74768_a("y", this.y);
        tag.func_74768_a("z", this.z);
        tag.func_74768_a("dim", this.world.field_73011_w.field_76574_g);
        tag.func_74778_a("side", this.side == null ? "null" : this.side.name());
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)tag);
    }

    public static class SynthResponsePacketHandler
    implements IMessageHandler<SynthResponsePacket, IMessage> {
        public IMessage onMessage(SynthResponsePacket message, MessageContext ctx) {
            if (message.side == null) {
                ((TileEntitySpeaker)message.world.func_147438_o(message.x, message.y, message.z)).onSpeechCompletion(message.text, null);
            } else {
                try {
                    ITurtleAccess turtle = ReflectionHelper.getTurtle(message.world.func_147438_o(message.x, message.y, message.z));
                    ((TileEntitySpeaker)turtle.getPeripheral(message.side)).onSpeechCompletion(message.text, null);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            return null;
        }
    }
}

