/*
 * Decompiled with CFR 0.152.
 */
package com.austinv11.peripheralsplusplus.network;

import com.austinv11.peripheralsplusplus.entities.EntityRidableTurtle;
import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;

public class RidableTurtlePacket
implements IMessage {
    private int entityId;
    private int movementCode;
    private int dimension;

    public RidableTurtlePacket() {
    }

    public RidableTurtlePacket(int entityId, int movementCode, int dimension) {
        this.entityId = entityId;
        this.movementCode = movementCode;
        this.dimension = dimension;
    }

    public void fromBytes(ByteBuf byteBuf) {
        NBTTagCompound tag = ByteBufUtils.readTag((ByteBuf)byteBuf);
        this.entityId = tag.func_74762_e("entityId");
        this.movementCode = tag.func_74762_e("movementCode");
        this.dimension = tag.func_74762_e("dimension");
    }

    public void toBytes(ByteBuf byteBuf) {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74768_a("entityId", this.entityId);
        tag.func_74768_a("movementCode", this.movementCode);
        tag.func_74768_a("dimension", this.dimension);
        ByteBufUtils.writeTag((ByteBuf)byteBuf, (NBTTagCompound)tag);
    }

    public static class RidableTurtlePacketHandler
    implements IMessageHandler<RidableTurtlePacket, IMessage> {
        public IMessage onMessage(RidableTurtlePacket ridableTurtlePacket, MessageContext messageContext) {
            EntityRidableTurtle ridableTurtle = (EntityRidableTurtle)MinecraftServer.func_71276_C().func_71218_a(ridableTurtlePacket.dimension).func_73045_a(ridableTurtlePacket.entityId);
            ridableTurtle.queueAction(ridableTurtlePacket.movementCode);
            return null;
        }
    }

    public static enum MovementCode {
        FORWARD(0),
        TURN_LEFT(1),
        TURN_RIGHT(2),
        ASCEND(3),
        DESCEND(4);

        public int code;

        private MovementCode(int code) {
            this.code = code;
        }
    }
}

