/*
 * Decompiled with CFR 0.152.
 */
package com.austinv11.peripheralsplusplus.network;

import com.austinv11.peripheralsplusplus.tiles.TileEntityAntenna;
import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import dan200.computercraft.api.peripheral.IComputerAccess;
import io.netty.buffer.ByteBuf;
import java.util.UUID;
import net.minecraft.nbt.NBTTagCompound;

public class InputEventPacket
implements IMessage {
    public UUID uuid;
    public int key;
    public String event;
    public String player;
    public boolean state;

    public InputEventPacket() {
    }

    public InputEventPacket(UUID uuid, int key, boolean state, String event, String player) {
        this.uuid = uuid;
        this.key = key;
        this.state = state;
        this.event = event;
        this.player = player;
    }

    public void fromBytes(ByteBuf buf) {
        NBTTagCompound tag = ByteBufUtils.readTag((ByteBuf)buf);
        this.uuid = UUID.fromString(tag.func_74779_i("uuid"));
        this.key = tag.func_74762_e("key");
        this.event = tag.func_74779_i("event");
        this.player = tag.func_74779_i("player");
        this.state = tag.func_74767_n("text");
    }

    public void toBytes(ByteBuf buf) {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74778_a("uuid", this.uuid.toString());
        tag.func_74768_a("key", this.key);
        tag.func_74778_a("event", this.event);
        tag.func_74778_a("player", this.player);
        tag.func_74757_a("text", this.state);
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)tag);
    }

    public static class InputEventPacketHandler
    implements IMessageHandler<InputEventPacket, IMessage> {
        public IMessage onMessage(InputEventPacket message, MessageContext ctx) {
            TileEntityAntenna antenna = TileEntityAntenna.antenna_registry.get(message.uuid);
            if (antenna != null) {
                for (IComputerAccess computer : antenna.computers.keySet()) {
                    computer.queueEvent(message.event, new Object[]{message.player, message.key, message.state});
                }
            }
            return null;
        }
    }
}

