/*
 * Decompiled with CFR 0.152.
 */
package com.austinv11.peripheralsplusplus.network;

import com.austinv11.collectiveframework.multithreading.SimpleRunnable;
import com.austinv11.peripheralsplusplus.PeripheralsPlusPlus;
import com.austinv11.peripheralsplusplus.network.AudioResponsePacket;
import com.austinv11.peripheralsplusplus.utils.TranslateUtils;
import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import dan200.computercraft.api.turtle.TurtleSide;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public class AudioPacket
implements IMessage {
    public String lang;
    public String text;
    public int x;
    public int y;
    public int z;
    public TurtleSide side;

    public AudioPacket() {
    }

    public AudioPacket(String lang, String text, int x, int y, int z, int world, TurtleSide side) {
        this.lang = lang;
        this.text = text;
        this.x = x;
        this.y = y;
        this.z = z;
        this.side = side;
    }

    public void fromBytes(ByteBuf buf) {
        NBTTagCompound tag = ByteBufUtils.readTag((ByteBuf)buf);
        this.lang = tag.func_74779_i("lang");
        this.text = tag.func_74779_i("text");
        this.x = tag.func_74762_e("x");
        this.y = tag.func_74762_e("y");
        this.z = tag.func_74762_e("z");
        this.side = tag.func_74779_i("side").equals("null") ? null : TurtleSide.valueOf((String)tag.func_74779_i("side"));
    }

    public void toBytes(ByteBuf buf) {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74778_a("lang", this.lang);
        tag.func_74778_a("text", this.text);
        tag.func_74768_a("x", this.x);
        tag.func_74768_a("y", this.y);
        tag.func_74768_a("z", this.z);
        tag.func_74778_a("side", this.side == null ? "null" : this.side.name());
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)tag);
    }

    public static class AudioPacketHandler
    implements IMessageHandler<AudioPacket, IMessage> {
        public IMessage onMessage(AudioPacket message, MessageContext ctx) {
            new AudioThread(message).start();
            return null;
        }

        private class AudioThread
        extends SimpleRunnable {
            private AudioPacket message;

            public AudioThread(AudioPacket message) {
                this.message = message;
            }

            public void run() {
                try {
                    if (this.message.text.replace(" ", "%20").length() < 100) {
                        TranslateUtils.playAudio(this.message.text, this.message.lang);
                    } else {
                        this.playSplitAudio();
                    }
                    PeripheralsPlusPlus.NETWORK.sendToServer((IMessage)new AudioResponsePacket(this.message.text, this.message.lang, this.message.x, this.message.y, this.message.z, (World)Minecraft.func_71410_x().field_71441_e, this.message.side));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                finally {
                    this.disable(true);
                }
            }

            public String getName() {
                return "Peripherals++ Audio Thread";
            }

            private void playSplitAudio() {
                String[] splitString = this.message.text.split(" ");
                ArrayList<String> words = new ArrayList<String>();
                String combinedString = "";
                for (int i = 0; i < splitString.length; ++i) {
                    String tempString = combinedString + "%20" + splitString[i];
                    if (tempString.length() >= 100) {
                        words.add(combinedString);
                        combinedString = splitString[i];
                        continue;
                    }
                    if (i == splitString.length - 1) {
                        words.add(tempString);
                        continue;
                    }
                    combinedString = tempString;
                }
                for (String query : words) {
                    try {
                        TranslateUtils.playAudio(query, this.message.lang);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }
}

