/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.power;

import com.enderio.core.api.client.gui.IAdvancedTooltipProvider;
import com.enderio.core.client.handlers.SpecialTooltipHandler;
import com.enderio.core.common.TileEntityEnder;
import com.enderio.core.common.util.BlockCoord;
import com.enderio.core.common.util.ChatUtil;
import com.enderio.core.common.util.Util;
import com.enderio.core.common.vecmath.Vector3d;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import crazypants.enderio.BlockEio;
import crazypants.enderio.EnderIO;
import crazypants.enderio.ModObject;
import crazypants.enderio.machine.IoMode;
import crazypants.enderio.machine.power.BlockItemCapacitorBank;
import crazypants.enderio.machine.power.ContainerCapacitorBank;
import crazypants.enderio.machine.power.GuiCapacitorBank;
import crazypants.enderio.machine.power.PacketClientState;
import crazypants.enderio.machine.power.PacketPowerStorage;
import crazypants.enderio.machine.power.PowerDisplayUtil;
import crazypants.enderio.machine.power.TileCapacitorBank;
import crazypants.enderio.network.PacketHandler;
import crazypants.enderio.power.PowerHandlerUtil;
import crazypants.enderio.tool.ToolUtil;
import crazypants.enderio.waila.IWailaInfoProvider;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockCapacitorBank
extends BlockEio
implements IGuiHandler,
IAdvancedTooltipProvider,
IWailaInfoProvider {
    public static int renderId = -1;
    IIcon overlayIcon;
    IIcon fillBarIcon;
    private IIcon blockIconInput;
    private IIcon blockIconOutput;
    private IIcon blockIconLocked;

    public static BlockCapacitorBank create() {
        PacketHandler.INSTANCE.registerMessage(PacketClientState.class, PacketClientState.class, PacketHandler.nextID(), Side.SERVER);
        PacketHandler.INSTANCE.registerMessage(PacketPowerStorage.class, PacketPowerStorage.class, PacketHandler.nextID(), Side.CLIENT);
        BlockCapacitorBank res = new BlockCapacitorBank();
        res.init();
        return res;
    }

    protected BlockCapacitorBank() {
        super(ModObject.blockCapacitorBank.unlocalisedName, TileCapacitorBank.class);
        this.func_149711_c(2.0f);
        this.func_149647_a(null);
    }

    protected void init() {
        GameRegistry.registerBlock((Block)this, BlockItemCapacitorBank.class, (String)this.name);
        if (this.teClass != null) {
            GameRegistry.registerTileEntity((Class)this.teClass, (String)(this.name + "TileEntity"));
        }
        EnderIO.guiHandler.registerGuiHandler(5, this);
        this.func_149713_g(255);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item p_149666_1_, CreativeTabs p_149666_2_, List list) {
    }

    public int func_149692_a(int par1) {
        return par1;
    }

    @SideOnly(value=Side.CLIENT)
    public void addCommonEntries(ItemStack itemstack, EntityPlayer entityplayer, List list, boolean flag) {
    }

    @SideOnly(value=Side.CLIENT)
    public void addBasicEntries(ItemStack itemstack, EntityPlayer entityplayer, List list, boolean flag) {
        list.add(PowerDisplayUtil.formatStoredPower(PowerHandlerUtil.getStoredEnergyForItem(itemstack), TileCapacitorBank.BASE_CAP.getMaxEnergyStored()));
    }

    @SideOnly(value=Side.CLIENT)
    public void addDetailedEntries(ItemStack itemstack, EntityPlayer entityplayer, List list, boolean flag) {
        SpecialTooltipHandler.addDetailedTooltipFromResources((List)list, (ItemStack)itemstack);
    }

    @Override
    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer entityPlayer, int side, float par7, float par8, float par9) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (!(te instanceof TileCapacitorBank)) {
            return false;
        }
        if (ToolUtil.isToolEquipped(entityPlayer)) {
            ForgeDirection faceHit = ForgeDirection.getOrientation((int)side);
            TileCapacitorBank tcb = (TileCapacitorBank)te;
            tcb.toggleIoModeForFace(faceHit);
            if (world.field_72995_K) {
                world.func_147471_g(x, y, z);
            } else {
                world.func_147459_d(x, y, z, (Block)EnderIO.blockCapacitorBank);
                world.func_147471_g(x, y, z);
            }
            return true;
        }
        return super.func_149727_a(world, x, y, z, entityPlayer, side, par7, par8, par9);
    }

    protected boolean openGui(World world, int x, int y, int z, EntityPlayer entityPlayer, int side) {
        if (!world.field_72995_K) {
            entityPlayer.openGui((Object)EnderIO.instance, 5, world, x, y, z);
        }
        return true;
    }

    public Object getServerGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (te instanceof TileCapacitorBank) {
            return new ContainerCapacitorBank((Entity)player, player.field_71071_by, ((TileCapacitorBank)te).getController());
        }
        return null;
    }

    public Object getClientGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (te instanceof TileCapacitorBank) {
            return new GuiCapacitorBank((Entity)player, player.field_71071_by, ((TileCapacitorBank)te).getController());
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister IIconRegister2) {
        this.field_149761_L = IIconRegister2.func_94245_a("enderio:capacitorBank");
        this.blockIconInput = IIconRegister2.func_94245_a("enderio:capacitorBankInput");
        this.blockIconOutput = IIconRegister2.func_94245_a("enderio:capacitorBankOutput");
        this.blockIconLocked = IIconRegister2.func_94245_a("enderio:capacitorBankLocked");
        this.overlayIcon = IIconRegister2.func_94245_a("enderio:capacitorBankOverlays");
        this.fillBarIcon = IIconRegister2.func_94245_a("enderio:capacitorBankFillBar");
    }

    public int func_149645_b() {
        return renderId;
    }

    public boolean isSideSolid(IBlockAccess world, int x, int y, int z, ForgeDirection side) {
        return true;
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_149646_a(IBlockAccess par1IBlockAccess, int par2, int par3, int par4, int par5) {
        Block i1 = par1IBlockAccess.func_147439_a(par2, par3, par4);
        return i1 == this ? false : super.func_149646_a(par1IBlockAccess, par2, par3, par4, par5);
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149673_e(IBlockAccess ba, int x, int y, int z, int side) {
        TileEntity te = ba.func_147438_o(x, y, z);
        if (!(te instanceof TileCapacitorBank)) {
            return this.field_149761_L;
        }
        TileCapacitorBank cb = (TileCapacitorBank)te;
        IoMode mode = cb.getIoMode(ForgeDirection.values()[side]);
        if (mode == null || mode == IoMode.NONE) {
            return this.field_149761_L;
        }
        if (mode == IoMode.PULL) {
            return this.blockIconInput;
        }
        if (mode == IoMode.PUSH) {
            return this.blockIconOutput;
        }
        return this.blockIconLocked;
    }

    public void func_149726_b(World world, int x, int y, int z) {
        if (world.field_72995_K) {
            return;
        }
        TileEntity te = world.func_147438_o(x, y, z);
        if (te instanceof TileCapacitorBank) {
            TileCapacitorBank tr = (TileCapacitorBank)te;
            int meta = world.func_72805_g(x, y, z);
            if (meta == 1) {
                tr.setCreativeMode();
            }
            tr.onBlockAdded();
        }
    }

    public void func_149695_a(World world, int x, int y, int z, Block blockId) {
        if (world.field_72995_K) {
            return;
        }
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile instanceof TileCapacitorBank) {
            TileCapacitorBank te = (TileCapacitorBank)tile;
            te.onNeighborBlockChange(blockId);
        }
    }

    public boolean doNormalDrops(World world, int x, int y, int z) {
        return false;
    }

    protected void processDrop(World world, int x, int y, int z, TileEntityEnder te, ItemStack drop) {
        PowerHandlerUtil.setStoredEnergyForItem(drop, ((TileCapacitorBank)te).doGetEnergyStored());
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase player, ItemStack stack) {
        if (world.field_72995_K) {
            return;
        }
        TileEntity te = world.func_147438_o(x, y, z);
        if (te instanceof TileCapacitorBank) {
            TileCapacitorBank cb = (TileCapacitorBank)te;
            cb.addEnergy(PowerHandlerUtil.getStoredEnergyForItem(stack));
            if (player instanceof EntityPlayerMP) {
                for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
                    BlockCoord bc = new BlockCoord(x, y, z);
                    bc = bc.getLocation(dir);
                    te = world.func_147438_o(bc.x, bc.y, bc.z);
                    if (!(te instanceof TileCapacitorBank) || !((TileCapacitorBank)te).isMaxSize()) continue;
                    ChatUtil.sendNoSpam((EntityPlayerMP)((EntityPlayerMP)player), (String[])new String[]{"Capacitor bank is at maximum size"});
                }
            }
        }
        world.func_147471_g(x, y, z);
    }

    public int func_149745_a(Random r) {
        return 0;
    }

    public void func_149749_a(World world, int x, int y, int z, Block par5, int par6) {
        if (!world.field_72995_K && world.func_82736_K().func_82766_b("doTileDrops")) {
            TileEntity te = world.func_147438_o(x, y, z);
            if (!(te instanceof TileCapacitorBank)) {
                super.func_149749_a(world, x, y, z, par5, par6);
                return;
            }
            TileCapacitorBank cb = (TileCapacitorBank)te;
            Util.dropItems((World)world, (IInventory)cb, (int)x, (int)y, (int)z, (boolean)true);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB func_149633_g(World world, int x, int y, int z) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (!(te instanceof TileCapacitorBank)) {
            return super.func_149633_g(world, x, y, z);
        }
        TileCapacitorBank tr = (TileCapacitorBank)te;
        if (!tr.isMultiblock()) {
            return super.func_149633_g(world, x, y, z);
        }
        Vector3d min = new Vector3d(Double.MAX_VALUE, Double.MAX_VALUE, Double.MAX_VALUE);
        Vector3d max = new Vector3d(-1.7976931348623157E308, -1.7976931348623157E308, -1.7976931348623157E308);
        for (BlockCoord bc : tr.multiblock) {
            min.x = Math.min(min.x, (double)bc.x);
            max.x = Math.max(max.x, (double)(bc.x + 1));
            min.y = Math.min(min.y, (double)bc.y);
            max.y = Math.max(max.y, (double)(bc.y + 1));
            min.z = Math.min(min.z, (double)bc.z);
            max.z = Math.max(max.z, (double)(bc.z + 1));
        }
        return AxisAlignedBB.func_72330_a((double)min.x, (double)min.y, (double)min.z, (double)max.x, (double)max.y, (double)max.z);
    }

    public boolean func_149740_M() {
        return true;
    }

    public int func_149736_g(World w, int x, int y, int z, int side) {
        TileEntity te = w.func_147438_o(x, y, z);
        if (te instanceof TileCapacitorBank) {
            return ((TileCapacitorBank)te).getComparatorOutput();
        }
        return 0;
    }

    @Override
    public void getWailaInfo(List<String> tooltip, EntityPlayer player, World world, int x, int y, int z) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (te instanceof TileCapacitorBank) {
            TileCapacitorBank cap = (TileCapacitorBank)te;
            String format = Util.TAB + Util.ALIGNRIGHT + EnumChatFormatting.WHITE;
            tooltip.add(String.format("%s : %s%s%sRF/t ", EnderIO.lang.localize("capbank.maxIO"), format, PowerDisplayUtil.formatPower(cap.getMaxIO()), Util.TAB + Util.ALIGNRIGHT));
            tooltip.add(String.format("%s : %s%s%sRF/t ", EnderIO.lang.localize("capbank.maxIn"), format, PowerDisplayUtil.formatPower(cap.getMaxInput()), Util.TAB + Util.ALIGNRIGHT));
            tooltip.add(String.format("%s : %s%s%sRF/t ", EnderIO.lang.localize("capbank.maxOut"), format, PowerDisplayUtil.formatPower(cap.getMaxOutput()), Util.TAB + Util.ALIGNRIGHT));
            tooltip.add("Deprecated. Convert by placing in crafting grid");
        }
    }

    @Override
    public int getDefaultDisplayMask(World world, int x, int y, int z) {
        return 4;
    }
}

