/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.invpanel;

import com.enderio.core.common.util.ItemUtil;
import crazypants.enderio.machine.invpanel.TileInventoryPanel;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class StoredCraftingRecipe {
    private final ItemStack[] slots = new ItemStack[9];
    private boolean updateResult;
    private ItemStack result;

    public boolean loadFromCraftingGrid(List<Slot> craftingGrid) {
        if (craftingGrid.size() != 9) {
            return false;
        }
        int count = 0;
        for (int slotIdx = 0; slotIdx < 9 && slotIdx < craftingGrid.size(); ++slotIdx) {
            Slot slot = craftingGrid.get(slotIdx);
            ItemStack stack = slot.func_75211_c();
            if (stack == null) continue;
            stack = stack.func_77946_l();
            stack.field_77994_a = 1;
            this.slots[slotIdx] = stack;
            ++count;
        }
        return count > 0;
    }

    public ItemStack get(int index) {
        return this.slots[index];
    }

    public boolean isEqual(List<Slot> craftingGrid) {
        for (int slotIdx = 0; slotIdx < 9; ++slotIdx) {
            ItemStack a = this.slots[slotIdx];
            ItemStack b = craftingGrid.get(slotIdx).func_75211_c();
            if (a == null && b == null || ItemUtil.areStacksEqual((ItemStack)a, (ItemStack)b)) continue;
            return false;
        }
        return true;
    }

    public void writeToNBT(NBTTagCompound nbtRoot) {
        for (int slotIdx = 0; slotIdx < 9; ++slotIdx) {
            ItemStack itemStack = this.slots[slotIdx];
            if (itemStack == null) continue;
            NBTTagCompound itemStackNBT = new NBTTagCompound();
            itemStack.func_77955_b(itemStackNBT);
            nbtRoot.func_74782_a(Integer.toString(slotIdx), (NBTBase)itemStackNBT);
        }
    }

    public boolean readFromNBT(NBTTagCompound nbtRoot) {
        boolean hasSlots = false;
        for (int slotIdx = 0; slotIdx < 9; ++slotIdx) {
            NBTTagCompound itemStackNBT = (NBTTagCompound)nbtRoot.func_74781_a(Integer.toString(slotIdx));
            if (itemStackNBT != null) {
                this.slots[slotIdx] = ItemStack.func_77949_a((NBTTagCompound)itemStackNBT);
                hasSlots = true;
                continue;
            }
            this.slots[slotIdx] = null;
        }
        this.updateResult = true;
        this.result = null;
        return hasSlots;
    }

    public ItemStack getResult(TileInventoryPanel te) {
        if (this.updateResult) {
            this.findCraftingResult(te);
        }
        return this.result;
    }

    private void findCraftingResult(TileInventoryPanel te) {
        InventoryCrafting tmp = new InventoryCrafting(new Container(){

            public boolean func_75145_c(EntityPlayer ep) {
                return false;
            }
        }, 3, 3);
        for (int i = 0; i < 9; ++i) {
            tmp.func_70299_a(i, this.slots[i]);
        }
        this.result = CraftingManager.func_77594_a().func_82787_a(tmp, te.func_145831_w());
        if (this.result != null) {
            this.result = this.result.func_77946_l();
            this.result.field_77994_a = 1;
        }
        this.updateResult = false;
    }
}

