/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.hypercube;

import com.enderio.core.common.util.InventoryWrapper;
import crazypants.enderio.ModObject;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.util.ForgeDirection;

public class CompositeInventory
implements ISidedInventory {
    private final List<InvEntry> inventories = new ArrayList<InvEntry>();
    private int size = 0;

    public void addInventory(CompositeInventory inv) {
        for (InvEntry ie : inv.inventories) {
            this.addInventory((IInventory)ie.inv, ie.side);
        }
    }

    public void addInventory(IInventory inv, ForgeDirection side) {
        if (inv == null) {
            return;
        }
        this.inventories.add(new InvEntry(inv, this.size, side));
        this.updateSize();
    }

    public void removeInventory(IInventory inv) {
        if (inv == null) {
            return;
        }
        InvEntry remove = null;
        for (InvEntry ie : this.inventories) {
            if (ie.inv != inv && ie.origInv != inv) continue;
            remove = ie;
            break;
        }
        if (remove != null) {
            this.inventories.remove(remove);
            this.updateSize();
        }
    }

    private void updateSize() {
        this.size = 0;
        for (InvEntry inv : this.inventories) {
            if (inv == null || inv.inv == null) continue;
            inv.startIndex = this.size;
            inv.endIndex = inv.startIndex + inv.inv.func_70302_i_() - 1;
            this.size += inv.inv.func_70302_i_();
        }
    }

    public int func_70302_i_() {
        return this.size;
    }

    public ItemStack func_70301_a(int i) {
        for (InvEntry inv : this.inventories) {
            if (!inv.containsSlot(i)) continue;
            return inv.inv.func_70301_a(inv.getSlot(i));
        }
        return null;
    }

    public ItemStack func_70298_a(int slot, int j) {
        for (InvEntry inv : this.inventories) {
            if (!inv.containsSlot(slot)) continue;
            return inv.inv.func_70298_a(inv.getSlot(slot), j);
        }
        return null;
    }

    public void func_70299_a(int slot, ItemStack itemStack) {
        for (InvEntry inv : this.inventories) {
            if (!inv.containsSlot(slot)) continue;
            inv.inv.func_70299_a(inv.getSlot(slot), itemStack);
            return;
        }
    }

    public int[] func_94128_d(int var1) {
        ArrayList<Integer> resList = new ArrayList<Integer>();
        for (InvEntry inv : this.inventories) {
            int[] slots = inv.inv.func_94128_d(inv.side.ordinal());
            if (slots == null) continue;
            for (int i = 0; i < slots.length; ++i) {
                resList.add(slots[i]);
            }
        }
        int[] result = new int[resList.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = (Integer)resList.get(i);
        }
        return result;
    }

    public boolean func_102007_a(int slot, ItemStack item, int side) {
        for (InvEntry inv : this.inventories) {
            if (inv == null || !inv.containsSlot(slot)) continue;
            return inv.inv.func_102007_a(inv.getSlot(slot), item, side);
        }
        return false;
    }

    public boolean func_102008_b(int slot, ItemStack item, int side) {
        for (InvEntry inv : this.inventories) {
            if (inv == null || !inv.containsSlot(slot)) continue;
            return inv.inv.func_102008_b(inv.getSlot(slot), item, side);
        }
        return false;
    }

    public boolean func_94041_b(int slot, ItemStack item) {
        for (InvEntry inv : this.inventories) {
            if (inv == null || !inv.containsSlot(slot)) continue;
            return inv.inv.func_94041_b(inv.getSlot(slot), item);
        }
        return false;
    }

    public void func_70296_d() {
        for (InvEntry inv : this.inventories) {
            if (inv == null) continue;
            inv.inv.func_70296_d();
        }
    }

    public String func_145825_b() {
        return ModObject.blockHyperCube.unlocalisedName;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer entityplayer) {
        return false;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public ItemStack func_70304_b(int i) {
        return null;
    }

    public boolean func_145818_k_() {
        return false;
    }

    private static class InvEntry {
        IInventory origInv;
        ISidedInventory inv;
        int startIndex;
        int endIndex;
        ForgeDirection side;

        InvEntry(IInventory inventory, int startIndex, ForgeDirection side) {
            this.origInv = inventory;
            this.inv = InventoryWrapper.asSidedInventory((IInventory)inventory);
            this.endIndex = startIndex + this.inv.func_70302_i_() - 1;
            this.side = side;
        }

        boolean containsSlot(int index) {
            return index >= this.startIndex && index <= this.endIndex;
        }

        int getSlot(int index) {
            return index - this.startIndex;
        }
    }
}

