/*
 * Decompiled with CFR 0.152.
 */
package openccsensors.common.util;

import java.util.HashMap;
import mods.railcraft.api.carts.IEnergyTransfer;
import mods.railcraft.api.carts.IExplosiveCart;
import net.minecraft.entity.item.EntityMinecart;

public class RailcraftUtils {
    public static HashMap getEnergyDetails(EntityMinecart minecart) {
        HashMap<String, Number> response = new HashMap<String, Number>();
        if (minecart instanceof IEnergyTransfer) {
            IEnergyTransfer energyCart = (IEnergyTransfer)minecart;
            int capacity = energyCart.getCapacity();
            double stored = energyCart.getEnergy();
            response.put("Stored", stored);
            response.put("Capacity", capacity);
            response.put("Output", energyCart.getTransferLimit());
            response.put("StoredPercentage", 0);
            if (capacity > 0) {
                response.put("StoredPercentage", Math.max(Math.min(100.0, 100.0 / (double)capacity * stored), 0.0));
            }
        }
        return response;
    }

    public static HashMap getExplosiveDetails(EntityMinecart minecart) {
        HashMap<String, Comparable<Boolean>> response = new HashMap<String, Comparable<Boolean>>();
        if (minecart instanceof IExplosiveCart) {
            IExplosiveCart explosiveCart = (IExplosiveCart)minecart;
            response.put("IsPrimed", Boolean.valueOf(explosiveCart.isPrimed()));
            if (explosiveCart.isPrimed()) {
                response.put("FuseLength", Integer.valueOf(explosiveCart.getFuse()));
                response.put("BlastRadius", Float.valueOf(explosiveCart.getBlastRadius()));
            }
        }
        return response;
    }
}

