/*
 * Decompiled with CFR 0.152.
 */
package openccsensors.common.util;

import java.util.HashMap;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemEnchantedBook;
import net.minecraft.item.ItemMap;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraft.world.storage.MapData;

public class InventoryUtils {
    public static final String FACTORIZATION_BARREL_CLASS = "factorization.common.TileEntityBarrel";
    public static int[] mapColors = new int[]{32768, 32, 16, 256, 16384, 2048, 128, 8192, 1, 512, 4096, 128, 2048, 4096};

    public static HashMap itemstackToMap(ItemStack itemstack) {
        if (itemstack == null) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Name", InventoryUtils.getNameForItemStack(itemstack));
        map.put("RawName", InventoryUtils.getRawNameForStack(itemstack));
        map.put("Size", itemstack.field_77994_a);
        map.put("DamageValue", itemstack.func_77960_j());
        map.put("MaxStack", itemstack.func_77976_d());
        Item item = itemstack.func_77973_b();
        if (item != null && item instanceof ItemEnchantedBook) {
            map.put("Enchantments", InventoryUtils.getBookEnchantments(itemstack));
        }
        return map;
    }

    protected static HashMap getBookEnchantments(ItemStack stack) {
        HashMap<Integer, String> response = new HashMap<Integer, String>();
        ItemEnchantedBook book = (ItemEnchantedBook)stack.func_77973_b();
        NBTTagList nbttaglist = book.func_92110_g(stack);
        int offset = 1;
        if (nbttaglist != null) {
            for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
                short short1 = nbttaglist.func_150305_b(i).func_74765_d("id");
                short short2 = nbttaglist.func_150305_b(i).func_74765_d("lvl");
                if (Enchantment.field_77331_b[short1] == null) continue;
                response.put(offset, Enchantment.field_77331_b[short1].func_77316_c((int)short2));
                ++offset;
            }
        }
        return response;
    }

    public static HashMap invToMap(IInventory inventory) {
        HashMap<Integer, HashMap> map = new HashMap<Integer, HashMap>();
        if (inventory.getClass().getName() == FACTORIZATION_BARREL_CLASS) {
            HashMap details = InventoryUtils.itemstackToMap(inventory.func_70301_a(0));
            try {
                TileEntity barrel = (TileEntity)inventory;
                NBTTagCompound compound = new NBTTagCompound();
                barrel.func_145841_b(compound);
                details.put("Size", compound.func_74762_e("item_count"));
                details.put("MaxStack", compound.func_74762_e("upgrade") == 1 ? 65536 : 4096);
            }
            catch (Exception exception) {
                // empty catch block
            }
            map.put(1, details);
        } else {
            for (int i = 0; i < inventory.func_70302_i_(); ++i) {
                map.put(i + 1, InventoryUtils.itemstackToMap(inventory.func_70301_a(i)));
            }
        }
        return map;
    }

    public static HashMap getInventorySizeCalculations(IInventory inventory) {
        int totalSpace = 0;
        int itemCount = 0;
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            ItemStack stack = inventory.func_70301_a(i);
            if (stack == null) {
                totalSpace += 64;
                continue;
            }
            totalSpace += stack.func_77976_d();
            itemCount += stack.field_77994_a;
        }
        HashMap<String, Number> response = new HashMap<String, Number>();
        response.put("TotalSpace", totalSpace);
        response.put("ItemCount", itemCount);
        if (totalSpace > 0) {
            double percent = 100.0 / (double)totalSpace * (double)itemCount;
            percent = Math.max(Math.min(percent, 100.0), 0.0);
            response.put("InventoryPercentFull", percent);
        }
        return response;
    }

    public static String getNameForItemStack(ItemStack is) {
        String name = "Unknown";
        try {
            name = is.func_82833_r();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return name;
    }

    public static String getRawNameForStack(ItemStack is) {
        String rawName = "unknown";
        try {
            rawName = is.func_82833_r().toLowerCase();
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            String packageName;
            String[] packageLevels;
            if (rawName.length() - rawName.replaceAll("\\.", "").length() == 0 && !rawName.startsWith((packageLevels = (packageName = is.func_77973_b().getClass().getName().toLowerCase()).split("\\."))[0]) && packageLevels.length > 1) {
                rawName = packageLevels[0] + "." + rawName;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return rawName.trim();
    }

    public static ItemStack getStackInSlot(World world, HashMap targets, String targetName, int slot) {
        IInventory inventory;
        Object target;
        if (targets.containsKey(targetName) && (target = targets.get(targetName)) instanceof IInventory && slot < (inventory = (IInventory)target).func_70302_i_()) {
            return inventory.func_70301_a(slot);
        }
        return null;
    }

    public static HashMap getMapData(World world, HashMap targets, String targetName, int slot) {
        Item item;
        ItemStack stack = InventoryUtils.getStackInSlot(world, targets, targetName, slot);
        if (stack != null && (item = stack.func_77973_b()) != null && item instanceof ItemMap) {
            MapData data = ((ItemMap)item).func_77873_a(stack, world);
            HashMap<String, Object> ret = new HashMap<String, Object>();
            ret.put("MapName", data.field_76190_i);
            ret.put("Scale", Integer.valueOf(data.field_76197_d));
            ret.put("CenterX", data.field_76201_a);
            ret.put("CenterZ", data.field_76199_b);
            HashMap<Integer, Integer> colors = new HashMap<Integer, Integer>();
            for (int b = 0; b < data.field_76198_e.length; ++b) {
                colors.put(b + 1, mapColors[data.field_76198_e[b] / 4]);
            }
            ret.put("Colors", colors);
            return ret;
        }
        return null;
    }
}

