/*
 * Decompiled with CFR 0.152.
 */
package openccsensors.common.util;

import forestry.api.apiculture.IBee;
import forestry.api.apiculture.IBeeGenome;
import forestry.api.arboriculture.ITree;
import forestry.api.arboriculture.ITreeGenome;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IAlleleArea;
import forestry.api.genetics.IAlleleBoolean;
import forestry.api.genetics.IAlleleFloat;
import forestry.api.genetics.IAlleleFlowers;
import forestry.api.genetics.IAlleleInteger;
import forestry.api.genetics.IAlleleTolerance;
import forestry.api.genetics.IChromosome;
import forestry.api.genetics.IIndividual;
import forestry.api.genetics.ISpeciesRoot;
import forestry.api.lepidopterology.IButterfly;
import forestry.api.lepidopterology.IButterflyGenome;
import java.io.Serializable;
import java.util.HashMap;
import net.minecraft.item.ItemStack;

public class ForestryUtils {
    private static ISpeciesRoot beeRoot = AlleleManager.alleleRegistry.getSpeciesRoot("rootBees");
    private static ISpeciesRoot treeRoot = AlleleManager.alleleRegistry.getSpeciesRoot("rootTrees");
    private static ISpeciesRoot butterflyRoot = AlleleManager.alleleRegistry.getSpeciesRoot("rootButterflies");

    public static HashMap genomeToMap(ItemStack item) {
        HashMap response = new HashMap();
        if (beeRoot.isMember(item) && beeRoot.getMember(item).isAnalyzed()) {
            response.putAll(ForestryUtils.beeGenomeToMap(beeRoot.getMember(item)));
        } else if (treeRoot.isMember(item) && treeRoot.getMember(item).isAnalyzed()) {
            response.putAll(ForestryUtils.treeGenomeToMap(treeRoot.getMember(item)));
        } else if (!butterflyRoot.isMember(item) || butterflyRoot.getMember(item).isAnalyzed()) {
            // empty if block
        }
        return response;
    }

    private static Object getAlleleValue(IAllele allele) {
        if (allele instanceof IAlleleBoolean) {
            return ((IAlleleBoolean)allele).getValue();
        }
        if (allele instanceof IAlleleInteger) {
            return ((IAlleleInteger)allele).getValue();
        }
        if (allele instanceof IAlleleFloat) {
            return Float.valueOf(((IAlleleFloat)allele).getValue());
        }
        if (allele instanceof IAlleleTolerance) {
            return ((IAlleleTolerance)allele).getValue();
        }
        if (allele instanceof IAlleleArea) {
            int[] area = ((IAlleleArea)allele).getValue();
            return area[0] + 120 + area[1] + 120 + area[2];
        }
        if (allele instanceof IAlleleFlowers) {
            return ((IAlleleFlowers)allele).getProvider().getDescription();
        }
        return null;
    }

    public static HashMap beeGenomeToMap(IIndividual individual) {
        HashMap<String, Serializable> response = new HashMap<String, Serializable>();
        if (individual instanceof IBee) {
            IBee bee = (IBee)individual;
            IBeeGenome genome = bee.getGenome();
            IChromosome[] chromosomes = genome.getChromosomes();
            HashMap<String, Object> primary = new HashMap<String, Object>();
            HashMap<String, Object> secondary = new HashMap<String, Object>();
            for (IChromosome chromosome : chromosomes) {
                IAllele priAllele = chromosome.getPrimaryAllele();
                IAllele secAllele = chromosome.getSecondaryAllele();
                primary.put(priAllele.getName(), ForestryUtils.getAlleleValue(priAllele));
                secondary.put(secAllele.getName(), ForestryUtils.getAlleleValue(secAllele));
            }
            primary.put("Species", genome.getPrimary().getUID());
            secondary.put("Species", genome.getSecondary().getUID());
            response.put("Primary", primary);
            response.put("Secondary", secondary);
            response.put("Speed", Float.valueOf(genome.getSpeed()));
            response.put("Lifespan", Integer.valueOf(genome.getLifespan()));
            response.put("Fertility", Integer.valueOf(genome.getFertility()));
            response.put("TemperatureTolerance", (Serializable)genome.getToleranceTemp());
            response.put("HumidityTolerance", (Serializable)genome.getToleranceHumid());
            response.put("IsNocturnal", Boolean.valueOf(genome.getNocturnal()));
            response.put("IsTolerantFlyer", Boolean.valueOf(genome.getTolerantFlyer()));
            response.put("IsCaveDweller", Boolean.valueOf(genome.getCaveDwelling()));
        }
        return response;
    }

    public static HashMap treeGenomeToMap(IIndividual individual) {
        HashMap response = new HashMap();
        if (individual instanceof ITree) {
            ITree tree = (ITree)individual;
            ITreeGenome genome = tree.getGenome();
            IChromosome[] chromosomes = genome.getChromosomes();
            HashMap<String, Object> primary = new HashMap<String, Object>();
            HashMap<String, Object> secondary = new HashMap<String, Object>();
            for (IChromosome chromosome : chromosomes) {
                IAllele priAllele = chromosome.getPrimaryAllele();
                IAllele secAllele = chromosome.getSecondaryAllele();
                primary.put(priAllele.getName(), ForestryUtils.getAlleleValue(priAllele));
                secondary.put(secAllele.getName(), ForestryUtils.getAlleleValue(secAllele));
            }
            primary.put("Species", genome.getPrimary().getUID());
            secondary.put("Species", genome.getSecondary().getUID());
            response.put("Primary", primary);
            response.put("Secondary", secondary);
        }
        return response;
    }

    public static HashMap butterflyGenomeToMap(IIndividual individual) {
        HashMap response = new HashMap();
        if (individual instanceof IButterfly) {
            IButterfly butterfly = (IButterfly)individual;
            IButterflyGenome genome = butterfly.getGenome();
            IChromosome[] chromosomes = genome.getChromosomes();
            HashMap<String, Object> primary = new HashMap<String, Object>();
            HashMap<String, Object> secondary = new HashMap<String, Object>();
            for (IChromosome chromosome : chromosomes) {
                IAllele priAllele = chromosome.getPrimaryAllele();
                IAllele secAllele = chromosome.getSecondaryAllele();
                primary.put(priAllele.getName(), ForestryUtils.getAlleleValue(priAllele));
                secondary.put(secAllele.getName(), ForestryUtils.getAlleleValue(secAllele));
            }
            primary.put("Species", genome.getPrimary().getUID());
            secondary.put("Species", genome.getSecondary().getUID());
            response.put("Primary", primary);
            response.put("Secondary", secondary);
        }
        return response;
    }
}

