/*
 * Decompiled with CFR 0.152.
 */
package openccsensors.common.sensor;

import java.util.HashMap;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.World;
import openccsensors.api.ISensorTier;
import openccsensors.common.util.InventoryUtils;

public abstract class TileSensor {
    public boolean isValidTarget(Object target) {
        return false;
    }

    public HashMap getDetails(TileEntity tile, ChunkCoordinates sensorPos) {
        HashMap<String, Object> response = new HashMap<String, Object>();
        HashMap<String, Integer> position = new HashMap<String, Integer>();
        position.put("X", tile.field_145851_c - sensorPos.field_71574_a);
        position.put("Y", tile.field_145848_d - sensorPos.field_71572_b);
        position.put("Z", tile.field_145849_e - sensorPos.field_71573_c);
        response.put("Position", position);
        ItemStack stack = new ItemStack(tile.func_145838_q(), 1, tile.func_145832_p());
        response.put("Name", InventoryUtils.getNameForItemStack(stack));
        response.put("RawName", InventoryUtils.getRawNameForStack(stack));
        response.put("DamageValue", stack.func_77960_j());
        return response;
    }

    public HashMap getTargets(World world, ChunkCoordinates location, ISensorTier tier) {
        HashMap<String, TileEntity> targets = new HashMap<String, TileEntity>();
        int distance = (int)tier.getMultiplier();
        for (int x = -distance; x <= distance; ++x) {
            for (int y = -distance; y <= distance; ++y) {
                for (int z = -distance; z <= distance; ++z) {
                    int tileX = x + location.field_71574_a;
                    int tileY = y + location.field_71572_b;
                    int tileZ = z + location.field_71573_c;
                    String name = String.format("%s,%s,%s", x, y, z);
                    TileEntity tile = world.func_147438_o(tileX, tileY, tileZ);
                    if (!this.isValidTarget(tile)) continue;
                    targets.put(name, tile);
                }
            }
        }
        return targets;
    }
}

