/*
 * Decompiled with CFR 0.152.
 */
package openccsensors.common.sensor;

import java.util.HashMap;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import openccsensors.api.IRequiresIconLoading;
import openccsensors.api.ISensor;
import openccsensors.api.ISensorTier;
import openccsensors.common.util.EntityUtils;
import openccsensors.common.util.InventoryUtils;

public class DroppedItemSensor
implements ISensor,
IRequiresIconLoading {
    private IIcon icon;

    @Override
    public HashMap getDetails(World world, Object obj, ChunkCoordinates sensorLocation, boolean additional) {
        EntityItem item = (EntityItem)obj;
        HashMap<String, Object> response = new HashMap<String, Object>();
        HashMap<String, Double> position = new HashMap<String, Double>();
        position.put("X", item.field_70165_t - (double)sensorLocation.field_71574_a);
        position.put("Y", item.field_70163_u - (double)sensorLocation.field_71572_b);
        position.put("Z", item.field_70161_v - (double)sensorLocation.field_71573_c);
        response.put("Position", position);
        ItemStack stack = item.func_92059_d();
        response.put("Name", InventoryUtils.getNameForItemStack(stack));
        response.put("RawName", InventoryUtils.getRawNameForStack(stack));
        if (additional) {
            response.putAll(InventoryUtils.itemstackToMap(stack));
            response.put("IsBurning", item.func_70027_ad());
        }
        return response;
    }

    @Override
    public HashMap getTargets(World world, ChunkCoordinates location, ISensorTier tier) {
        double radius = tier.getMultiplier() * 4.0;
        return EntityUtils.getEntities(world, location, radius, EntityItem.class);
    }

    @Override
    public String[] getCustomMethods(ISensorTier tier) {
        return null;
    }

    @Override
    public Object callCustomMethod(World world, ChunkCoordinates location, int methodID, Object[] args, ISensorTier tier) {
        return null;
    }

    @Override
    public String getName() {
        return "droppedItemCard";
    }

    @Override
    public IIcon getIcon() {
        return this.icon;
    }

    @Override
    public void loadIcon(IIconRegister iconRegistry) {
        this.icon = iconRegistry.func_94245_a("openccsensors:droppedItem");
    }

    @Override
    public ItemStack getUniqueRecipeItem() {
        return new ItemStack((Item)Item.field_150901_e.func_82594_a("slime_ball"));
    }
}

