/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.common.utills;

import cofh.api.energy.IEnergyContainerItem;
import com.brandon3055.brandonscore.common.utills.ItemNBTHelper;
import com.brandon3055.draconicevolution.common.utills.IConfigurableItem;
import com.brandon3055.draconicevolution.common.utills.LogHelper;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.StatCollector;

public interface IUpgradableItem {
    public List<EnumUpgrade> getUpgrades(ItemStack var1);

    public int getUpgradeCap(ItemStack var1);

    public int getMaxTier(ItemStack var1);

    public int getMaxUpgradePoints(int var1);

    public int getBaseUpgradePoints(int var1);

    public List<String> getUpgradeStats(ItemStack var1);

    public static enum EnumUpgrade {
        RF_CAPACITY(0, 1, "RFCapacity"){

            @Override
            public void onRemovedFromItem(ItemStack itemStack) {
                if (itemStack != null && itemStack.func_77973_b() instanceof IEnergyContainerItem) {
                    IEnergyContainerItem item = (IEnergyContainerItem)itemStack.func_77973_b();
                    for (int i = 0; i < 500 && item.getEnergyStored(itemStack) > item.getMaxEnergyStored(itemStack); ++i) {
                        item.extractEnergy(itemStack, item.getEnergyStored(itemStack) - item.getMaxEnergyStored(itemStack), false);
                    }
                }
            }
        }
        ,
        DIG_SPEED(1, 1, "DigSpeed"),
        DIG_AOE(2, 4, "DigAOE"){

            @Override
            public void onRemovedFromItem(ItemStack itemStack) {
                int profile = ItemNBTHelper.getInteger((ItemStack)itemStack, (String)"ConfigProfile", (int)0);
                for (int i = 0; i < 5; ++i) {
                    ItemNBTHelper.setInteger((ItemStack)itemStack, (String)"ConfigProfile", (int)i);
                    if (IConfigurableItem.ProfileHelper.getInteger(itemStack, "ToolDigAOE", 0) <= this.getUpgradePoints(itemStack)) continue;
                    IConfigurableItem.ProfileHelper.setInteger(itemStack, "ToolDigAOE", this.getUpgradePoints(itemStack));
                }
                ItemNBTHelper.setInteger((ItemStack)itemStack, (String)"ConfigProfile", (int)profile);
            }
        }
        ,
        DIG_DEPTH(3, 2, "DigDepth"){

            @Override
            public void onRemovedFromItem(ItemStack itemStack) {
                int profile = ItemNBTHelper.getInteger((ItemStack)itemStack, (String)"ConfigProfile", (int)0);
                for (int i = 0; i < 5; ++i) {
                    ItemNBTHelper.setInteger((ItemStack)itemStack, (String)"ConfigProfile", (int)i);
                    if (IConfigurableItem.ProfileHelper.getInteger(itemStack, "ToolDigDepth", 0) <= this.getUpgradePoints(itemStack)) continue;
                    IConfigurableItem.ProfileHelper.setInteger(itemStack, "ToolDigDepth", this.getUpgradePoints(itemStack));
                }
                ItemNBTHelper.setInteger((ItemStack)itemStack, (String)"ConfigProfile", (int)profile);
            }
        }
        ,
        ATTACK_DAMAGE(4, 1, "AttackDamage"),
        ATTACK_AOE(5, 2, "AttackAOE"){

            @Override
            public void onRemovedFromItem(ItemStack itemStack) {
                int profile = ItemNBTHelper.getInteger((ItemStack)itemStack, (String)"ConfigProfile", (int)0);
                for (int i = 0; i < 5; ++i) {
                    ItemNBTHelper.setInteger((ItemStack)itemStack, (String)"ConfigProfile", (int)i);
                    if (IConfigurableItem.ProfileHelper.getInteger(itemStack, "WeaponAttackAOE", 0) <= this.getUpgradePoints(itemStack)) continue;
                    IConfigurableItem.ProfileHelper.setInteger(itemStack, "WeaponAttackAOE", this.getUpgradePoints(itemStack));
                }
                ItemNBTHelper.setInteger((ItemStack)itemStack, (String)"ConfigProfile", (int)profile);
            }
        }
        ,
        ARROW_DAMAGE(6, 1, "ArrowDamage"){

            @Override
            public void onRemovedFromItem(ItemStack itemStack) {
                int profile = ItemNBTHelper.getInteger((ItemStack)itemStack, (String)"ConfigProfile", (int)0);
                for (int i = 0; i < 5; ++i) {
                    ItemNBTHelper.setInteger((ItemStack)itemStack, (String)"ConfigProfile", (int)i);
                    if (IConfigurableItem.ProfileHelper.getInteger(itemStack, "BowArrowDamage", 0) <= this.getUpgradePoints(itemStack)) continue;
                    IConfigurableItem.ProfileHelper.setInteger(itemStack, "BowArrowDamage", this.getUpgradePoints(itemStack));
                }
                ItemNBTHelper.setInteger((ItemStack)itemStack, (String)"ConfigProfile", (int)profile);
            }
        }
        ,
        DRAW_SPEED(7, 2, "DrawSpeed"),
        ARROW_SPEED(8, 2, "ArrowSpeed"){

            @Override
            public void onRemovedFromItem(ItemStack itemStack) {
                int profile = ItemNBTHelper.getInteger((ItemStack)itemStack, (String)"ConfigProfile", (int)0);
                for (int i = 0; i < 5; ++i) {
                    ItemNBTHelper.setInteger((ItemStack)itemStack, (String)"ConfigProfile", (int)i);
                    if (IConfigurableItem.ProfileHelper.getInteger(itemStack, "BowArrowSpeedModifier", 0) <= this.getUpgradePoints(itemStack)) continue;
                    IConfigurableItem.ProfileHelper.setInteger(itemStack, "BowArrowSpeedModifier", this.getUpgradePoints(itemStack));
                }
                ItemNBTHelper.setInteger((ItemStack)itemStack, (String)"ConfigProfile", (int)profile);
            }
        }
        ,
        SHIELD_CAPACITY(9, 1, "ShieldCapacity"),
        SHIELD_RECOVERY(10, 1, "ShieldRecovery"),
        MOVE_SPEED(11, 1, "MoveSpeed"),
        JUMP_BOOST(12, 1, "JumpBoost");

        public int index;
        public int pointConversion;
        public String name;
        private final String COMPOUND_NAME = "Upgrades";

        private EnumUpgrade(int index, int pointConversion, String name) {
            this.index = index;
            this.pointConversion = pointConversion;
            this.name = name;
        }

        public int[] getCoresApplied(ItemStack stack) {
            if (stack == null) {
                return new int[]{0, 0, 0, 0};
            }
            NBTTagCompound compound = ItemNBTHelper.getCompound((ItemStack)stack);
            if (!compound.func_74764_b("Upgrades")) {
                return new int[]{0, 0, 0, 0};
            }
            NBTTagCompound upgrades = compound.func_74775_l("Upgrades");
            if (upgrades.func_74764_b(this.name) && upgrades.func_74759_k(this.name).length == 4) {
                return upgrades.func_74759_k(this.name);
            }
            return new int[]{0, 0, 0, 0};
        }

        public void setCoresApplied(ItemStack stack, int[] cores) {
            if (cores.length != 4) {
                LogHelper.error("[EnumUpgrade] Error applying upgrades to stack.");
                return;
            }
            NBTTagCompound compound = ItemNBTHelper.getCompound((ItemStack)stack);
            NBTTagCompound upgrades = compound.func_74764_b("Upgrades") ? compound.func_74775_l("Upgrades") : new NBTTagCompound();
            upgrades.func_74783_a(this.name, cores);
            compound.func_74782_a("Upgrades", (NBTBase)upgrades);
        }

        public String getLocalizedName() {
            return StatCollector.func_74838_a((String)("gui.de." + this.name + ".txt"));
        }

        public static EnumUpgrade getUpgradeByIndex(int index) {
            for (EnumUpgrade upgrade : EnumUpgrade.values()) {
                if (upgrade.index != index) continue;
                return upgrade;
            }
            return null;
        }

        public int getUpgradePoints(ItemStack itemStack) {
            int[] applied = this.getCoresApplied(itemStack);
            int totalPoints = applied[0] + applied[1] * 2 + applied[2] * 4 + applied[3] * 8;
            if (itemStack != null && itemStack.func_77973_b() instanceof IUpgradableItem) {
                int points = ((IUpgradableItem)itemStack.func_77973_b()).getBaseUpgradePoints(this.index) + totalPoints / this.pointConversion;
                return Math.min(points, ((IUpgradableItem)itemStack.func_77973_b()).getMaxUpgradePoints(this.index));
            }
            return 0;
        }

        public void onAppliedToItem(ItemStack itemStack) {
        }

        public void onRemovedFromItem(ItemStack itemStack) {
        }
    }
}

