/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.common.tileentities.multiblocktiles.reactor;

import cofh.api.energy.IEnergyReceiver;
import com.brandon3055.brandonscore.common.utills.Utills;
import com.brandon3055.draconicevolution.DraconicEvolution;
import com.brandon3055.draconicevolution.client.render.particle.ParticleReactorBeam;
import com.brandon3055.draconicevolution.common.blocks.multiblock.IReactorPart;
import com.brandon3055.draconicevolution.common.blocks.multiblock.MultiblockHelper;
import com.brandon3055.draconicevolution.common.tileentities.multiblocktiles.reactor.TileReactorCore;
import com.brandon3055.draconicevolution.integration.computers.IDEPeripheral;
import java.util.HashMap;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class TileReactorEnergyInjector
extends TileEntity
implements IReactorPart,
IEnergyReceiver,
IDEPeripheral {
    public float modelIllumination = 1.0f;
    public int facingDirection = ForgeDirection.UP.ordinal();
    public MultiblockHelper.TileLocation masterLocation = new MultiblockHelper.TileLocation();
    public boolean isValid = false;
    public int tick = 0;
    private ParticleReactorBeam beam = null;
    private TileReactorCore core = null;
    private int redstoneMode = 0;
    private int rs = -1;
    private int rsCach = -1;

    public void func_145845_h() {
        if (this.field_145850_b.field_72995_K && this.isValid) {
            this.beam = DraconicEvolution.proxy.reactorBeam(this, this.beam, true);
        }
        TileEntity master = this.masterLocation.getTileEntity(this.field_145850_b);
        if (!this.field_145850_b.field_72995_K && master instanceof TileReactorCore) {
            this.rs = ((TileReactorCore)master).getComparatorOutput(this.redstoneMode);
            if (this.rs != this.rsCach) {
                this.rsCach = this.rs;
                Utills.updateNeabourBlocks((World)this.field_145850_b, (int)this.field_145851_c, (int)this.field_145848_d, (int)this.field_145849_e);
            }
        }
    }

    public void onPlaced() {
        this.checkForMaster();
    }

    @Override
    public boolean checkForMaster() {
        for (int i = 1; i < 10; ++i) {
            ForgeDirection dir = ForgeDirection.getOrientation((int)this.facingDirection);
            int x = this.field_145851_c + dir.offsetX * i;
            int y = this.field_145848_d + dir.offsetY * i;
            int z = this.field_145849_e + dir.offsetZ * i;
            if (this.field_145850_b.func_147437_c(x, y, z)) continue;
            TileEntity tile = this.field_145850_b.func_147438_o(x, y, z);
            if (tile instanceof TileReactorCore) {
                this.masterLocation.func_71571_b(x, y, z);
                this.isValid = true;
                this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                return true;
            }
            this.isValid = false;
            return false;
        }
        this.isValid = false;
        return false;
    }

    @Override
    public boolean isActive() {
        return this.isValid;
    }

    @Override
    public String getRedstoneModeString() {
        return StatCollector.func_74838_a((String)("msg.de.reactorRSMode." + this.redstoneMode + ".txt"));
    }

    @Override
    public void changeRedstoneMode() {
        this.redstoneMode = this.redstoneMode == 7 ? 0 : ++this.redstoneMode;
    }

    @Override
    public int getRedstoneMode() {
        return this.redstoneMode;
    }

    @Override
    public void shutDown() {
        this.masterLocation = new MultiblockHelper.TileLocation();
        this.isValid = false;
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public Packet func_145844_m() {
        NBTTagCompound compound = new NBTTagCompound();
        this.masterLocation.writeToNBT(compound, "Master");
        compound.func_74768_a("Facing", this.facingDirection);
        compound.func_74757_a("IsValid", this.isValid);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 1, compound);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        NBTTagCompound compound = pkt.func_148857_g();
        this.masterLocation.readFromNBT(compound, "Master");
        this.facingDirection = compound.func_74762_e("Facing");
        this.isValid = compound.func_74767_n("IsValid");
        super.onDataPacket(net, pkt);
    }

    public TileReactorCore getCore() {
        if (this.core == null || this.core.func_145837_r()) {
            this.core = this.getMaster().getTileEntity(this.field_145850_b) instanceof TileReactorCore ? (TileReactorCore)this.getMaster().getTileEntity(this.field_145850_b) : null;
        }
        return this.core;
    }

    public void func_145841_b(NBTTagCompound compound) {
        super.func_145841_b(compound);
        this.masterLocation.writeToNBT(compound, "Master");
        compound.func_74768_a("Facing", this.facingDirection);
        compound.func_74757_a("IsValid", this.isValid);
        compound.func_74768_a("RedstoneMode", this.redstoneMode);
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.masterLocation.readFromNBT(compound, "Master");
        this.facingDirection = compound.func_74762_e("Facing");
        this.isValid = compound.func_74767_n("IsValid");
        this.redstoneMode = compound.func_74762_e("RedstoneMode");
    }

    @Override
    public MultiblockHelper.TileLocation getMaster() {
        return this.masterLocation;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return AxisAlignedBB.func_72330_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, (double)(this.field_145851_c + 1), (double)(this.field_145848_d + 1), (double)(this.field_145849_e + 1));
    }

    public int receiveEnergy(ForgeDirection from, int maxReceive, boolean simulate) {
        if (simulate) {
            return Integer.MAX_VALUE;
        }
        if (this.getCore() != null) {
            return this.getCore().injectEnergy(maxReceive);
        }
        return 0;
    }

    public int getEnergyStored(ForgeDirection from) {
        return 0;
    }

    public int getMaxEnergyStored(ForgeDirection from) {
        return Integer.MAX_VALUE;
    }

    public boolean canConnectEnergy(ForgeDirection from) {
        return from == ForgeDirection.getOrientation((int)this.facingDirection).getOpposite();
    }

    @Override
    public String getName() {
        return "draconic_reactor";
    }

    @Override
    public String[] getMethodNames() {
        return new String[]{"getReactorInfo", "chargeReactor", "activateReactor", "stopReactor"};
    }

    @Override
    public Object[] callMethod(String method, Object ... args) {
        if (!(this.getMaster().getTileEntity(this.field_145850_b) instanceof TileReactorCore)) {
            return null;
        }
        TileReactorCore reactor = (TileReactorCore)this.getMaster().getTileEntity(this.field_145850_b);
        if (args.length > 0) {
            throw new IllegalArgumentException("This method dose not accept arguments");
        }
        if (method.equals("getReactorInfo")) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("temperature", Utills.round((double)reactor.reactionTemperature, (double)100.0));
            map.put("fieldStrength", Utills.round((double)reactor.fieldCharge, (double)100.0));
            map.put("maxFieldStrength", Utills.round((double)reactor.maxFieldCharge, (double)100.0));
            map.put("energySaturation", reactor.energySaturation);
            map.put("maxEnergySaturation", reactor.maxEnergySaturation);
            map.put("fuelConversion", Utills.round((double)((double)reactor.convertedFuel + reactor.conversionUnit), (double)1000.0));
            map.put("maxFuelConversion", reactor.reactorFuel + reactor.convertedFuel);
            map.put("generationRate", (int)reactor.generationRate);
            map.put("fieldDrainRate", reactor.fieldDrain);
            map.put("fuelConversionRate", (int)Math.round(reactor.fuelUseRate * 1000000.0));
            map.put("status", reactor.reactorState == 0 ? "offline" : (reactor.reactorState == 1 && !reactor.canStart() ? "charging" : (reactor.reactorState == 1 && reactor.canStart() ? "charged" : (reactor.reactorState == 2 ? "online" : (reactor.reactorState == 3 ? "stopping" : "invalid")))));
            return new Object[]{map};
        }
        if (method.equals("chargeReactor")) {
            if (reactor.canCharge()) {
                reactor.reactorState = 1;
                return new Object[]{true};
            }
            return new Object[]{false};
        }
        if (method.equals("activateReactor")) {
            if (reactor.canStart()) {
                reactor.reactorState = 2;
                return new Object[]{true};
            }
            return new Object[]{false};
        }
        if (method.equals("stopReactor")) {
            if (reactor.canStop()) {
                reactor.reactorState = 3;
                return new Object[]{true};
            }
            return new Object[]{false};
        }
        return new Object[0];
    }
}

