/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.common.items.weapons;

import cofh.api.energy.IEnergyContainerItem;
import com.brandon3055.brandonscore.BrandonsCore;
import com.brandon3055.brandonscore.common.utills.InfoHelper;
import com.brandon3055.brandonscore.common.utills.ItemNBTHelper;
import com.brandon3055.brandonscore.common.utills.Utills;
import com.brandon3055.draconicevolution.DraconicEvolution;
import com.brandon3055.draconicevolution.common.ModItems;
import com.brandon3055.draconicevolution.common.entity.EntityPersistentItem;
import com.brandon3055.draconicevolution.common.handler.ConfigHandler;
import com.brandon3055.draconicevolution.common.items.tools.baseclasses.ToolBase;
import com.brandon3055.draconicevolution.common.items.weapons.BowHandler;
import com.brandon3055.draconicevolution.common.lib.References;
import com.brandon3055.draconicevolution.common.utills.IHudDisplayItem;
import com.brandon3055.draconicevolution.common.utills.IInventoryTool;
import com.brandon3055.draconicevolution.common.utills.IUpgradableItem;
import com.brandon3055.draconicevolution.common.utills.ItemConfigField;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnumEnchantmentType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;

public class WyvernBow
extends ItemBow
implements IInventoryTool,
IUpgradableItem,
IEnergyContainerItem,
IHudDisplayItem {
    public static final String[] bowPullIconNameArray = new String[]{"pulling_0", "pulling_1", "pulling_2"};
    @SideOnly(value=Side.CLIENT)
    private IIcon[] iconArray;

    public WyvernBow() {
        this.field_77777_bU = 1;
        this.func_77656_e(-1);
        this.func_77637_a(DraconicEvolution.tabToolsWeapons);
        this.func_77655_b("wyvernBow");
        if (ModItems.isEnabled((Item)this)) {
            GameRegistry.registerItem((Item)this, (String)"wyvernBow");
        }
    }

    public boolean func_77616_k(ItemStack p_77616_1_) {
        return true;
    }

    public String func_77658_a() {
        return String.format("item.%s%s", "DraconicEvolution".toLowerCase() + ":", super.func_77658_a().substring(super.func_77658_a().indexOf(".") + 1));
    }

    public String func_77667_c(ItemStack itemStack) {
        return this.func_77658_a();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister iconRegister) {
        this.field_77791_bV = iconRegister.func_94245_a(References.RESOURCESPREFIX + "wyvern_bow" + "_standby");
        this.iconArray = new IIcon[bowPullIconNameArray.length];
        for (int i = 0; i < this.iconArray.length; ++i) {
            this.iconArray[i] = iconRegister.func_94245_a(References.RESOURCESPREFIX + "wyvern_bow" + "_" + bowPullIconNameArray[i]);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(ItemStack stack, int renderPass, EntityPlayer player, ItemStack usingItem, int useRemaining) {
        int j2;
        float j = (float)stack.func_77988_m() - (float)useRemaining;
        if (usingItem == null) {
            return this.field_77791_bV;
        }
        BowHandler.BowProperties properties = new BowHandler.BowProperties(stack, player);
        if (j > (float)properties.getDrawTicks()) {
            j = properties.getDrawTicks();
        }
        if ((j2 = (int)((j /= (float)properties.getDrawTicks()) * 2.0f)) < 0) {
            j2 = 0;
        } else if (j2 > 2) {
            j2 = 2;
        }
        return this.func_94599_c(j2);
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_94599_c(int par1) {
        return this.iconArray[par1];
    }

    public boolean hasCustomEntity(ItemStack stack) {
        return true;
    }

    public Entity createEntity(World world, Entity location, ItemStack itemstack) {
        return new EntityPersistentItem(world, location, itemstack);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean extraInformation) {
        boolean show = InfoHelper.holdShiftForDetails((List)list);
        if (show) {
            int preset = ItemNBTHelper.getInteger((ItemStack)stack, (String)"ConfigProfile", (int)0);
            list.add(EnumChatFormatting.DARK_PURPLE + StatCollector.func_74838_a((String)"info.de.capacitorMode.txt") + ": " + ItemNBTHelper.getString((ItemStack)stack, (String)("ProfileName" + preset), (String)("Profile " + preset)));
            List<ItemConfigField> l = this.getFields(stack, 0);
            for (ItemConfigField f : l) {
                list.add(f.getTooltipInfo());
            }
        }
        ToolBase.holdCTRLForUpgrades(list, stack);
        InfoHelper.addEnergyInfo((ItemStack)stack, (List)list);
        if (show && !ConfigHandler.disableLore) {
            InfoHelper.addLore((ItemStack)stack, (List)list, (boolean)true);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs tab, List list) {
        list.add(ItemNBTHelper.setInteger((ItemStack)new ItemStack(item, 1, 0), (String)"Energy", (int)0));
        list.add(ItemNBTHelper.setInteger((ItemStack)new ItemStack(item, 1, 0), (String)"Energy", (int)1000000));
    }

    public boolean func_77614_k() {
        return true;
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return this.getEnergyStored(stack) != this.getMaxEnergyStored(stack);
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return 1.0 - (double)this.getEnergyStored(stack) / (double)this.getMaxEnergyStored(stack);
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        return BowHandler.onBowRightClick((Item)this, stack, world, player);
    }

    public void onUsingTick(ItemStack stack, EntityPlayer player, int count) {
        BowHandler.onBowUsingTick(stack, player, count);
    }

    public void func_77615_a(ItemStack stack, World world, EntityPlayer player, int count) {
        BowHandler.onPlayerStoppedUsingBow(stack, world, player, count);
    }

    @Override
    public String getInventoryName() {
        return StatCollector.func_74838_a((String)"info.de.toolInventoryEnch.txt");
    }

    @Override
    public int getInventorySlots() {
        return 0;
    }

    @Override
    public boolean isEnchantValid(Enchantment enchant) {
        return enchant.field_77351_y == EnumEnchantmentType.bow || enchant.field_77352_x == DraconicEvolution.reaperEnchant.field_77352_x;
    }

    @Override
    public List<ItemConfigField> getFields(ItemStack stack, int slot) {
        ArrayList<ItemConfigField> list = new ArrayList<ItemConfigField>();
        list.add(new ItemConfigField(4, slot, "BowArrowDamage").setMinMaxAndIncromente(Float.valueOf(this.getBaseUpgradePoints(IUpgradableItem.EnumUpgrade.ARROW_DAMAGE.index)), Float.valueOf(IUpgradableItem.EnumUpgrade.ARROW_DAMAGE.getUpgradePoints(stack)), Float.valueOf(0.1f)).readFromItem(stack, Float.valueOf(IUpgradableItem.EnumUpgrade.ARROW_DAMAGE.getUpgradePoints(stack))));
        list.add(new ItemConfigField(4, slot, "BowArrowSpeedModifier").setMinMaxAndIncromente(Float.valueOf(0.0f), Float.valueOf(IUpgradableItem.EnumUpgrade.ARROW_SPEED.getUpgradePoints(stack)), Float.valueOf(0.01f)).readFromItem(stack, Float.valueOf(0.0f)).setModifier("PLUSPERCENT"));
        list.add(new ItemConfigField(6, slot, "BowAutoFire").readFromItem(stack, false));
        list.add(new ItemConfigField(4, slot, "BowExplosionPower").setMinMaxAndIncromente(Float.valueOf(0.0f), Float.valueOf(4.0f), Float.valueOf(0.1f)).readFromItem(stack, Float.valueOf(0.0f)));
        list.add(new ItemConfigField(4, slot, "BowZoomModifier").setMinMaxAndIncromente(Float.valueOf(0.0f), Float.valueOf(3.0f), Float.valueOf(0.01f)).readFromItem(stack, Float.valueOf(0.0f)).setModifier("PLUSPERCENT"));
        return list;
    }

    @Override
    public boolean hasProfiles() {
        return true;
    }

    @Override
    public List<IUpgradableItem.EnumUpgrade> getUpgrades(ItemStack itemstack) {
        return new ArrayList<IUpgradableItem.EnumUpgrade>(){
            {
                this.add(IUpgradableItem.EnumUpgrade.RF_CAPACITY);
                this.add(IUpgradableItem.EnumUpgrade.DRAW_SPEED);
                this.add(IUpgradableItem.EnumUpgrade.ARROW_SPEED);
                this.add(IUpgradableItem.EnumUpgrade.ARROW_DAMAGE);
            }
        };
    }

    @Override
    public int getUpgradeCap(ItemStack itemstack) {
        return 3;
    }

    @Override
    public int getMaxTier(ItemStack itemstack) {
        return 1;
    }

    @Override
    public int getMaxUpgradePoints(int upgradeIndex) {
        if (upgradeIndex == IUpgradableItem.EnumUpgrade.DRAW_SPEED.index) {
            return 5;
        }
        if (upgradeIndex == IUpgradableItem.EnumUpgrade.ARROW_SPEED.index) {
            return 10;
        }
        return 50;
    }

    @Override
    public int getBaseUpgradePoints(int upgradeIndex) {
        if (upgradeIndex == IUpgradableItem.EnumUpgrade.RF_CAPACITY.index) {
            return 2;
        }
        if (upgradeIndex == IUpgradableItem.EnumUpgrade.DRAW_SPEED.index) {
            return 3;
        }
        if (upgradeIndex == IUpgradableItem.EnumUpgrade.ARROW_SPEED.index) {
            return 1;
        }
        if (upgradeIndex == IUpgradableItem.EnumUpgrade.ARROW_DAMAGE.index) {
            return 2;
        }
        return 0;
    }

    @Override
    public List<String> getUpgradeStats(ItemStack stack) {
        BowHandler.BowProperties properties = new BowHandler.BowProperties(stack, null);
        ArrayList<String> list = new ArrayList<String>();
        list.add(InfoHelper.ITC() + StatCollector.func_74838_a((String)"gui.de.RFCapacity.txt") + ": " + InfoHelper.HITC() + Utills.formatNumber((long)this.getMaxEnergyStored(stack)));
        list.add(InfoHelper.ITC() + StatCollector.func_74838_a((String)"gui.de.max.txt") + " " + StatCollector.func_74838_a((String)"gui.de.ArrowSpeed.txt") + ": " + InfoHelper.HITC() + "+" + IUpgradableItem.EnumUpgrade.ARROW_SPEED.getUpgradePoints(stack) * 100 + "%");
        list.add(InfoHelper.ITC() + StatCollector.func_74838_a((String)"gui.de.ArrowDamage.txt") + ": " + InfoHelper.HITC() + properties.arrowDamage + "");
        list.add(InfoHelper.ITC() + StatCollector.func_74838_a((String)"gui.de.DrawSpeed.txt") + ": " + InfoHelper.HITC() + (double)properties.getDrawTicks() / 20.0 + "s");
        return list;
    }

    public int receiveEnergy(ItemStack container, int maxReceive, boolean simulate) {
        int energy = ItemNBTHelper.getInteger((ItemStack)container, (String)"Energy", (int)0);
        int energyReceived = Math.min(this.getMaxEnergyStored(container) - energy, Math.min(50000, maxReceive));
        if (!simulate) {
            ItemNBTHelper.setInteger((ItemStack)container, (String)"Energy", (int)(energy += energyReceived));
        }
        return energyReceived;
    }

    public int extractEnergy(ItemStack container, int maxExtract, boolean simulate) {
        int energy = ItemNBTHelper.getInteger((ItemStack)container, (String)"Energy", (int)0);
        int energyExtracted = Math.min(energy, maxExtract);
        if (!simulate) {
            ItemNBTHelper.setInteger((ItemStack)container, (String)"Energy", (int)(energy -= energyExtracted));
        }
        return energyExtracted;
    }

    public int getEnergyStored(ItemStack container) {
        return ItemNBTHelper.getInteger((ItemStack)container, (String)"Energy", (int)0);
    }

    public int getMaxEnergyStored(ItemStack stack) {
        int i = IUpgradableItem.EnumUpgrade.RF_CAPACITY.getUpgradePoints(stack);
        return i * 500000;
    }

    @Override
    public List<String> getDisplayData(ItemStack stack) {
        ArrayList<String> list = new ArrayList<String>();
        if (BrandonsCore.proxy.getClientPlayer() != null && BrandonsCore.proxy.getClientPlayer().func_71011_bu() != null) {
            EntityPlayer player = BrandonsCore.proxy.getClientPlayer();
            BowHandler.BowProperties properties = new BowHandler.BowProperties(stack, player);
            int power = (int)Math.min((float)player.func_71057_bx() / (float)properties.getDrawTicks() * 100.0f, 100.0f);
            list.add(InfoHelper.ITC() + StatCollector.func_74838_a((String)"info.de.power.txt") + ": " + InfoHelper.HITC() + power + "%");
        } else {
            int preset = ItemNBTHelper.getInteger((ItemStack)stack, (String)"ConfigProfile", (int)0);
            list.add(EnumChatFormatting.DARK_PURPLE + StatCollector.func_74838_a((String)"info.de.capacitorMode.txt") + ": " + ItemNBTHelper.getString((ItemStack)stack, (String)("ProfileName" + preset), (String)("Profile " + preset)));
            for (ItemConfigField field : this.getFields(stack, 0)) {
                if (!(field.datatype == 4 && ((Float)field.value).floatValue() > 0.0f) && (field.datatype != 6 || !((Boolean)field.value).booleanValue())) continue;
                list.add(field.getTooltipInfo());
            }
            list.add(InfoHelper.ITC() + StatCollector.func_74838_a((String)"info.de.charge.txt") + ": " + InfoHelper.HITC() + Utills.formatNumber((long)this.getEnergyStored(stack)) + " / " + Utills.formatNumber((long)this.getMaxEnergyStored(stack)));
            if (BrandonsCore.proxy.getClientPlayer() != null) {
                BowHandler.BowProperties properties = new BowHandler.BowProperties(stack, BrandonsCore.proxy.getClientPlayer());
                list.add(InfoHelper.ITC() + StatCollector.func_74838_a((String)"gui.de.rfPerShot.txt") + ": " + InfoHelper.HITC() + Utills.addCommas((int)properties.calculateEnergyCost()));
                if (!properties.canFire() && properties.cantFireMessage != null) {
                    list.add(EnumChatFormatting.DARK_RED + StatCollector.func_74838_a((String)properties.cantFireMessage));
                }
            }
        }
        return list;
    }
}

