/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.common.items.tools;

import com.brandon3055.draconicevolution.client.render.IRenderTweak;
import com.brandon3055.draconicevolution.common.ModItems;
import com.brandon3055.draconicevolution.common.items.tools.baseclasses.MiningTool;
import com.brandon3055.draconicevolution.common.utills.IInventoryTool;
import com.brandon3055.draconicevolution.common.utills.IUpgradableItem;
import com.brandon3055.draconicevolution.common.utills.ItemConfigField;
import java.util.List;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnumEnchantmentType;
import net.minecraft.item.ItemStack;
import net.minecraft.util.StatCollector;
import net.minecraftforge.client.IItemRenderer;
import org.lwjgl.opengl.GL11;

public class DraconicShovel
extends MiningTool
implements IInventoryTool,
IRenderTweak {
    protected int capacity = 10000000;
    protected int maxReceive = 500000;
    protected int maxExtract = 500000;

    public DraconicShovel() {
        super(ModItems.AWAKENED);
        this.setHarvestLevel("shovel", 10);
        this.func_77655_b("draconicShovel");
        this.setCapacity(10000000);
        this.setMaxExtract(500000);
        this.setMaxReceive(500000);
        this.energyPerOperation = 80;
        ModItems.register(this);
    }

    @Override
    public List<ItemConfigField> getFields(ItemStack stack, int slot) {
        List<ItemConfigField> list = super.getFields(stack, slot);
        list.add(new ItemConfigField(2, slot, "ToolDigAOE").setMinMaxAndIncromente(0, IUpgradableItem.EnumUpgrade.DIG_AOE.getUpgradePoints(stack), 1).readFromItem(stack, 0).setModifier("AOE"));
        list.add(new ItemConfigField(2, slot, "ToolDigDepth").setMinMaxAndIncromente(1, IUpgradableItem.EnumUpgrade.DIG_DEPTH.getUpgradePoints(stack), 1).readFromItem(stack, 1));
        list.add(new ItemConfigField(6, slot, "ToolVoidJunk").readFromItem(stack, false));
        return list;
    }

    @Override
    public String getInventoryName() {
        return StatCollector.func_74838_a((String)"info.de.toolInventoryOblit.txt");
    }

    @Override
    public int getInventorySlots() {
        return 9;
    }

    @Override
    public boolean isEnchantValid(Enchantment enchant) {
        return enchant.field_77351_y == EnumEnchantmentType.digger;
    }

    @Override
    public void tweakRender(IItemRenderer.ItemRenderType type) {
        GL11.glTranslated((double)0.15, (double)0.9, (double)-0.12);
        GL11.glRotatef((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glRotatef((float)140.0f, (float)0.0f, (float)-1.0f, (float)0.0f);
        GL11.glScaled((double)0.7, (double)0.7, (double)0.7);
        if (type == IItemRenderer.ItemRenderType.EQUIPPED_FIRST_PERSON) {
            GL11.glRotatef((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glTranslated((double)0.0, (double)-0.4, (double)0.0);
        } else if (type == IItemRenderer.ItemRenderType.INVENTORY) {
            GL11.glRotatef((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glScalef((float)10.0f, (float)10.0f, (float)10.0f);
            GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glTranslated((double)-1.45, (double)0.0, (double)-0.15);
        } else if (type == IItemRenderer.ItemRenderType.ENTITY) {
            GL11.glRotatef((float)-90.5f, (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glTranslated((double)-0.38, (double)0.0, (double)-0.6);
        }
    }

    @Override
    public int getUpgradeCap(ItemStack itemstack) {
        return 6;
    }

    @Override
    public int getMaxTier(ItemStack itemstack) {
        return 2;
    }

    @Override
    public List<String> getUpgradeStats(ItemStack stack) {
        return super.getUpgradeStats(stack);
    }

    @Override
    public int getMaxUpgradePoints(int upgradeIndex) {
        if (upgradeIndex == IUpgradableItem.EnumUpgrade.DIG_AOE.index) {
            return 4;
        }
        if (upgradeIndex == IUpgradableItem.EnumUpgrade.DIG_DEPTH.index) {
            return 5;
        }
        return 50;
    }

    @Override
    public int getBaseUpgradePoints(int upgradeIndex) {
        if (upgradeIndex == IUpgradableItem.EnumUpgrade.RF_CAPACITY.index) {
            return 2;
        }
        if (upgradeIndex == IUpgradableItem.EnumUpgrade.DIG_AOE.index) {
            return 2;
        }
        if (upgradeIndex == IUpgradableItem.EnumUpgrade.DIG_DEPTH.index) {
            return 1;
        }
        if (upgradeIndex == IUpgradableItem.EnumUpgrade.DIG_SPEED.index) {
            return 5;
        }
        return 0;
    }
}

