/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.common.items.armor;

import com.brandon3055.brandonscore.BrandonsCore;
import com.brandon3055.brandonscore.common.utills.InfoHelper;
import com.brandon3055.brandonscore.common.utills.ItemNBTHelper;
import com.brandon3055.brandonscore.common.utills.Utills;
import com.brandon3055.draconicevolution.DraconicEvolution;
import com.brandon3055.draconicevolution.client.model.ModelDraconicArmor;
import com.brandon3055.draconicevolution.client.model.ModelDraconicArmorOld;
import com.brandon3055.draconicevolution.common.ModItems;
import com.brandon3055.draconicevolution.common.entity.EntityPersistentItem;
import com.brandon3055.draconicevolution.common.handler.ConfigHandler;
import com.brandon3055.draconicevolution.common.items.armor.ICustomArmor;
import com.brandon3055.draconicevolution.common.items.tools.baseclasses.ToolBase;
import com.brandon3055.draconicevolution.common.lib.References;
import com.brandon3055.draconicevolution.common.utills.IConfigurableItem;
import com.brandon3055.draconicevolution.common.utills.IInventoryTool;
import com.brandon3055.draconicevolution.common.utills.IUpgradableItem;
import com.brandon3055.draconicevolution.common.utills.ItemConfigField;
import com.brandon3055.draconicevolution.integration.ModHelper;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.Optional;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.ReflectionHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnumEnchantmentType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.common.ISpecialArmor;
import thaumcraft.api.IGoggles;
import thaumcraft.api.nodes.IRevealer;

@Optional.InterfaceList(value={@Optional.Interface(iface="thaumcraft.api.IGoggles", modid="Thaumcraft"), @Optional.Interface(iface="thaumcraft.api.nodes.IRevealer", modid="Thaumcraft")})
public class DraconicArmor
extends ItemArmor
implements ISpecialArmor,
IConfigurableItem,
IInventoryTool,
IGoggles,
IRevealer,
IUpgradableItem,
ICustomArmor {
    @SideOnly(value=Side.CLIENT)
    private IIcon helmIcon;
    @SideOnly(value=Side.CLIENT)
    private IIcon chestIcon;
    @SideOnly(value=Side.CLIENT)
    private IIcon leggsIcon;
    @SideOnly(value=Side.CLIENT)
    private IIcon bootsIcon;
    private int maxTransfer = 500000;
    private int maxEnergy = 10000000;
    @SideOnly(value=Side.CLIENT)
    public ModelBiped model;

    public DraconicArmor(ItemArmor.ArmorMaterial material, int armorType, String name) {
        super(material, 0, armorType);
        this.func_77655_b(name);
        this.func_77637_a(DraconicEvolution.tabToolsWeapons);
        if (ModItems.isEnabled((Item)this)) {
            GameRegistry.registerItem((Item)this, (String)name);
        }
    }

    public boolean func_77616_k(ItemStack p_77616_1_) {
        return true;
    }

    public void func_150895_a(Item item, CreativeTabs p_150895_2_, List list) {
        list.add(ItemNBTHelper.setInteger((ItemStack)new ItemStack(item), (String)"Energy", (int)0));
        list.add(ItemNBTHelper.setInteger((ItemStack)new ItemStack(item), (String)"Energy", (int)this.maxEnergy));
    }

    public String func_77658_a() {
        return String.format("item.%s%s", "DraconicEvolution".toLowerCase() + ":", super.func_77658_a().substring(super.func_77658_a().indexOf(".") + 1));
    }

    public String func_77667_c(ItemStack itemStack) {
        return this.func_77658_a();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister iconRegister) {
        this.helmIcon = iconRegister.func_94245_a(References.RESOURCESPREFIX + "draconic_helmet");
        this.chestIcon = iconRegister.func_94245_a(References.RESOURCESPREFIX + "draconic_chestplate");
        this.leggsIcon = iconRegister.func_94245_a(References.RESOURCESPREFIX + "draconic_leggings");
        this.bootsIcon = iconRegister.func_94245_a(References.RESOURCESPREFIX + "draconic_boots");
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(ItemStack stack, int renderPass, EntityPlayer player, ItemStack usingItem, int useRemaining) {
        if (stack.func_77973_b() == ModItems.draconicHelm) {
            return this.helmIcon;
        }
        if (stack.func_77973_b() == ModItems.draconicChest) {
            return this.chestIcon;
        }
        if (stack.func_77973_b() == ModItems.draconicLeggs) {
            return this.leggsIcon;
        }
        return this.bootsIcon;
    }

    public IIcon func_77650_f(ItemStack stack) {
        if (stack.func_77973_b() == ModItems.draconicHelm) {
            return this.helmIcon;
        }
        if (stack.func_77973_b() == ModItems.draconicChest) {
            return this.chestIcon;
        }
        if (stack.func_77973_b() == ModItems.draconicLeggs) {
            return this.leggsIcon;
        }
        return this.bootsIcon;
    }

    @SideOnly(value=Side.CLIENT)
    public String getArmorTexture(ItemStack stack, Entity entity, int slot, String type) {
        if (!ConfigHandler.useOldArmorModel) {
            return References.RESOURCESPREFIX + "textures/models/armor/armorDraconic.png";
        }
        if (stack.func_77973_b() == ModItems.draconicHelm || stack.func_77973_b() == ModItems.draconicChest || stack.func_77973_b() == ModItems.draconicBoots) {
            return References.RESOURCESPREFIX + "textures/models/armor/draconic_layer_1.png";
        }
        return References.RESOURCESPREFIX + "textures/models/armor/draconic_layer_2.png";
    }

    public EnumRarity func_77613_e(ItemStack p_77613_1_) {
        return EnumRarity.epic;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return 1.0 - (double)ItemNBTHelper.getInteger((ItemStack)stack, (String)"Energy", (int)0) / (double)this.getMaxEnergyStored(stack);
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return this.getEnergyStored(stack) < this.getMaxEnergyStored(stack);
    }

    protected float getProtectionShare() {
        switch (this.field_77881_a) {
            case 0: {
                return 0.15f;
            }
            case 1: {
                return 0.4f;
            }
            case 2: {
                return 0.3f;
            }
            case 3: {
                return 0.15f;
            }
        }
        return 0.0f;
    }

    public ISpecialArmor.ArmorProperties getProperties(EntityLivingBase player, ItemStack armor, DamageSource source, double damage, int slot) {
        if (source.func_76363_c() || source.func_151517_h() || source.func_82725_o()) {
            return new ISpecialArmor.ArmorProperties(0, (double)this.field_77879_b / 100.0, 15);
        }
        return new ISpecialArmor.ArmorProperties(0, (double)this.field_77879_b / 24.5, 1000);
    }

    public int getArmorDisplay(EntityPlayer player, ItemStack armor, int slot) {
        return (int)((double)this.getProtectionShare() * 20.0);
    }

    public void damageArmor(EntityLivingBase entity, ItemStack stack, DamageSource source, int damage, int slot) {
    }

    public void onArmorTick(World world, EntityPlayer player, ItemStack stack) {
        if (stack == null) {
            return;
        }
        if (stack.func_77973_b() == ModItems.draconicHelm) {
            if (world.field_72995_K) {
                return;
            }
            if (this.getEnergyStored(stack) >= 5000 && this.clearNegativeEffects((Entity)player)) {
                this.extractEnergy(stack, 5000, false);
            }
            if (player.field_70170_p.func_72957_l((int)Math.floor(player.field_70165_t), (int)player.field_70163_u + 1, (int)Math.floor(player.field_70161_v)) < 5 && IConfigurableItem.ProfileHelper.getBoolean(stack, "ArmorNVActive", false)) {
                player.func_70690_d(new PotionEffect(Potion.field_76439_r.field_76415_H, 419, 0, true));
            } else if (IConfigurableItem.ProfileHelper.getBoolean(stack, "ArmorNVActive", false) && IConfigurableItem.ProfileHelper.getBoolean(stack, "ArmorNVLock", true)) {
                player.func_70690_d(new PotionEffect(Potion.field_76439_r.field_76415_H, 419, 0, true));
            } else if (player.func_82165_m(Potion.field_76439_r.field_76415_H)) {
                player.func_82170_o(Potion.field_76439_r.field_76415_H);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer par2EntityPlayer, List list, boolean par4) {
        InfoHelper.addEnergyAndLore((ItemStack)stack, (List)list);
        ToolBase.holdCTRLForUpgrades(list, stack);
    }

    public boolean clearNegativeEffects(Entity par3Entity) {
        boolean flag = false;
        if (par3Entity.field_70173_aa % 20 == 0 && par3Entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)par3Entity;
            Collection potions = player.func_70651_bq();
            if (player.func_70027_ad()) {
                player.func_70066_B();
                flag = true;
            } else {
                for (PotionEffect potion : potions) {
                    int id = potion.func_76456_a();
                    if (!((Boolean)ReflectionHelper.getPrivateValue(Potion.class, (Object)Potion.field_76425_a[id], (String[])new String[]{"isBadEffect", "field_76418_K", "J"})).booleanValue()) continue;
                    if (potion.func_76456_a() == Potion.field_76419_f.field_76415_H && ModHelper.isHoldingCleaver(player) || player.func_70694_bm() != null && (player.func_70694_bm().func_77973_b() == ModItems.wyvernBow || player.func_70694_bm().func_77973_b() == ModItems.draconicBow) && id == 2) break;
                    player.func_82170_o(id);
                    flag = true;
                    break;
                }
            }
        }
        return flag;
    }

    public int receiveEnergy(ItemStack container, int maxReceive, boolean simulate) {
        int stored = ItemNBTHelper.getInteger((ItemStack)container, (String)"Energy", (int)0);
        int receive = Math.min(maxReceive, Math.min(this.getMaxEnergyStored(container) - stored, this.maxTransfer));
        if (!simulate) {
            ItemNBTHelper.setInteger((ItemStack)container, (String)"Energy", (int)(stored += receive));
        }
        return receive;
    }

    public int extractEnergy(ItemStack container, int maxExtract, boolean simulate) {
        int stored = ItemNBTHelper.getInteger((ItemStack)container, (String)"Energy", (int)0);
        int extract = Math.min(maxExtract, stored);
        if (!simulate) {
            ItemNBTHelper.setInteger((ItemStack)container, (String)"Energy", (int)(stored -= extract));
        }
        return extract;
    }

    public int getEnergyStored(ItemStack container) {
        return ItemNBTHelper.getInteger((ItemStack)container, (String)"Energy", (int)0);
    }

    public int getMaxEnergyStored(ItemStack container) {
        int i = IUpgradableItem.EnumUpgrade.RF_CAPACITY.getUpgradePoints(container);
        return i * 5000000;
    }

    public Entity createEntity(World world, Entity location, ItemStack itemstack) {
        return new EntityPersistentItem(world, location, itemstack);
    }

    public boolean hasCustomEntity(ItemStack stack) {
        return true;
    }

    @Override
    public List<ItemConfigField> getFields(ItemStack stack, int slot) {
        ArrayList<ItemConfigField> list = new ArrayList<ItemConfigField>();
        if (this.field_77881_a == 0) {
            list.add(new ItemConfigField(6, slot, "ArmorNVActive").readFromItem(stack, false));
            list.add(new ItemConfigField(6, slot, "ArmorNVLock").readFromItem(stack, true));
            if (Loader.isModLoaded((String)"Thaumcraft")) {
                list.add(new ItemConfigField(6, slot, "GogglesOfRevealing").readFromItem(stack, true));
            }
        } else if (this.field_77881_a == 1) {
            list.add(new ItemConfigField(4, slot, "VerticalAcceleration").setMinMaxAndIncromente(Float.valueOf(0.0f), Float.valueOf(8.0f), Float.valueOf(0.1f)).readFromItem(stack, Float.valueOf(0.0f)).setModifier("PLUSPERCENT"));
            list.add(new ItemConfigField(4, slot, "ArmorFlightSpeedMult").setMinMaxAndIncromente(Float.valueOf(0.0f), Float.valueOf(6.0f), Float.valueOf(0.1f)).readFromItem(stack, Float.valueOf(0.0f)).setModifier("PLUSPERCENT"));
            list.add(new ItemConfigField(6, slot, "EffectiveOnSprint").readFromItem(stack, false));
            list.add(new ItemConfigField(6, slot, "ArmorFlightLock").readFromItem(stack, false));
            list.add(new ItemConfigField(6, slot, "ArmorInertiaCancellation").readFromItem(stack, false));
        } else if (this.field_77881_a == 2) {
            list.add(new ItemConfigField(4, slot, "ArmorSpeedMult").setMinMaxAndIncromente(Float.valueOf(0.0f), Float.valueOf(8.0f), Float.valueOf(0.1f)).readFromItem(stack, Float.valueOf(0.0f)).setModifier("PLUSPERCENT"));
            list.add(new ItemConfigField(6, slot, "ArmorSprintOnly").readFromItem(stack, false));
        } else if (this.field_77881_a == 3) {
            list.add(new ItemConfigField(4, slot, "ArmorJumpMult").setMinMaxAndIncromente(Float.valueOf(0.0f), Float.valueOf(15.0f), Float.valueOf(0.1f)).readFromItem(stack, Float.valueOf(0.0f)).setModifier("PLUSPERCENT"));
            list.add(new ItemConfigField(6, slot, "ArmorSprintOnly").readFromItem(stack, false));
            list.add(new ItemConfigField(6, slot, "ArmorHillStep").readFromItem(stack, true));
        }
        return list;
    }

    @Override
    public String getInventoryName() {
        return StatCollector.func_74838_a((String)"info.de.toolInventoryEnch.txt");
    }

    @Override
    public int getInventorySlots() {
        return 0;
    }

    @Override
    public boolean isEnchantValid(Enchantment enchant) {
        return enchant.field_77351_y == EnumEnchantmentType.armor || this.field_77881_a == 0 && enchant.field_77351_y == EnumEnchantmentType.armor_head || this.field_77881_a == 1 && enchant.field_77351_y == EnumEnchantmentType.armor_torso || this.field_77881_a == 2 && enchant.field_77351_y == EnumEnchantmentType.armor_legs || this.field_77881_a == 3 && enchant.field_77351_y == EnumEnchantmentType.armor_feet;
    }

    @Optional.Method(modid="Thaumcraft")
    public boolean showIngamePopups(ItemStack itemstack, EntityLivingBase player) {
        return IConfigurableItem.ProfileHelper.getBoolean(itemstack, "GogglesOfRevealing", true);
    }

    @Optional.Method(modid="Thaumcraft")
    public boolean showNodes(ItemStack itemstack, EntityLivingBase player) {
        return IConfigurableItem.ProfileHelper.getBoolean(itemstack, "GogglesOfRevealing", true);
    }

    @SideOnly(value=Side.CLIENT)
    public ModelBiped getArmorModel(EntityLivingBase entityLiving, ItemStack itemStack, int armorSlot) {
        if (ConfigHandler.useOldArmorModel) {
            return super.getArmorModel(entityLiving, itemStack, armorSlot);
        }
        if (!ConfigHandler.useOriginal3DArmorModel) {
            if (this.model == null) {
                this.model = this.field_77881_a == 0 ? new ModelDraconicArmor(1.1f, true, false, false, false) : (this.field_77881_a == 1 ? new ModelDraconicArmor(1.1f, false, true, false, false) : (this.field_77881_a == 2 ? new ModelDraconicArmor(1.1f, false, false, true, false) : new ModelDraconicArmor(1.1f, false, false, false, true)));
                this.model.field_78116_c.field_78806_j = this.field_77881_a == 0;
                this.model.field_78114_d.field_78806_j = this.field_77881_a == 0;
                this.model.field_78115_e.field_78806_j = this.field_77881_a == 1 || this.field_77881_a == 2;
                this.model.field_78113_g.field_78806_j = this.field_77881_a == 1;
                this.model.field_78112_f.field_78806_j = this.field_77881_a == 1;
                this.model.field_78124_i.field_78806_j = this.field_77881_a == 2 || this.field_77881_a == 3;
                this.model.field_78123_h.field_78806_j = this.field_77881_a == 2 || this.field_77881_a == 3;
            }
        } else if (this.model == null) {
            this.model = this.field_77881_a == 0 ? new ModelDraconicArmorOld(1.1f, true, false, false, false, true) : (this.field_77881_a == 1 ? new ModelDraconicArmorOld(1.1f, false, true, false, false, true) : (this.field_77881_a == 2 ? new ModelDraconicArmorOld(1.1f, false, false, true, false, true) : new ModelDraconicArmorOld(1.1f, false, false, false, true, true)));
            this.model.field_78116_c.field_78806_j = this.field_77881_a == 0;
            this.model.field_78114_d.field_78806_j = this.field_77881_a == 0;
            this.model.field_78115_e.field_78806_j = this.field_77881_a == 1 || this.field_77881_a == 2;
            this.model.field_78113_g.field_78806_j = this.field_77881_a == 1;
            this.model.field_78112_f.field_78806_j = this.field_77881_a == 1;
            this.model.field_78124_i.field_78806_j = this.field_77881_a == 2 || this.field_77881_a == 3;
            boolean bl = this.model.field_78123_h.field_78806_j = this.field_77881_a == 2 || this.field_77881_a == 3;
        }
        if (entityLiving == null) {
            return this.model;
        }
        this.model.field_78117_n = entityLiving.func_70093_af();
        this.model.field_78093_q = entityLiving.func_70115_ae();
        this.model.field_78091_s = entityLiving.func_70631_g_();
        this.model.field_78118_o = false;
        int n = this.model.field_78120_m = entityLiving.func_70694_bm() != null ? 1 : 0;
        if (entityLiving instanceof EntityPlayer && ((EntityPlayer)entityLiving).func_71057_bx() > 0) {
            EnumAction enumaction = ((EntityPlayer)entityLiving).func_71011_bu().func_77975_n();
            if (enumaction == EnumAction.block) {
                this.model.field_78120_m = 3;
            } else if (enumaction == EnumAction.bow) {
                this.model.field_78118_o = true;
            }
        }
        return this.model;
    }

    @Override
    public List<IUpgradableItem.EnumUpgrade> getUpgrades(ItemStack itemstack) {
        return new ArrayList<IUpgradableItem.EnumUpgrade>(){
            {
                this.add(IUpgradableItem.EnumUpgrade.RF_CAPACITY);
                this.add(IUpgradableItem.EnumUpgrade.SHIELD_CAPACITY);
                this.add(IUpgradableItem.EnumUpgrade.SHIELD_RECOVERY);
            }
        };
    }

    @Override
    public int getUpgradeCap(ItemStack itemstack) {
        return 6;
    }

    @Override
    public int getMaxTier(ItemStack itemstack) {
        return 2;
    }

    @Override
    public List<String> getUpgradeStats(ItemStack stack) {
        ArrayList<String> strings = new ArrayList<String>();
        strings.add(InfoHelper.ITC() + StatCollector.func_74838_a((String)"gui.de.RFCapacity.txt") + ": " + InfoHelper.HITC() + Utills.formatNumber((long)this.getMaxEnergyStored(stack)));
        strings.add(InfoHelper.ITC() + StatCollector.func_74838_a((String)"gui.de.ShieldCapacity.txt") + ": " + InfoHelper.HITC() + (int)this.getProtectionPoints(stack));
        strings.add(InfoHelper.ITC() + StatCollector.func_74838_a((String)"gui.de.ShieldRecovery.txt") + ": " + InfoHelper.HITC() + Utills.round((double)((double)this.getRecoveryPoints(stack) * 0.2), (double)10.0) + " EPS");
        return strings;
    }

    @Override
    public int getMaxUpgradePoints(int upgradeIndex) {
        return 50;
    }

    @Override
    public int getBaseUpgradePoints(int upgradeIndex) {
        if (upgradeIndex == IUpgradableItem.EnumUpgrade.RF_CAPACITY.index) {
            return 2;
        }
        if (upgradeIndex == IUpgradableItem.EnumUpgrade.SHIELD_CAPACITY.index) {
            return (int)(this.getProtectionShare() * 25.0f) + (this.field_77881_a == 2 ? 2 : 0);
        }
        if (upgradeIndex == IUpgradableItem.EnumUpgrade.SHIELD_RECOVERY.index) {
            return 5;
        }
        return 0;
    }

    @Override
    public float getProtectionPoints(ItemStack stack) {
        return IUpgradableItem.EnumUpgrade.SHIELD_CAPACITY.getUpgradePoints(stack) * 20;
    }

    @Override
    public int getRecoveryPoints(ItemStack stack) {
        return IUpgradableItem.EnumUpgrade.SHIELD_RECOVERY.getUpgradePoints(stack);
    }

    @Override
    public float getSpeedModifier(ItemStack stack, EntityPlayer player) {
        if (IConfigurableItem.ProfileHelper.getBoolean(stack, "ArmorSprintOnly", false)) {
            return player.func_70051_ag() ? IConfigurableItem.ProfileHelper.getFloat(stack, "ArmorSpeedMult", 0.0f) : IConfigurableItem.ProfileHelper.getFloat(stack, "ArmorSpeedMult", 0.0f) / 5.0f;
        }
        return IConfigurableItem.ProfileHelper.getFloat(stack, "ArmorSpeedMult", 0.0f);
    }

    @Override
    public float getJumpModifier(ItemStack stack, EntityPlayer player) {
        if (IConfigurableItem.ProfileHelper.getBoolean(stack, "ArmorSprintOnly", false)) {
            return player.func_70051_ag() || BrandonsCore.proxy.isCtrlDown() ? IConfigurableItem.ProfileHelper.getFloat(stack, "ArmorJumpMult", 0.0f) : IConfigurableItem.ProfileHelper.getFloat(stack, "ArmorJumpMult", 0.0f) / 5.0f;
        }
        return IConfigurableItem.ProfileHelper.getFloat(stack, "ArmorJumpMult", 0.0f);
    }

    @Override
    public boolean hasHillStep(ItemStack stack, EntityPlayer player) {
        if (IConfigurableItem.ProfileHelper.getBoolean(stack, "ArmorSprintOnly", false)) {
            return (player.func_70051_ag() || BrandonsCore.proxy.isCtrlDown()) && IConfigurableItem.ProfileHelper.getBoolean(stack, "ArmorHillStep", true);
        }
        return IConfigurableItem.ProfileHelper.getBoolean(stack, "ArmorHillStep", true);
    }

    @Override
    public float getFireResistance(ItemStack stack) {
        return 1.0f;
    }

    @Override
    public boolean[] hasFlight(ItemStack stack) {
        return new boolean[]{true, IConfigurableItem.ProfileHelper.getBoolean(stack, "ArmorFlightLock", false), IConfigurableItem.ProfileHelper.getBoolean(stack, "ArmorInertiaCancellation", false)};
    }

    @Override
    public float getFlightSpeedModifier(ItemStack stack, EntityPlayer player) {
        if (IConfigurableItem.ProfileHelper.getBoolean(stack, "EffectiveOnSprint", false)) {
            return BrandonsCore.proxy.isCtrlDown() ? IConfigurableItem.ProfileHelper.getFloat(stack, "ArmorFlightSpeedMult", 0.0f) : 0.0f;
        }
        return IConfigurableItem.ProfileHelper.getFloat(stack, "ArmorFlightSpeedMult", 0.0f);
    }

    @Override
    public float getFlightVModifier(ItemStack stack, EntityPlayer player) {
        if (IConfigurableItem.ProfileHelper.getBoolean(stack, "EffectiveOnSprint", false)) {
            return BrandonsCore.proxy.isCtrlDown() ? IConfigurableItem.ProfileHelper.getFloat(stack, "VerticalAcceleration", 0.0f) : 0.0f;
        }
        return IConfigurableItem.ProfileHelper.getFloat(stack, "VerticalAcceleration", 0.0f);
    }

    @Override
    public boolean hasProfiles() {
        return false;
    }
}

