/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.common.container;

import com.brandon3055.draconicevolution.common.ModItems;
import com.brandon3055.draconicevolution.common.container.ContainerDataSync;
import com.brandon3055.draconicevolution.common.tileentities.TileUpgradeModifier;
import com.brandon3055.draconicevolution.common.utills.IUpgradableItem;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class ContainerUpgradeModifier
extends ContainerDataSync {
    private static final Item[] CORES_INDEX = new Item[]{ModItems.draconicCore, ModItems.wyvernCore, ModItems.awakenedCore, ModItems.chaoticCore};
    private TileUpgradeModifier tile;
    private EntityPlayer player;
    private boolean slotsActive = true;

    public ContainerUpgradeModifier(InventoryPlayer invPlayer, TileUpgradeModifier tile) {
        this.tile = tile;
        this.player = invPlayer.field_70458_d;
        for (int x = 0; x < 9; ++x) {
            this.func_75146_a(new Slot((IInventory)invPlayer, x, 8 + 18 * x, 167));
        }
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 9; ++x) {
                this.func_75146_a(new Slot((IInventory)invPlayer, x + y * 9 + 9, 8 + 18 * x, 111 + y * 18));
            }
        }
        this.func_75146_a(new SlotUpgradable((IInventory)tile, 0, 112, 48));
    }

    public void func_75142_b() {
        super.func_75142_b();
        for (int i = 0; i < this.field_75149_d.size(); ++i) {
            ICrafting icrafting = (ICrafting)this.field_75149_d.get(i);
            icrafting.func_71112_a((Container)this, 0, 0);
        }
        this.updateSlotState();
    }

    public void func_75137_b(int index, int value) {
        super.func_75137_b(index, value);
        if (index == 0) {
            this.updateSlotState();
        }
    }

    private void updateSlotState() {
        if (this.tile.func_70301_a(0) != null && this.tile.func_70301_a(0).func_77973_b() instanceof IUpgradableItem && this.slotsActive) {
            for (Object o : this.field_75151_b) {
                if (!(o instanceof Slot) || o instanceof SlotUpgradable) continue;
                ((Slot)o).field_75223_e += 1000;
            }
            this.slotsActive = false;
        } else if (!(this.tile.func_70301_a(0) != null && this.tile.func_70301_a(0).func_77973_b() instanceof IUpgradableItem || this.slotsActive)) {
            for (Object o : this.field_75151_b) {
                if (!(o instanceof Slot) || o instanceof SlotUpgradable) continue;
                ((Slot)o).field_75223_e -= 1000;
            }
            this.slotsActive = true;
        }
    }

    public boolean func_75145_c(EntityPlayer player) {
        return this.tile.func_70300_a(player);
    }

    public ItemStack func_82846_b(EntityPlayer player, int i) {
        Slot slot = this.func_75139_a(i);
        if (slot != null && slot.func_75216_d()) {
            ItemStack stack = slot.func_75211_c();
            ItemStack result = stack.func_77946_l();
            if (i >= 36 ? !this.func_75135_a(stack, 0, 36, false) : !this.isStackValidForInventory(stack, 0) || !this.func_75135_a(stack, 36, 36 + this.tile.func_70302_i_(), false)) {
                return null;
            }
            if (stack.field_77994_a == 0) {
                slot.func_75215_d(null);
            } else {
                slot.func_75218_e();
            }
            slot.func_82870_a(player, stack);
            return result;
        }
        return null;
    }

    private boolean isStackValidForInventory(ItemStack stack, int slot) {
        return true;
    }

    @Override
    public void receiveSyncData(int index, int value) {
        IUpgradableItem.EnumUpgrade upgrade = IUpgradableItem.EnumUpgrade.getUpgradeByIndex(index);
        int coreTier = value / 2;
        boolean addCore = value % 2 == 0;
        ItemStack stack = this.tile.func_70301_a(0);
        if (upgrade == null || stack == null || !(stack.func_77973_b() instanceof IUpgradableItem) || coreTier < 0 || coreTier > 3 || upgrade.getCoresApplied(stack)[coreTier] <= 0 && !addCore) {
            return;
        }
        this.handleCoreTransaction(upgrade, coreTier, addCore, (IUpgradableItem)stack.func_77973_b(), stack);
    }

    private void handleCoreTransaction(IUpgradableItem.EnumUpgrade upgrade, int coreTier, boolean addCoreElseRemove, IUpgradableItem upgradableItem, ItemStack stack) {
        int coreSlots = upgradableItem.getUpgradeCap(stack);
        int totalCores = 0;
        int[] coresApplied = upgrade.getCoresApplied(stack);
        for (IUpgradableItem.EnumUpgrade u : upgradableItem.getUpgrades(stack)) {
            totalCores += u.getCoresApplied(stack)[coreTier];
        }
        if (addCoreElseRemove) {
            if (!this.player.field_71071_by.func_146028_b(CORES_INDEX[coreTier]) || totalCores >= coreSlots || upgrade.getUpgradePoints(stack) >= upgradableItem.getMaxUpgradePoints(upgrade.index)) {
                return;
            }
            int n = coreTier;
            coresApplied[n] = coresApplied[n] + 1;
            this.player.field_71071_by.func_146026_a(CORES_INDEX[coreTier]);
            upgrade.setCoresApplied(stack, coresApplied);
            upgrade.onAppliedToItem(stack);
        } else {
            if (coresApplied[coreTier] <= 0) {
                return;
            }
            int n = coreTier;
            coresApplied[n] = coresApplied[n] - 1;
            upgrade.setCoresApplied(stack, coresApplied);
            upgrade.onRemovedFromItem(stack);
            if (!this.player.field_71071_by.func_70441_a(new ItemStack(CORES_INDEX[coreTier]))) {
                EntityItem entityItem = new EntityItem(this.player.field_70170_p, this.player.field_70165_t, this.player.field_70163_u, this.player.field_70161_v, new ItemStack(CORES_INDEX[coreTier]));
                if (!this.player.field_70170_p.field_72995_K) {
                    this.player.field_70170_p.func_72838_d((Entity)entityItem);
                }
            }
        }
    }

    public static class SlotUpgradable
    extends Slot {
        public SlotUpgradable(IInventory inventory1, int slot, int x, int y) {
            super(inventory1, slot, x, y);
        }

        public boolean func_75214_a(ItemStack stack) {
            return super.func_75214_a(stack);
        }
    }
}

