/*
 * Decompiled with CFR 0.152.
 */
package tombenpotter.sanguimancy.util;

import WayofTime.alchemicalWizardry.api.event.ItemBindEvent;
import WayofTime.alchemicalWizardry.api.event.ItemDrainNetworkEvent;
import WayofTime.alchemicalWizardry.api.event.PlayerAddToNetworkEvent;
import WayofTime.alchemicalWizardry.api.event.RitualActivatedEvent;
import WayofTime.alchemicalWizardry.api.event.TeleposeEvent;
import WayofTime.alchemicalWizardry.api.soulNetwork.SoulNetworkHandler;
import WayofTime.alchemicalWizardry.common.items.EnergyItems;
import WayofTime.alchemicalWizardry.common.spell.complex.effect.SpellHelper;
import amerifrance.guideapi.api.GuideRegistry;
import amerifrance.guideapi.api.base.Book;
import cpw.mods.fml.client.event.ConfigChangedEvent;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.PlayerEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.common.ForgeChunkManager;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.EntityStruckByLightningEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.world.BlockEvent;
import org.lwjgl.opengl.GL11;
import tombenpotter.sanguimancy.Sanguimancy;
import tombenpotter.sanguimancy.api.objects.BlockAndMetadata;
import tombenpotter.sanguimancy.api.soulCorruption.SoulCorruption;
import tombenpotter.sanguimancy.api.soulCorruption.SoulCorruptionHelper;
import tombenpotter.sanguimancy.network.PacketHandler;
import tombenpotter.sanguimancy.network.events.EventCorruptedInfusion;
import tombenpotter.sanguimancy.network.packets.PacketSyncCorruption;
import tombenpotter.sanguimancy.registry.BlocksRegistry;
import tombenpotter.sanguimancy.registry.ItemsRegistry;
import tombenpotter.sanguimancy.registry.SanguimancyGuide;
import tombenpotter.sanguimancy.tile.TileCamouflageBound;
import tombenpotter.sanguimancy.tile.TileItemSNPart;
import tombenpotter.sanguimancy.tile.TileRitualSNPart;
import tombenpotter.sanguimancy.util.BoundItemState;
import tombenpotter.sanguimancy.util.ChunkIntPairSerializable;
import tombenpotter.sanguimancy.util.ConfigHandler;
import tombenpotter.sanguimancy.util.RandomUtils;
import tombenpotter.sanguimancy.util.SanguimancyItemStacks;
import tombenpotter.sanguimancy.util.singletons.BoundItems;
import tombenpotter.sanguimancy.util.singletons.ClaimedChunks;

public class EventHandler {
    public static void syncCorruption(EntityPlayer player) {
        SoulCorruption data = SoulCorruption.get(player);
        if (data != null) {
            NBTTagCompound tagCompound = new NBTTagCompound();
            data.saveNBTData(tagCompound);
            PacketHandler.INSTANCE.sendTo((IMessage)new PacketSyncCorruption(player, tagCompound), (EntityPlayerMP)player);
        }
    }

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.modID.equals("Sanguimancy")) {
            ConfigHandler.syncConfig();
            Sanguimancy.logger.info(StatCollector.func_74838_a((String)"info.Sanguimancy.console.config.refresh"));
        }
    }

    @SubscribeEvent
    public void onPlayerSacrificed(LivingDeathEvent event) {
        if (event.entity != null && !event.entity.field_70170_p.field_72995_K && event.entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.entity;
            String owner = player.func_70005_c_();
            int currentEssence = SoulNetworkHandler.getCurrentEssence((String)owner);
            if (event.source.func_76346_g() != null && event.source.func_76346_g() instanceof EntityPlayer) {
                EntityPlayer perpetrator = (EntityPlayer)event.source.func_76346_g();
                ItemStack attunedStack = new ItemStack(ItemsRegistry.playerSacrificer, 1, 1);
                if (perpetrator.field_71071_by.func_70431_c(attunedStack)) {
                    perpetrator.field_71071_by.func_146026_a(attunedStack.func_77973_b());
                    ItemStack focusedStack = new ItemStack(ItemsRegistry.playerSacrificer, 1, 2);
                    EnergyItems.checkAndSetItemOwner((ItemStack)focusedStack, (String)owner);
                    focusedStack.field_77990_d.func_74768_a("bloodStolen", currentEssence);
                    focusedStack.field_77990_d.func_74778_a("thiefName", perpetrator.func_70005_c_());
                    perpetrator.field_71071_by.func_70441_a(focusedStack);
                    SoulNetworkHandler.setCurrentEssence((String)owner, (int)0);
                    SoulCorruptionHelper.incrementCorruption(player);
                }
            }
        }
    }

    @SubscribeEvent
    public void onPlayerJoinWorld(EntityJoinWorldEvent event) {
        if (!event.entity.field_70170_p.field_72995_K && event.entity != null && event.entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.entity;
            NBTTagCompound tag = RandomUtils.getModTag(player, "Sanguimancy");
            if (!tag.func_74767_n("hasInitialChunkClaimer") && ConfigHandler.addItemsOnFirstLogin) {
                player.func_146105_b((IChatComponent)new ChatComponentText(StatCollector.func_74838_a((String)"chat.Sanguimancy.intial.claimer")));
                if (!player.field_71071_by.func_70441_a(SanguimancyItemStacks.chunkClaimer.func_77946_l())) {
                    RandomUtils.dropItemStackInWorld(player.field_70170_p, player.field_70165_t, player.field_70163_u, player.field_70161_v, SanguimancyItemStacks.chunkClaimer.func_77946_l());
                }
                tag.func_74757_a("hasInitialChunkClaimer", true);
            }
            if (!tag.func_74767_n("hasInitialGuide") && ConfigHandler.addItemsOnFirstLogin) {
                if (!player.field_71071_by.func_70441_a(GuideRegistry.getItemStackForBook((Book)SanguimancyGuide.sanguimancyGuide).func_77946_l())) {
                    RandomUtils.dropItemStackInWorld(player.field_70170_p, player.field_70165_t, player.field_70163_u, player.field_70161_v, GuideRegistry.getItemStackForBook((Book)SanguimancyGuide.sanguimancyGuide).func_77946_l());
                }
                tag.func_74757_a("hasInitialGuide", true);
            }
        }
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (SoulCorruptionHelper.isCorruptionLower(event.player, 2000)) {
            if (SoulCorruptionHelper.isCorruptionOver(event.player, 10)) {
                SoulCorruptionHelper.spawnChickenFollower(event.player);
            }
            if (SoulCorruptionHelper.isCorruptionOver(event.player, 40)) {
                SoulCorruptionHelper.killGrass(event.player);
            }
            if (SoulCorruptionHelper.isCorruptionOver(event.player, 60)) {
                SoulCorruptionHelper.hurtAndHealAnimals(event.player);
            }
            if (SoulCorruptionHelper.isCorruptionOver(event.player, 100)) {
                SoulCorruptionHelper.spawnIllusion(event.player);
            }
            if (SoulCorruptionHelper.isCorruptionOver(event.player, 150)) {
                SoulCorruptionHelper.randomTeleport(event.player);
            }
            if (SoulCorruptionHelper.isCorruptionOver(event.player, 200)) {
                SoulCorruptionHelper.loseHeart(event.player);
            }
        }
        if (SoulCorruptionHelper.isCorruptionOver(event.player, 1300)) {
            event.player.func_70690_d(new PotionEffect(Potion.field_76430_j.func_76396_c(), 1, 1));
        }
        if (SoulCorruptionHelper.isCorruptionOver(event.player, 1600)) {
            event.player.func_70690_d(new PotionEffect(Potion.field_76424_c.func_76396_c(), 1, 1));
        }
        if (SoulCorruptionHelper.isCorruptionOver(event.player, 1900)) {
            event.player.func_70690_d(new PotionEffect(Potion.field_76426_n.func_76396_c(), 1, 1));
        }
        if (SoulCorruptionHelper.isCorruptionOver(event.player, 2100)) {
            event.player.func_70690_d(new PotionEffect(Potion.field_76427_o.func_76396_c(), 1, 1));
        }
        if (SoulCorruptionHelper.isCorruptionOver(event.player, 2400)) {
            event.player.func_70690_d(new PotionEffect(Potion.field_76429_m.func_76396_c(), 1, 1));
        }
        if (!event.player.field_70170_p.field_72995_K && event.player.field_70170_p.func_82737_E() % 200L == 0L) {
            EventHandler.syncCorruption(event.player);
        }
    }

    @SubscribeEvent
    public void onPlayerAttack(AttackEntityEvent event) {
        if (event.entityPlayer != null && event.target != null && event.target instanceof EntityLivingBase) {
            EntityLivingBase target = (EntityLivingBase)event.target;
            if (SoulCorruptionHelper.isCorruptionOver(event.entityPlayer, 30)) {
                SoulCorruptionHelper.addWither(target);
            }
        }
    }

    @SubscribeEvent
    public void onRitualActivation(RitualActivatedEvent event) {
        if (event.player != null && SoulCorruptionHelper.isCorruptionOver(event.player, 50) && event.player.field_70170_p.field_73012_v.nextInt(10) == 0) {
            event.setResult(Event.Result.DENY);
        }
    }

    @SubscribeEvent
    public void onChunkForce(ForgeChunkManager.ForceChunkEvent event) {
        if (!Loader.isModLoaded((String)"loaderlist")) {
            RandomUtils.writeLog(event.ticket.getModId() + " forcing the loading of the chunk at x= " + String.valueOf(event.location.func_77273_a()) + " and z=" + String.valueOf(event.location.func_77274_b()) + " in dimension " + String.valueOf(event.ticket.world.field_73011_w.field_76574_g), "ChunkloadingLog.txt");
        }
    }

    @SubscribeEvent
    public void onChunkUnforce(ForgeChunkManager.UnforceChunkEvent event) {
        if (!Loader.isModLoaded((String)"loaderlist")) {
            RandomUtils.writeLog(event.ticket.getModId() + " unforcing the loading of the chunk at x= " + String.valueOf(event.location.func_77273_a()) + " and z=" + String.valueOf(event.location.func_77274_b()) + " in dimension " + String.valueOf(event.ticket.world.field_73011_w.field_76574_g), "ChunkloadingLog.txt");
        }
    }

    @SubscribeEvent
    public void onItemAddedToSN(ItemBindEvent event) {
        if (!event.player.field_70170_p.field_72995_K && event.player.field_71071_by.func_70431_c(SanguimancyItemStacks.etherealManifestation)) {
            int dimID = ConfigHandler.snDimID;
            WorldServer dimWorld = MinecraftServer.func_71276_C().func_71218_a(dimID);
            if (ClaimedChunks.getClaimedChunks().getLinkedChunks(event.player.func_70005_c_()) != null) {
                for (ChunkIntPairSerializable chunkInt : ClaimedChunks.getClaimedChunks().getLinkedChunks(event.player.func_70005_c_())) {
                    int baseZ;
                    int baseX = (chunkInt.chunkXPos << 4) + dimWorld.field_73012_v.nextInt(16);
                    int baseY = dimWorld.func_72825_h(baseX, baseZ = (chunkInt.chunkZPos << 4) + dimWorld.field_73012_v.nextInt(16)) + 2;
                    if (baseY >= 128) continue;
                    BoundItemState boundItemState = new BoundItemState(baseX, baseY, baseZ, dimID, true);
                    String name = String.valueOf(dimID) + String.valueOf(baseX) + String.valueOf(baseY) + String.valueOf(baseZ) + event.itemStack.func_77977_a() + event.itemStack.func_82833_r() + event.itemStack.func_77960_j() + event.player.func_70005_c_();
                    if (dimWorld.func_147437_c(baseX, baseY, baseZ)) {
                        RandomUtils.checkAndSetCompound(event.itemStack);
                        if (BoundItems.getBoundItems().addItem(name, boundItemState)) {
                            dimWorld.func_147449_b(baseX, baseY, baseZ, BlocksRegistry.boundItem);
                            event.itemStack.field_77990_d.func_74778_a("SavedItemName", name);
                            if (dimWorld.func_147438_o(baseX, baseY, baseZ) != null && dimWorld.func_147438_o(baseX, baseY, baseZ) instanceof TileItemSNPart) {
                                TileItemSNPart tile = (TileItemSNPart)dimWorld.func_147438_o(baseX, baseY, baseZ);
                                tile.func_70299_a(0, event.itemStack.func_77946_l());
                                tile.getCustomNBTTag().func_74778_a("SavedItemName", name);
                                dimWorld.func_147471_g(baseX, baseY, baseZ);
                            }
                        }
                    }
                    event.player.func_146105_b((IChatComponent)new ChatComponentText(StatCollector.func_74838_a((String)"chat.Sanguimancy.added.success")));
                    dimWorld.func_147471_g(baseX, baseY, baseZ);
                    break;
                }
            }
            event.player.field_71071_by.func_146026_a(SanguimancyItemStacks.etherealManifestation.func_77973_b());
        }
    }

    @SubscribeEvent
    public void onItemDrainNetwork(ItemDrainNetworkEvent event) {
        if (!event.player.field_70170_p.field_72995_K && event.itemStack != null && event.itemStack.field_77990_d.func_74764_b("SavedItemName")) {
            String name = event.itemStack.field_77990_d.func_74779_i("SavedItemName");
            if (!BoundItems.getBoundItems().hasKey(name)) {
                event.player.func_146105_b((IChatComponent)new ChatComponentText(StatCollector.func_74838_a((String)"chat.Sanguimancy.removed")));
                RandomUtils.unbindItemStack(event.itemStack);
                event.setResult(Event.Result.DENY);
            } else if (!BoundItems.getBoundItems().getLinkedLocation((String)name).activated.booleanValue()) {
                event.player.func_146105_b((IChatComponent)new ChatComponentText(StatCollector.func_74838_a((String)"chat.Sanguimancy.deactivated")));
                event.setResult(Event.Result.DENY);
            }
        }
    }

    @SubscribeEvent
    public void onItemAddToNetwork(PlayerAddToNetworkEvent event) {
        if (!event.player.field_70170_p.field_72995_K && event.itemStack != null && event.itemStack.field_77990_d.func_74764_b("SavedItemName")) {
            String name = event.itemStack.field_77990_d.func_74779_i("SavedItemName");
            if (!BoundItems.getBoundItems().hasKey(name)) {
                event.player.func_146105_b((IChatComponent)new ChatComponentText(StatCollector.func_74838_a((String)"chat.Sanguimancy.removed")));
                event.setResult(Event.Result.DENY);
            } else if (!BoundItems.getBoundItems().getLinkedLocation((String)name).activated.booleanValue()) {
                event.player.func_146105_b((IChatComponent)new ChatComponentText(StatCollector.func_74838_a((String)"chat.Sanguimancy.deactivated")));
                event.setResult(Event.Result.DENY);
            }
        }
    }

    @SubscribeEvent
    public void onRitualStart(RitualActivatedEvent event) {
        if (!event.player.field_70170_p.field_72995_K && event.player.field_71071_by.func_70431_c(SanguimancyItemStacks.etherealManifestation)) {
            int dimID = ConfigHandler.snDimID;
            WorldServer dimWorld = MinecraftServer.func_71276_C().func_71218_a(dimID);
            if (ClaimedChunks.getClaimedChunks().getLinkedChunks(event.player.func_70005_c_()) != null) {
                for (ChunkIntPairSerializable chunkInt : ClaimedChunks.getClaimedChunks().getLinkedChunks(event.player.func_70005_c_())) {
                    int baseZ;
                    int baseX = (chunkInt.chunkXPos << 4) + dimWorld.field_73012_v.nextInt(16);
                    int baseY = dimWorld.func_72825_h(baseX, baseZ = (chunkInt.chunkZPos << 4) + dimWorld.field_73012_v.nextInt(16)) + 2;
                    if (baseY >= 128) continue;
                    if (dimWorld.func_147437_c(baseX, baseY, baseZ)) {
                        dimWorld.func_147449_b(baseX, baseY, baseZ, BlocksRegistry.ritualRepresentation);
                        if (dimWorld.func_147438_o(baseX, baseY, baseZ) != null && dimWorld.func_147438_o(baseX, baseY, baseZ) instanceof TileRitualSNPart) {
                            TileRitualSNPart part = (TileRitualSNPart)dimWorld.func_147438_o(baseX, baseY, baseZ);
                            part.xRitual = event.mrs.getXCoord();
                            part.yRitual = event.mrs.getYCoord();
                            part.zRitual = event.mrs.getZCoord();
                            dimWorld.func_147471_g(baseX, baseY, baseZ);
                        }
                    }
                    event.player.func_146105_b((IChatComponent)new ChatComponentText(StatCollector.func_74838_a((String)"chat.Sanguimancy.added.success")));
                    break;
                }
            }
            event.player.field_71071_by.func_146026_a(SanguimancyItemStacks.etherealManifestation.func_77973_b());
        }
    }

    @SubscribeEvent
    public void onPlayerCorruptedInfusionAesthetic(EventCorruptedInfusion.EventPlayerCorruptedInfusion event) {
        double posX = event.entityPlayer.field_70165_t;
        double posY = event.entityPlayer.field_70163_u;
        double posZ = event.entityPlayer.field_70161_v;
        event.entityPlayer.field_70170_p.func_72908_a((double)((float)posX + 0.5f), (double)((float)posY + 0.5f), (double)((float)posZ + 0.5f), "random.fizz", 0.5f, 2.6f + (event.entityPlayer.field_70170_p.field_73012_v.nextFloat() - event.entityPlayer.field_70170_p.field_73012_v.nextFloat()) * 0.8f);
        SpellHelper.sendIndexedParticleToAllAround((World)event.entityPlayer.field_70170_p, (double)posX, (double)posY, (double)posZ, (int)20, (int)event.entityPlayer.field_70170_p.field_73011_w.field_76574_g, (int)4, (double)posX, (double)posY, (double)posZ);
    }

    @SubscribeEvent
    public void onBreakBoundTile(BlockEvent.BreakEvent event) {
        if (event.world.func_147438_o(event.x, event.y, event.z) != null && event.world.func_147438_o(event.x, event.y, event.z) instanceof TileCamouflageBound) {
            TileCamouflageBound tile = (TileCamouflageBound)event.world.func_147438_o(event.x, event.y, event.z);
            if (tile.getOwnersList() == null) {
                tile.setOwnersList(new ArrayList<String>());
            }
            if (!tile.getOwnersList().isEmpty() && !tile.getOwnersList().contains(event.getPlayer().func_70005_c_())) {
                event.getPlayer().func_146105_b((IChatComponent)new ChatComponentText(StatCollector.func_74838_a((String)"info.Sanguimancy.tooltip.wrong.player")));
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public void onTranspositionSigilLightning(EntityStruckByLightningEvent event) {
        if (event.lightning.getEntityData() != null && event.lightning.getEntityData().func_74767_n("isTranspositionSigilBolt")) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onTeleposeBlock(TeleposeEvent event) {
        BlockAndMetadata initialBlock = new BlockAndMetadata(event.initialBlock, event.initialMetadata);
        BlockAndMetadata initalWild = new BlockAndMetadata(event.initialBlock, Short.MAX_VALUE);
        BlockAndMetadata finalBlock = new BlockAndMetadata(event.finalBlock, event.finalMetadata);
        BlockAndMetadata finalWild = new BlockAndMetadata(event.finalBlock, Short.MAX_VALUE);
        if (!ConfigHandler.enableTelepositionBlacklist && (RandomUtils.teleposerBlacklist.contains(initialBlock) || RandomUtils.teleposerBlacklist.contains(initalWild) || RandomUtils.teleposerBlacklist.contains(finalBlock) || RandomUtils.teleposerBlacklist.contains(finalWild))) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onCreateEntity(EntityEvent.EntityConstructing event) {
        if (event.entity instanceof EntityPlayer && SoulCorruption.get((EntityPlayer)event.entity) == null) {
            SoulCorruption.create((EntityPlayer)event.entity);
        }
    }

    @SubscribeEvent
    public void onPlayerChangeDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        EventHandler.syncCorruption(event.player);
    }

    @SubscribeEvent
    public void onPlayerSpawn(PlayerEvent.PlayerRespawnEvent event) {
        EventHandler.syncCorruption(event.player);
    }

    @SubscribeEvent
    public void onPlayerClone(PlayerEvent.Clone event) {
        NBTTagCompound tagCompound = new NBTTagCompound();
        SoulCorruption.get(event.original).saveNBTData(tagCompound);
        SoulCorruption.get(event.entityPlayer).saveNBTData(tagCompound);
        EventHandler.syncCorruption(event.entityPlayer);
    }

    @SubscribeEvent
    public void onDigWithCorruptedTool(PlayerEvent.BreakSpeed event) {
        ItemStack stack;
        if (event.entityPlayer.func_70694_bm() != null && ((stack = event.entityPlayer.func_70694_bm()).func_77973_b() == ItemsRegistry.corruptedAxe || stack.func_77973_b() == ItemsRegistry.corruptedShovel || stack.func_77973_b() == ItemsRegistry.corruptedPickaxe)) {
            int corruption = SoulCorruptionHelper.getCorruptionLevel(event.entityPlayer);
            event.newSpeed = event.originalSpeed * (float)(corruption / ConfigHandler.minimumToolCorruption);
        }
    }

    public static class ClientEventHandler {
        private static float renderTicks;
        private static long tickTime;

        @SubscribeEvent(priority=EventPriority.HIGHEST)
        public void onSanguimancyItemTooltip(ItemTooltipEvent event) {
            GameRegistry.UniqueIdentifier id;
            ItemStack stack = event.itemStack;
            if (stack != null && (id = GameRegistry.findUniqueIdentifierFor((Item)stack.func_77973_b())) != null && id.modId.equals("Sanguimancy") && stack.field_77990_d != null && stack.field_77990_d.func_74764_b("ownerName") && GuiScreen.func_146272_n()) {
                event.toolTip.add(StatCollector.func_74838_a((String)"info.Sanguimancy.tooltip.owner") + ": " + stack.field_77990_d.func_74779_i("ownerName"));
            }
        }

        @SubscribeEvent
        public void onRenderPlayerSpecialAntlers(RenderPlayerEvent.Specials.Post event) {
            String[] names;
            for (String name : names = new String[]{"Tombenpotter", "TehNut", "WayofFlowingTime", "Jadedcat", "Kris1432", "Drullkus", "TheOrangeGenius", "Direwolf20", "Pahimar", "ValiarMarcus", "Alex_hawks", "StoneWaves", "DemoXin", "insaneau"}) {
                if (!event.entityPlayer.func_70005_c_().equalsIgnoreCase(name)) continue;
                GL11.glPushMatrix();
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                Minecraft.func_71410_x().field_71446_o.func_110577_a(new ResourceLocation("sanguimancy:textures/items/Wand.png"));
                GL11.glTranslatef((float)0.0f, (float)-0.95f, (float)-0.125f);
                Tessellator tesselator = Tessellator.field_78398_a;
                GL11.glPushMatrix();
                GL11.glRotatef((float)-20.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                GL11.glRotatef((float)-5.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                tesselator.func_78382_b();
                tesselator.func_78374_a(0.0, 0.0, 0.0, 0.0, 0.0);
                tesselator.func_78374_a(0.0, 1.0, 0.0, 0.0, 1.0);
                tesselator.func_78374_a(1.0, 1.0, 0.0, 1.0, 1.0);
                tesselator.func_78374_a(1.0, 0.0, 0.0, 1.0, 0.0);
                tesselator.func_78381_a();
                GL11.glPopMatrix();
                GL11.glPushMatrix();
                GL11.glRotatef((float)5.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                GL11.glRotatef((float)20.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                tesselator.func_78382_b();
                tesselator.func_78374_a(0.0, 0.0, 0.0, 0.0, 0.0);
                tesselator.func_78374_a(0.0, 1.0, 0.0, 0.0, 1.0);
                tesselator.func_78374_a(-1.0, 1.0, 0.0, 1.0, 1.0);
                tesselator.func_78374_a(-1.0, 0.0, 0.0, 1.0, 0.0);
                tesselator.func_78381_a();
                GL11.glPopMatrix();
                GL11.glPopMatrix();
            }
        }

        @SubscribeEvent
        public void onRenderTick(TickEvent.RenderTickEvent event) {
            renderTicks = event.renderTickTime;
        }

        @SubscribeEvent
        public void onClientTick(TickEvent.ClientTickEvent event) {
            ++tickTime;
        }

        private float render() {
            return (float)tickTime + renderTicks;
        }

        @SubscribeEvent
        public void onRenderPlayerFish(RenderPlayerEvent.Specials.Post event) {
            if (ConfigHandler.renderSillyAprilFish && Sanguimancy.isAprilFools) {
                GL11.glPushMatrix();
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                Minecraft.func_71410_x().field_71446_o.func_110577_a(new ResourceLocation("sanguimancy:textures/items/AprilFish.png"));
                GL11.glTranslatef((float)0.0f, (float)-0.95f, (float)0.0f);
                Tessellator tesselator = Tessellator.field_78398_a;
                float flap = (1.0f + (float)Math.cos(this.render() / 4.0f)) * 13.0f;
                GL11.glPushMatrix();
                GL11.glRotatef((float)-20.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                GL11.glRotatef((float)(-flap), (float)0.0f, (float)1.0f, (float)0.0f);
                tesselator.func_78382_b();
                tesselator.func_78374_a(0.0, 0.0, 0.0, 0.0, 0.0);
                tesselator.func_78374_a(0.0, 1.0, 0.0, 0.0, 1.0);
                tesselator.func_78374_a(1.0, 1.0, 0.0, 1.0, 1.0);
                tesselator.func_78374_a(1.0, 0.0, 0.0, 1.0, 0.0);
                tesselator.func_78381_a();
                GL11.glPopMatrix();
                GL11.glPushMatrix();
                GL11.glRotatef((float)flap, (float)0.0f, (float)1.0f, (float)0.0f);
                GL11.glRotatef((float)20.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                tesselator.func_78382_b();
                tesselator.func_78374_a(0.0, 0.0, 0.0, 0.0, 0.0);
                tesselator.func_78374_a(0.0, 1.0, 0.0, 0.0, 1.0);
                tesselator.func_78374_a(-1.0, 1.0, 0.0, 1.0, 1.0);
                tesselator.func_78374_a(-1.0, 0.0, 0.0, 1.0, 0.0);
                tesselator.func_78381_a();
                GL11.glPopMatrix();
                GL11.glPopMatrix();
            }
        }

        @SubscribeEvent
        public void prePlayerRender(RenderPlayerEvent.Pre event) {
            if (SoulCorruptionHelper.getClientPlayerCorruption() >= 20) {
                GL11.glPushMatrix();
                GL11.glDisable((int)2929);
                GL11.glColor3f((float)255.0f, (float)0.0f, (float)0.0f);
                GL11.glPopMatrix();
            }
        }

        @SubscribeEvent
        public void postPlayerRender(RenderPlayerEvent.Post event) {
            if (SoulCorruptionHelper.getClientPlayerCorruption() >= 20) {
                GL11.glPushMatrix();
                GL11.glEnable((int)2929);
                GL11.glPopMatrix();
            }
        }

        static {
            tickTime = 0L;
        }
    }
}

