/*
 * Decompiled with CFR 0.152.
 */
package tombenpotter.sanguimancy.tile;

import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import tombenpotter.sanguimancy.api.tile.TileBase;

public class TileBloodTank
extends TileBase
implements IFluidHandler {
    public int capacity;
    public FluidTank tank;

    public TileBloodTank() {
        this.capacity = 16000;
        this.tank = new FluidTank(this.capacity);
        this.customNBTTag = new NBTTagCompound();
    }

    public TileBloodTank(int capacity) {
        this.tank = new FluidTank(capacity *= 1000);
        this.customNBTTag = new NBTTagCompound();
    }

    public void func_145845_h() {
        if (this.field_145850_b.func_72820_D() % 60L == 0L) {
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        return this.tank.fill(resource, doFill);
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        return this.tank.drain(resource.amount, doDrain);
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return this.tank.drain(maxDrain, doDrain);
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return true;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return true;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return new FluidTankInfo[]{this.tank.getInfo()};
    }

    @Override
    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.tank.readFromNBT(tagCompound.func_74775_l("tank"));
        this.capacity = tagCompound.func_74762_e("capacity");
    }

    @Override
    public void func_145841_b(NBTTagCompound tagCompound) {
        super.func_145841_b(tagCompound);
        if (this.tank.getFluidAmount() != 0) {
            tagCompound.func_74782_a("tank", (NBTBase)this.tank.writeToNBT(new NBTTagCompound()));
        }
        tagCompound.func_74768_a("capacity", this.capacity);
    }
}

