/*
 * Decompiled with CFR 0.152.
 */
package tombenpotter.sanguimancy.items.corrupted;

import WayofTime.alchemicalWizardry.common.items.EnergyItems;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemSpade;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.event.world.BlockEvent;
import tombenpotter.sanguimancy.Sanguimancy;
import tombenpotter.sanguimancy.api.objects.BlockAndMetadata;
import tombenpotter.sanguimancy.api.soulCorruption.SoulCorruptionHelper;
import tombenpotter.sanguimancy.registry.ItemsRegistry;
import tombenpotter.sanguimancy.util.ConfigHandler;
import tombenpotter.sanguimancy.util.RandomUtils;
import tombenpotter.sanguimancy.util.SanguimancyItemStacks;

public class ItemCorruptedShovel
extends ItemSpade {
    public int minimumCorruption = ConfigHandler.minimumToolCorruption;
    public IIcon breakingDown;
    public IIcon goldDigger;
    public IIcon transmutation;
    private HashMap<BlockAndMetadata, BlockAndMetadata> breakdownBlocks = new HashMap();
    private HashMap<BlockAndMetadata, BlockAndMetadata> transmuteBlocks = new HashMap();

    public ItemCorruptedShovel(Item.ToolMaterial material) {
        super(material);
        this.func_77637_a(Sanguimancy.tabSanguimancy);
        this.func_77655_b("Sanguimancy.corruptedShovel");
        this.func_77656_e(0);
        this.setbreakdownBlocks();
        this.setTransmuteBlocks();
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister ir) {
        this.field_77791_bV = ir.func_94245_a("sanguimancy:CorruptedShovel");
        this.breakingDown = ir.func_94245_a("sanguimancy:CorruptedShovel_BreakDown");
        this.goldDigger = ir.func_94245_a("sanguimancy:CorruptedShovel_GoldDigger");
        this.transmutation = ir.func_94245_a("sanguimancy:CorruptedShovel_Transmute");
    }

    public IIcon getIcon(ItemStack stack, int pass) {
        if (this.getToolMode(stack) == 1) {
            return this.breakingDown;
        }
        if (this.getToolMode(stack) == 2) {
            return this.goldDigger;
        }
        if (this.getToolMode(stack) == 3) {
            return this.transmutation;
        }
        return this.field_77791_bV;
    }

    public boolean func_150894_a(ItemStack stack, World world, Block block, int x, int y, int z, EntityLivingBase entityLivingBase) {
        if (block.func_149712_f(world, x, y, z) >= 0.0f) {
            RandomUtils.checkAndSetCompound(stack);
            int toolMode = this.getToolMode(stack);
            int metadata = world.func_72805_g(x, y, z);
            int lpConsumption = 10;
            if (toolMode == 0) {
                RandomUtils.dropBlockDropsWithFortune(world, block, x, y, z, metadata, 0);
                world.func_147468_f(x, y, z);
            } else if (toolMode == 2) {
                lpConsumption *= 7;
                if (block == Blocks.field_150351_n) {
                    ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
                    if (world.field_73012_v.nextInt(200) == 0) {
                        drops.add(new ItemStack(Items.field_151045_i));
                    }
                    if (world.field_73012_v.nextInt(300) == 0) {
                        drops.add(new ItemStack(Items.field_151166_bC));
                    }
                    if (world.field_73012_v.nextInt(100) == 0) {
                        drops.add(new ItemStack(Items.field_151074_bl));
                    }
                    for (ItemStack drop : drops) {
                        RandomUtils.dropItemStackInWorld(world, x, y, z, drop);
                    }
                } else {
                    RandomUtils.dropBlockDropsWithFortune(world, block, x, y, z, metadata, 0);
                }
                world.func_147468_f(x, y, z);
            }
            if (entityLivingBase instanceof EntityPlayer) {
                EntityPlayer player = (EntityPlayer)entityLivingBase;
                EnergyItems.syphonBatteries((ItemStack)stack, (EntityPlayer)player, (int)lpConsumption);
                if (this.getToolMode(stack) != 0 && world.field_73012_v.nextInt(20) == 0) {
                    SoulCorruptionHelper.incrementCorruption(world.func_72924_a(RandomUtils.getItemOwner(stack)));
                }
            }
        }
        return this.getToolMode(stack) != 1 && this.getToolMode(stack) != 3;
    }

    public int getToolMode(ItemStack stack) {
        if (stack != null) {
            RandomUtils.checkAndSetCompound(stack);
            return stack.field_77990_d.func_74762_e("ToolMode");
        }
        return 0;
    }

    public void setToolMode(ItemStack stack, int mode) {
        RandomUtils.checkAndSetCompound(stack);
        stack.field_77990_d.func_74768_a("ToolMode", mode);
    }

    public void nextToolMode(ItemStack stack) {
        RandomUtils.checkAndSetCompound(stack);
        if (stack.field_77990_d.func_74762_e("ToolMode") + 1 <= 3) {
            this.setToolMode(stack, stack.field_77990_d.func_74762_e("ToolMode") + 1);
        } else {
            stack.field_77990_d.func_74768_a("ToolMode", 0);
            this.setToolMode(stack, 0);
        }
    }

    public void func_77622_d(ItemStack stack, World world, EntityPlayer player) {
        RandomUtils.checkAndSetCompound(stack);
        this.setToolMode(stack, 0);
        super.func_77622_d(stack, world, player);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean par4) {
        if (!GuiScreen.func_146272_n()) {
            list.add(StatCollector.func_74838_a((String)"info.Sanguimancy.tooltip.shift.info"));
        } else if (stack.func_77942_o()) {
            list.add(StatCollector.func_74838_a((String)"info.Sanguimancy.tooltip.mode") + ": " + this.tooltipForMode(stack.field_77990_d.func_74762_e("ToolMode")));
            list.add(StatCollector.func_74838_a((String)"info.Sanguimancy.tooltip.minimum.corruption.1"));
            list.add(StatCollector.func_74838_a((String)"info.Sanguimancy.tooltip.minimum.corruption.2") + ": " + String.valueOf(this.minimumCorruption));
        }
    }

    public String tooltipForMode(int modeID) {
        String mode = StatCollector.func_74838_a((String)"info.Sanguimancy.tooltip.mode.regular");
        if (modeID == 1) {
            mode = StatCollector.func_74838_a((String)"info.Sanguimancy.tooltip.shovel.mode.break.down");
        } else if (modeID == 2) {
            mode = StatCollector.func_74838_a((String)"info.Sanguimancy.tooltip.shovel.mode.lucky");
        } else if (modeID == 3) {
            mode = StatCollector.func_74838_a((String)"info.Sanguimancy.tooltip.shovel.mode.transmute");
        }
        return mode;
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        EnergyItems.checkAndSetItemOwner((ItemStack)stack, (EntityPlayer)player);
        if (player.func_70093_af()) {
            this.nextToolMode(stack);
        }
        return stack;
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int par4, boolean par5) {
        RandomUtils.checkAndSetCompound(stack);
        stack.func_77964_b(0);
        super.func_77663_a(stack, world, entity, par4, par5);
    }

    public void setbreakdownBlocks() {
        this.breakdownBlocks.put(new BlockAndMetadata(Blocks.field_150348_b), new BlockAndMetadata(Blocks.field_150347_e));
        this.breakdownBlocks.put(new BlockAndMetadata(Blocks.field_150347_e), new BlockAndMetadata(Blocks.field_150351_n));
        this.breakdownBlocks.put(new BlockAndMetadata(Blocks.field_150351_n), new BlockAndMetadata((Block)Blocks.field_150354_m));
        this.breakdownBlocks.put(new BlockAndMetadata(Blocks.field_150359_w), new BlockAndMetadata(Blocks.field_150410_aZ));
        this.breakdownBlocks.put(new BlockAndMetadata(Blocks.field_150339_S), new BlockAndMetadata(Blocks.field_150411_aY));
        this.breakdownBlocks.put(new BlockAndMetadata(Blocks.field_150336_V), new BlockAndMetadata(Blocks.field_150405_ch));
        this.breakdownBlocks.put(new BlockAndMetadata(Blocks.field_150405_ch), new BlockAndMetadata(Blocks.field_150435_aG));
        this.breakdownBlocks.put(new BlockAndMetadata(Blocks.field_150417_aV), new BlockAndMetadata(Blocks.field_150417_aV, 2));
    }

    public void setTransmuteBlocks() {
        this.transmuteBlocks.put(new BlockAndMetadata((Block)Blocks.field_150354_m), new BlockAndMetadata(Blocks.field_150435_aG));
        this.transmuteBlocks.put(new BlockAndMetadata(Blocks.field_150346_d), new BlockAndMetadata((Block)Blocks.field_150349_c));
        this.transmuteBlocks.put(new BlockAndMetadata((Block)Blocks.field_150349_c), new BlockAndMetadata(Blocks.field_150346_d, 2));
        this.transmuteBlocks.put(new BlockAndMetadata(Blocks.field_150435_aG), new BlockAndMetadata(Blocks.field_150405_ch));
        this.transmuteBlocks.put(new BlockAndMetadata(Blocks.field_150405_ch), new BlockAndMetadata(Blocks.field_150336_V));
        this.transmuteBlocks.put(new BlockAndMetadata(Blocks.field_150395_bd), new BlockAndMetadata(Blocks.field_150392_bi));
        this.transmuteBlocks.put(new BlockAndMetadata(Blocks.field_150343_Z), new BlockAndMetadata(Blocks.field_150377_bs));
        this.transmuteBlocks.put(new BlockAndMetadata(Blocks.field_150451_bX), new BlockAndMetadata(Blocks.field_150426_aN));
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void drawTransmutationsAndBreakdowns(RenderWorldLastEvent event) {
        block6: {
            Minecraft minecraft = Minecraft.func_71410_x();
            EntityClientPlayerMP player = minecraft.field_71439_g;
            WorldClient world = minecraft.field_71441_e;
            MovingObjectPosition mop = minecraft.field_71476_x;
            if (mop == null) break block6;
            int x = mop.field_72311_b;
            int y = mop.field_72312_c;
            int z = mop.field_72309_d;
            Block block = minecraft.field_71441_e.func_147439_a(x, y, z);
            int metadata = world.func_72805_g(x, y, z);
            if (player.func_70694_bm() != null && player.func_70694_bm().func_77973_b() == ItemsRegistry.corruptedShovel) {
                if (this.getToolMode(player.func_70694_bm()) == 3 && this.transmuteBlocks.containsKey(new BlockAndMetadata(block, minecraft.field_71441_e.func_72805_g(x, y, z)))) {
                    Block resultingBlock = this.transmuteBlocks.get((Object)new BlockAndMetadata((Block)block, (int)metadata)).block;
                    int resultingMeta = this.transmuteBlocks.get((Object)new BlockAndMetadata((Block)block, (int)metadata)).metadata;
                    for (ForgeDirection d : ForgeDirection.VALID_DIRECTIONS) {
                        if (!world.func_147437_c(x + d.offsetX, y + d.offsetY, z + d.offsetZ)) continue;
                        RandomUtils.renderBlock(event, (EntityPlayer)player, (World)world, resultingBlock, resultingMeta, x + d.offsetX, y + d.offsetY, z + d.offsetZ);
                        break;
                    }
                } else if (this.getToolMode(player.func_70694_bm()) == 1 && this.breakdownBlocks.containsKey(new BlockAndMetadata(block, minecraft.field_71441_e.func_72805_g(x, y, z)))) {
                    Block resultingBlock = this.breakdownBlocks.get((Object)new BlockAndMetadata((Block)block, (int)metadata)).block;
                    int resultingMeta = this.breakdownBlocks.get((Object)new BlockAndMetadata((Block)block, (int)metadata)).metadata;
                    for (ForgeDirection d : ForgeDirection.VALID_DIRECTIONS) {
                        if (!world.func_147437_c(x + d.offsetX, y + d.offsetY, z + d.offsetZ)) continue;
                        RandomUtils.renderBlock(event, (EntityPlayer)player, (World)world, resultingBlock, resultingMeta, x + d.offsetX, y + d.offsetY, z + d.offsetZ);
                        break;
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public void onBlockBrokenByCorruptedShovel(BlockEvent.BreakEvent event) {
        Block block = event.block;
        int metadata = event.blockMetadata;
        ItemStack stack = event.getPlayer().func_70694_bm();
        EntityPlayer player = event.getPlayer();
        World world = event.world;
        int x = event.x;
        int y = event.y;
        int z = event.z;
        if (stack != null && stack.func_77969_a(SanguimancyItemStacks.corruptedShovel)) {
            int lpConsumption = 10;
            int toolMode = this.getToolMode(stack);
            if (toolMode == 1) {
                lpConsumption *= 5;
                if (this.breakdownBlocks.containsKey(new BlockAndMetadata(block, metadata))) {
                    Block bb = this.breakdownBlocks.get((Object)new BlockAndMetadata((Block)block, (int)metadata)).block;
                    int meta = this.breakdownBlocks.get((Object)new BlockAndMetadata((Block)block, (int)metadata)).metadata;
                    world.func_147465_d(x, y, z, bb, meta, 3);
                    event.setCanceled(true);
                } else {
                    RandomUtils.dropBlockDropsWithFortune(world, block, x, y, z, metadata, 0);
                    world.func_147468_f(x, y, z);
                }
            } else if (toolMode == 3) {
                lpConsumption *= 10;
                if (this.transmuteBlocks.containsKey(new BlockAndMetadata(block, metadata))) {
                    Block bb = this.transmuteBlocks.get((Object)new BlockAndMetadata((Block)block, (int)metadata)).block;
                    int meta = this.transmuteBlocks.get((Object)new BlockAndMetadata((Block)block, (int)metadata)).metadata;
                    world.func_147465_d(x, y, z, bb, meta, 3);
                    event.setCanceled(true);
                } else {
                    RandomUtils.dropBlockDropsWithFortune(world, block, x, y, z, metadata, 0);
                    world.func_147468_f(x, y, z);
                }
            }
            EnergyItems.syphonBatteries((ItemStack)stack, (EntityPlayer)player, (int)lpConsumption);
            if (this.getToolMode(stack) != 0 && world.field_73012_v.nextInt(20) == 0) {
                SoulCorruptionHelper.incrementCorruption(world.func_72924_a(RandomUtils.getItemOwner(stack)));
            }
        }
    }

    public boolean func_77644_a(ItemStack stack, EntityLivingBase target, EntityLivingBase attacker) {
        if (attacker instanceof EntityPlayer) {
            EnergyItems.syphonBatteries((ItemStack)stack, (EntityPlayer)((EntityPlayer)attacker), (int)15);
        }
        return true;
    }
}

